/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.xmla;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.olap.JROlapDataSource;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.xmla.JRXmlaCell;
import net.sf.jasperreports.olap.xmla.JRXmlaHierarchy;
import net.sf.jasperreports.olap.xmla.JRXmlaMember;
import net.sf.jasperreports.olap.xmla.JRXmlaMemberTuple;
import net.sf.jasperreports.olap.xmla.JRXmlaResult;
import net.sf.jasperreports.olap.xmla.JRXmlaResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class JRXmlaQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRXmlaQueryExecuter.class);
    public static final String EXCEPTION_MESSAGE_KEY_XMLA_CANNOT_RETRIEVE_ELEMENT = "data.olap.xmla.cannot.retrieve.element";
    public static final String EXCEPTION_MESSAGE_KEY_MESSAGE_CALL_FAILED = "data.olap.xmla.message.call.failed";
    public static final String EXCEPTION_MESSAGE_KEY_XMLA_NO_LEVEL_NAME = "data.olap.xmla.no.level.name";
    public static final String EXCEPTION_MESSAGE_KEY_XMLA_NULL_ELEMENT = "data.olap.xmla.null.element";
    private static final String SLICER_AXIS_NAME = "SlicerAxis";
    private static final String MDD_URI = "urn:schemas-microsoft-com:xml-analysis:mddataset";
    private static final String XMLA_URI = "urn:schemas-microsoft-com:xml-analysis";
    private static final String LEVEL_UNIQUE_NAME_PATTERN_DEFINITION = "\\[[^\\]]+\\]\\.\\[([^\\]]+)\\]";
    private static final Pattern LEVEL_UNIQUE_NAME_PATTERN = Pattern.compile("\\[[^\\]]+\\]\\.\\[([^\\]]+)\\]");
    private static final int LEVEL_UNIQUE_NAME_PATTERN_NAME_GROUP = 1;
    private static final String HIERARCHY_LEVEL_UNIQUE_NAME_PATTERN_DEFINITION = "\\[[^\\]]+\\]\\.\\[([^\\]]+)\\]\\.\\[([^\\]]+)\\]";
    private static final Pattern HIERARCHY_LEVEL_UNIQUE_NAME_PATTERN = Pattern.compile("\\[[^\\]]+\\]\\.\\[([^\\]]+)\\]\\.\\[([^\\]]+)\\]");
    private static final int HIERARCHY_LEVEL_UNIQUE_NAME_PATTERN_NAME_GROUP = 2;
    private SOAPFactory sf;
    private SOAPConnection connection;
    private JRXmlaResult xmlaResult;

    public JRXmlaQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        this.parseQuery();
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return "MDX";
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    public JROlapResult getResult() {
        try {
            this.sf = SOAPFactory.newInstance();
            this.connection = this.createSOAPConnection();
            SOAPMessage queryMessage = this.createQueryMessage();
            URL soapURL = new URL(this.getSoapUrl());
            SOAPMessage resultMessage = this.executeQuery(queryMessage, soapURL);
            this.xmlaResult = new JRXmlaResult();
            this.parseResult(resultMessage);
        }
        catch (MalformedURLException e) {
            throw new JRRuntimeException(e);
        }
        catch (SOAPException e) {
            throw new JRRuntimeException(e);
        }
        return this.xmlaResult;
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        this.getResult();
        return new JROlapDataSource(this.dataset, this.xmlaResult);
    }

    protected String getSoapUrl() throws MalformedURLException {
        String soapUrl;
        String xmlaUrl = (String)this.getParameterValue("XMLA_URL");
        String user = (String)this.getParameterValue("XMLA_USER", true);
        if (user == null || user.length() == 0) {
            soapUrl = xmlaUrl;
        } else {
            URL url = new URL(xmlaUrl);
            soapUrl = url.getProtocol() + "://" + user;
            String password = (String)this.getParameterValue("XMLA_PASSWORD", true);
            if (password != null && password.length() > 0) {
                soapUrl = soapUrl + ":" + password;
            }
            soapUrl = soapUrl + "@" + url.getHost();
            if (url.getPort() != -1) {
                soapUrl = soapUrl + ":" + url.getPort();
            }
            soapUrl = soapUrl + url.getPath();
        }
        return soapUrl;
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SOAPException e) {
                throw new JRRuntimeException(e);
            }
            this.connection = null;
        }
    }

    protected SOAPConnection createSOAPConnection() {
        try {
            SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
            return scf.createConnection();
        }
        catch (UnsupportedOperationException e) {
            throw new JRRuntimeException(e);
        }
        catch (SOAPException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected SOAPMessage createQueryMessage() {
        String queryStr = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug("MDX query: " + queryStr);
        }
        try {
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage message = mf.createMessage();
            MimeHeaders mh = message.getMimeHeaders();
            mh.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Execute\"");
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody body = envelope.getBody();
            Name nEx = envelope.createName("Execute", "", XMLA_URI);
            SOAPElement eEx = body.addChildElement(nEx);
            Name nCom = envelope.createName("Command", "", XMLA_URI);
            SOAPElement eCommand = eEx.addChildElement(nCom);
            Name nSta = envelope.createName("Statement", "", XMLA_URI);
            SOAPElement eStatement = eCommand.addChildElement(nSta);
            eStatement.addTextNode(queryStr);
            HashMap<String, String> paraList = new HashMap<String, String>();
            String datasource = (String)this.getParameterValue("XMLA_DATASOURCE");
            paraList.put("DataSourceInfo", datasource);
            String catalog = (String)this.getParameterValue("XMLA_CATALOG");
            paraList.put("Catalog", catalog);
            paraList.put("Format", "Multidimensional");
            paraList.put("AxisFormat", "TupleFormat");
            this.addParameterList(envelope, eEx, "Properties", "PropertyList", paraList);
            message.saveChanges();
            if (log.isDebugEnabled()) {
                log.debug("XML/A query message: \n" + this.prettyPrintSOAP((SOAPElement)message.getSOAPPart().getEnvelope()));
            }
            return message;
        }
        catch (SOAPException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void addParameterList(SOAPEnvelope envelope, SOAPElement eParent, String typeName, String listName, Map<String, String> params) throws SOAPException {
        Name nPara = envelope.createName(typeName, "", XMLA_URI);
        SOAPElement eType = eParent.addChildElement(nPara);
        nPara = envelope.createName(listName, "", XMLA_URI);
        SOAPElement eList = eType.addChildElement(nPara);
        if (params == null) {
            return;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String tag = entry.getKey();
            String value = entry.getValue();
            nPara = envelope.createName(tag, "", XMLA_URI);
            SOAPElement eTag = eList.addChildElement(nPara);
            eTag.addTextNode(value);
        }
    }

    protected SOAPMessage executeQuery(SOAPMessage message, URL url) {
        try {
            return this.connection.call(message, (Object)url);
        }
        catch (SOAPException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MESSAGE_CALL_FAILED, null, e);
        }
    }

    protected void parseResult(SOAPMessage reply) throws SOAPException {
        Object eObj;
        Object eObj2;
        Object eObj3;
        Object eObj4;
        Object eObj5;
        Name eName;
        Iterator responseElements;
        SOAPFault fault;
        SOAPPart soapPart = reply.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPElement eElement = null;
        if (log.isDebugEnabled()) {
            log.debug("XML/A result envelope: " + this.prettyPrintSOAP((SOAPElement)soapEnvelope));
        }
        if ((fault = soapBody.getFault()) != null) {
            this.handleResultFault(fault);
        }
        if ((responseElements = soapBody.getChildElements(eName = soapEnvelope.createName("ExecuteResponse", "", XMLA_URI))).hasNext()) {
            eObj5 = responseElements.next();
            if (eObj5 == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_NULL_ELEMENT, new Object[]{"ExecuteResponse"});
            }
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_CANNOT_RETRIEVE_ELEMENT, new Object[]{"ExecuteResponse"});
        }
        eElement = (SOAPElement)eObj5;
        Name rName = soapEnvelope.createName("return", "", XMLA_URI);
        Iterator returnElements = eElement.getChildElements(rName);
        SOAPElement returnElement = null;
        if (returnElements.hasNext()) {
            Object eObj6 = returnElements.next();
            if (eObj6 == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_NULL_ELEMENT, new Object[]{"return"});
            }
            returnElement = (SOAPElement)eObj6;
        } else {
            Name rName2 = soapEnvelope.createName("return", "", "");
            returnElements = eElement.getChildElements(rName2);
            if (returnElements.hasNext()) {
                Object eObj7 = returnElements.next();
                if (eObj7 == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_NULL_ELEMENT, new Object[]{"return"});
                }
                returnElement = (SOAPElement)eObj7;
            } else {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_CANNOT_RETRIEVE_ELEMENT, new Object[]{"return"});
            }
        }
        Name rootName = soapEnvelope.createName("root", "", MDD_URI);
        SOAPElement rootElement = null;
        Iterator rootElements = returnElement.getChildElements(rootName);
        if (rootElements.hasNext()) {
            eObj4 = rootElements.next();
            if (eObj4 == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_NULL_ELEMENT, new Object[]{"root"});
            }
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_CANNOT_RETRIEVE_ELEMENT, new Object[]{"root"});
        }
        rootElement = (SOAPElement)eObj4;
        Name olapInfoName = soapEnvelope.createName("OlapInfo", "", MDD_URI);
        SOAPElement olapInfoElement = null;
        Iterator olapInfoElements = rootElement.getChildElements(olapInfoName);
        if (olapInfoElements.hasNext()) {
            eObj3 = olapInfoElements.next();
            if (eObj3 == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_NULL_ELEMENT, new Object[]{"OlapInfo"});
            }
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_CANNOT_RETRIEVE_ELEMENT, new Object[]{"OlapInfo"});
        }
        olapInfoElement = (SOAPElement)eObj3;
        this.parseOLAPInfoElement(olapInfoElement);
        Name axesName = soapEnvelope.createName("Axes", "", MDD_URI);
        SOAPElement axesElement = null;
        Iterator axesElements = rootElement.getChildElements(axesName);
        if (axesElements.hasNext()) {
            eObj2 = axesElements.next();
            if (eObj2 == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_NULL_ELEMENT, new Object[]{"Axes"});
            }
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_CANNOT_RETRIEVE_ELEMENT, new Object[]{"Axes"});
        }
        axesElement = (SOAPElement)eObj2;
        this.parseAxesElement(axesElement);
        Name cellDataName = soapEnvelope.createName("CellData", "", MDD_URI);
        SOAPElement cellDataElement = null;
        Iterator cellDataElements = rootElement.getChildElements(cellDataName);
        if (cellDataElements.hasNext()) {
            eObj = cellDataElements.next();
            if (eObj == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_NULL_ELEMENT, new Object[]{"CellData"});
            }
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_CANNOT_RETRIEVE_ELEMENT, new Object[]{"CellData"});
        }
        cellDataElement = (SOAPElement)eObj;
        this.parseCellDataElement(cellDataElement);
    }

    protected void handleResultFault(SOAPFault fault) {
        String faultCode;
        String faultActor;
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("XML/A fault: ");
        String faultString = fault.getFaultString();
        if (faultString != null) {
            errorMsg.append(faultString);
            errorMsg.append("; ");
        }
        if ((faultActor = fault.getFaultActor()) != null) {
            errorMsg.append("Actor: ");
            errorMsg.append(faultActor);
            errorMsg.append("; ");
        }
        if ((faultCode = fault.getFaultCode()) != null) {
            errorMsg.append("Code: ");
            errorMsg.append(faultCode);
            errorMsg.append("; ");
        }
        throw new JRRuntimeException(errorMsg.toString());
    }

    protected void parseOLAPInfoElement(SOAPElement olapInfoElement) throws SOAPException {
        Object axesObj;
        Name axesInfoName = this.sf.createName("AxesInfo", "", MDD_URI);
        SOAPElement axesElement = null;
        Iterator axesInfoElements = olapInfoElement.getChildElements(axesInfoName);
        if (axesInfoElements.hasNext()) {
            axesObj = axesInfoElements.next();
            if (axesObj == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_NULL_ELEMENT, new Object[]{"AxesInfo"});
            }
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_CANNOT_RETRIEVE_ELEMENT, new Object[]{"AxesInfo"});
        }
        axesElement = (SOAPElement)axesObj;
        this.parseAxesInfoElement(axesElement);
    }

    protected void parseAxesInfoElement(SOAPElement axesInfoElement) throws SOAPException {
        Name axisInfoName = this.sf.createName("AxisInfo", "", MDD_URI);
        Iterator itAxis = axesInfoElement.getChildElements(axisInfoName);
        while (itAxis.hasNext()) {
            Name name;
            SOAPElement axisElement = (SOAPElement)itAxis.next();
            String axisName = axisElement.getAttributeValue(name = this.sf.createName("name"));
            if (axisName.equals(SLICER_AXIS_NAME)) continue;
            JRXmlaResultAxis axis = new JRXmlaResultAxis(axisName);
            this.xmlaResult.addAxis(axis);
            if (log.isDebugEnabled()) {
                log.debug("adding axis: " + axis.getAxisName());
            }
            name = this.sf.createName("HierarchyInfo", "", MDD_URI);
            Iterator itHierInfo = axisElement.getChildElements(name);
            while (itHierInfo.hasNext()) {
                SOAPElement eHierInfo = (SOAPElement)itHierInfo.next();
                this.handleHierInfo(axis, eHierInfo);
            }
        }
    }

    protected void parseAxesElement(SOAPElement axesElement) throws SOAPException {
        Name aName = this.sf.createName("Axis", "", MDD_URI);
        Iterator itAxis = axesElement.getChildElements(aName);
        while (itAxis.hasNext()) {
            Name name;
            SOAPElement axisElement = (SOAPElement)itAxis.next();
            String axisName = axisElement.getAttributeValue(name = this.sf.createName("name"));
            if (axisName.equals(SLICER_AXIS_NAME)) continue;
            JRXmlaResultAxis axis = this.xmlaResult.getAxisByName(axisName);
            name = this.sf.createName("Tuples", "", MDD_URI);
            Iterator itTuples = axisElement.getChildElements(name);
            if (!itTuples.hasNext()) continue;
            SOAPElement eTuples = (SOAPElement)itTuples.next();
            this.handleTuplesElement(axis, eTuples);
        }
    }

    protected void parseCellDataElement(SOAPElement cellDataElement) throws SOAPException {
        Name name = this.sf.createName("Cell", "", MDD_URI);
        Iterator itCells = cellDataElement.getChildElements(name);
        while (itCells.hasNext()) {
            Name errorName;
            SOAPElement cellElement = (SOAPElement)itCells.next();
            Iterator errorElems = cellElement.getChildElements(errorName = this.sf.createName("Error", "", MDD_URI));
            if (errorElems.hasNext()) {
                this.handleCellErrors(errorElems);
            }
            Name ordinalName = this.sf.createName("CellOrdinal");
            String cellOrdinal = cellElement.getAttributeValue(ordinalName);
            Object value = null;
            Iterator valueElements = cellElement.getChildElements(this.sf.createName("Value", "", MDD_URI));
            if (valueElements.hasNext()) {
                SOAPElement valueElement = (SOAPElement)valueElements.next();
                String valueType = valueElement.getAttribute("xsi:type");
                value = valueType.equals("xsd:int") ? new Long(valueElement.getValue()) : (valueType.equals("xsd:double") ? new Double(valueElement.getValue()) : (valueType.equals("xsd:decimal") ? new Double(valueElement.getValue()) : valueElement.getValue()));
            }
            String fmtValue = "";
            Iterator fmtValueElements = cellElement.getChildElements(this.sf.createName("FmtValue", "", MDD_URI));
            if (fmtValueElements.hasNext()) {
                SOAPElement fmtValueElement = (SOAPElement)fmtValueElements.next();
                fmtValue = fmtValueElement.getValue();
            }
            int pos = Integer.parseInt(cellOrdinal);
            JRXmlaCell cell = new JRXmlaCell(value, fmtValue);
            this.xmlaResult.setCell(cell, pos);
        }
    }

    protected void handleCellErrors(Iterator<?> errorElems) throws SOAPException {
        Iterator codeElems;
        Iterator sourceElems;
        SOAPElement errorElem = (SOAPElement)errorElems.next();
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("Cell error: ");
        Iterator descriptionElems = errorElem.getChildElements(this.sf.createName("Description", "", MDD_URI));
        if (descriptionElems.hasNext()) {
            SOAPElement descrElem = (SOAPElement)descriptionElems.next();
            errorMsg.append(descrElem.getValue());
            errorMsg.append("; ");
        }
        if ((sourceElems = errorElem.getChildElements(this.sf.createName("Source", "", MDD_URI))).hasNext()) {
            SOAPElement sourceElem = (SOAPElement)sourceElems.next();
            errorMsg.append("Source: ");
            errorMsg.append(sourceElem.getValue());
            errorMsg.append("; ");
        }
        if ((codeElems = errorElem.getChildElements(this.sf.createName("ErrorCode", "", MDD_URI))).hasNext()) {
            SOAPElement codeElem = (SOAPElement)codeElems.next();
            errorMsg.append("Code: ");
            errorMsg.append(codeElem.getValue());
            errorMsg.append("; ");
        }
        throw new JRRuntimeException(errorMsg.toString());
    }

    protected void handleHierInfo(JRXmlaResultAxis axis, SOAPElement hierInfoElement) throws SOAPException {
        Name name = this.sf.createName("name");
        String dimName = hierInfoElement.getAttributeValue(name);
        if (log.isDebugEnabled()) {
            log.debug("Adding hierarchy: " + dimName);
        }
        JRXmlaHierarchy hier = new JRXmlaHierarchy(dimName);
        axis.addHierarchy(hier);
    }

    protected void handleTuplesElement(JRXmlaResultAxis axis, SOAPElement tuplesElement) throws SOAPException {
        Name tName = this.sf.createName("Tuple", "", MDD_URI);
        Iterator itTuple = tuplesElement.getChildElements(tName);
        while (itTuple.hasNext()) {
            SOAPElement eTuple = (SOAPElement)itTuple.next();
            this.handleTupleElement(axis, eTuple);
        }
    }

    protected void handleTupleElement(JRXmlaResultAxis axis, SOAPElement tupleElement) throws SOAPException {
        JRXmlaMemberTuple tuple = new JRXmlaMemberTuple(axis.getHierarchiesOnAxis().length);
        Name memName = this.sf.createName("Member", "", MDD_URI);
        Iterator itMember = tupleElement.getChildElements(memName);
        int memNum = 0;
        while (itMember.hasNext()) {
            SOAPElement memElement = (SOAPElement)itMember.next();
            Name name = this.sf.createName("Hierarchy", "", "");
            String hierName = memElement.getAttributeValue(name);
            String uName = "";
            Iterator uNameElements = memElement.getChildElements(this.sf.createName("UName", "", MDD_URI));
            if (uNameElements.hasNext()) {
                uName = ((SOAPElement)uNameElements.next()).getValue();
            }
            String caption = "";
            Iterator captionElements = memElement.getChildElements(this.sf.createName("Caption", "", MDD_URI));
            if (captionElements.hasNext()) {
                caption = ((SOAPElement)captionElements.next()).getValue();
            }
            String lName = "";
            Iterator lNameElements = memElement.getChildElements(this.sf.createName("LName", "", MDD_URI));
            if (lNameElements.hasNext()) {
                String levelUniqueName = ((SOAPElement)lNameElements.next()).getValue();
                Matcher matcher = LEVEL_UNIQUE_NAME_PATTERN.matcher(levelUniqueName);
                if (matcher.matches()) {
                    lName = matcher.group(1);
                } else {
                    matcher = HIERARCHY_LEVEL_UNIQUE_NAME_PATTERN.matcher(levelUniqueName);
                    if (matcher.matches()) {
                        lName = matcher.group(2);
                    } else {
                        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_NO_LEVEL_NAME, new Object[]{levelUniqueName});
                    }
                }
            }
            int lNum = 0;
            Iterator lNumElements = memElement.getChildElements(this.sf.createName("LNum", "", MDD_URI));
            if (lNumElements.hasNext()) {
                lNum = Integer.parseInt(((SOAPElement)lNumElements.next()).getValue());
            }
            JRXmlaMember member = new JRXmlaMember(caption, uName, hierName, lName, lNum);
            if (log.isDebugEnabled()) {
                log.debug("Adding member: axis - " + axis.getAxisName() + " hierName - " + hierName + " lName - " + lName + " uName - " + uName);
            }
            tuple.setMember(memNum++, member);
        }
        axis.addTuple(tuple);
    }

    protected String prettyPrintSOAP(SOAPElement element) {
        StringWriter sw = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new DOMSource((Node)element), new StreamResult(sw));
        }
        catch (TransformerException e) {
            throw new JRRuntimeException(e);
        }
        return sw.toString();
    }
}

