/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRImageRenderer
extends JRAbstractRenderer
implements DataRenderable {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(JRImageRenderer.class);
    private byte[] imageData;
    private String imageLocation;
    private ImageTypeEnum imageTypeValue = ImageTypeEnum.UNKNOWN;
    private transient SoftReference<Image> awtImageRef;
    private int PSEUDO_SERIAL_VERSION_UID = 60002;
    private byte imageType;

    protected JRImageRenderer(byte[] imageData) {
        this.imageData = imageData;
        if (imageData != null) {
            this.imageTypeValue = JRTypeSniffer.getImageTypeValue(imageData);
        }
    }

    protected JRImageRenderer(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public static JRImageRenderer getInstance(byte[] imageData) {
        return new JRImageRenderer(imageData);
    }

    public static JRImageRenderer getOnErrorRendererForImage(JasperReportsContext jasperReportsContext, JRImageRenderer renderer, OnErrorTypeEnum onErrorType) throws JRException {
        JRImageRenderer result;
        block2: {
            try {
                renderer.getImage(jasperReportsContext);
                result = renderer;
            }
            catch (Exception e) {
                result = (JRImageRenderer)RenderableUtil.getInstance(jasperReportsContext).handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug("handled image error with type " + onErrorType, e);
            }
        }
        return result;
    }

    public static JRImageRenderer getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRException e) throws JRException {
        return (JRImageRenderer)RenderableUtil.getInstance(DefaultJasperReportsContext.getInstance()).getOnErrorRenderer(onErrorType, e);
    }

    public static JRImageRenderer getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRRuntimeException e) throws JRRuntimeException {
        return (JRImageRenderer)RenderableUtil.getInstance(DefaultJasperReportsContext.getInstance()).getOnErrorRenderer(onErrorType, e);
    }

    public Image getImage(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.awtImageRef == null || this.awtImageRef.get() == null) {
            Image awtImage = JRImageLoader.getInstance(jasperReportsContext).loadAwtImageFromBytes(this.getImageData(jasperReportsContext));
            this.awtImageRef = new SoftReference<Image>(awtImage);
        }
        return this.awtImageRef.get();
    }

    public Image getImage() throws JRException {
        return this.getImage(DefaultJasperReportsContext.getInstance());
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    @Override
    public byte getType() {
        return this.getTypeValue().getValue();
    }

    @Override
    public byte getImageType() {
        return this.getImageTypeValue().getValue();
    }

    @Override
    public RenderableTypeEnum getTypeValue() {
        return RenderableTypeEnum.IMAGE;
    }

    @Override
    public ImageTypeEnum getImageTypeValue() {
        return this.imageTypeValue;
    }

    @Override
    public Dimension2D getDimension() throws JRException {
        return this.getDimension(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) throws JRException {
        Image img = this.getImage(jasperReportsContext);
        return new Dimension(img.getWidth(null), img.getHeight(null));
    }

    @Override
    public byte[] getImageData(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.imageData == null) {
            this.imageData = RepositoryUtil.getInstance(jasperReportsContext).getBytesFromLocation(this.imageLocation);
            if (this.imageData != null) {
                this.imageTypeValue = JRTypeSniffer.getImageTypeValue(this.imageData);
            }
        }
        return this.imageData;
    }

    @Override
    public byte[] getData(JasperReportsContext jasperReportsContext) throws JRException {
        return this.getImageData(jasperReportsContext);
    }

    @Override
    public byte[] getImageData() throws JRException {
        return this.getImageData(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(DefaultJasperReportsContext.getInstance(), grx, rectangle);
    }

    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        Image img = this.getImage(jasperReportsContext);
        grx.drawImage(img, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 40600) {
            this.imageTypeValue = ImageTypeEnum.getByValue(this.imageType);
        }
    }
}

