/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.interactive;

import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.interactive.CrosstabOrderAttributes;
import net.sf.jasperreports.crosstabs.interactive.SortRowGroupData;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import net.sf.jasperreports.web.commands.Command;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SortRowGroupCommand
implements Command {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(SortRowGroupCommand.class);
    private final JRDesignCrosstab crosstab;
    private final SortRowGroupData sortData;
    private JRDesignCrosstabRowGroup rowGroup;
    private boolean lastRowGroup;
    private CrosstabOrderAttributes oldOrderAttributes;
    private BucketOrder newOrder;

    public SortRowGroupCommand(JRDesignCrosstab crosstab, SortRowGroupData sortData) {
        this.crosstab = crosstab;
        this.sortData = sortData;
    }

    @Override
    public void execute() {
        JRCrosstabRowGroup[] rowGroups = this.crosstab.getRowGroups();
        this.rowGroup = (JRDesignCrosstabRowGroup)rowGroups[this.sortData.getGroupIndex()];
        this.lastRowGroup = this.sortData.getGroupIndex() == rowGroups.length - 1;
        this.oldOrderAttributes = new CrosstabOrderAttributes(this.crosstab);
        this.newOrder = this.sortData.getOrder();
        this.setOrder();
    }

    protected void setOrder() {
        this.oldOrderAttributes.prepareSorting();
        if (log.isDebugEnabled()) {
            log.debug("setting crosstab " + this.sortData.getCrosstabId() + " row group " + this.sortData.getGroupIndex() + " order to " + this.newOrder);
        }
        ((JRDesignCrosstabBucket)this.rowGroup.getBucket()).setOrder(this.newOrder);
        if (this.lastRowGroup && this.newOrder != BucketOrder.NONE) {
            this.crosstab.getPropertiesMap().setProperty("net.sf.jasperreports.crosstab.order.by.column", null);
        }
    }

    @Override
    public void undo() {
        this.oldOrderAttributes.restore();
    }

    @Override
    public void redo() {
        this.setOrder();
    }
}

