/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.Comparator;
import net.sf.jasperreports.crosstabs.fill.BucketOrderer;
import net.sf.jasperreports.crosstabs.fill.calculation.ArbitraryRankComparator;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketValueOrderDecorator;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BucketDefinition {
    private static final Log log = LogFactory.getLog(BucketDefinition.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_ORDER_TYPE = "crosstabs.calculation.unsupported.order.type";
    protected static final byte VALUE_TYPE_VALUE = 0;
    protected static final byte VALUE_TYPE_NULL = 1;
    protected static final byte VALUE_TYPE_TOTAL = 2;
    protected final Bucket VALUE_TOTAL = new Bucket(2);
    protected final Bucket VALUE_NULL = new Bucket(1);
    protected final Comparator<Object> bucketValueComparator;
    protected final BucketOrderer orderer;
    private final CrosstabTotalPositionEnum totalPosition;
    private boolean mergeHeaderCells;
    private final BucketOrder order;
    private boolean computeTotal;

    public BucketDefinition(Class<?> valueClass, BucketOrderer orderer, Comparator<Object> comparator, BucketOrder order, CrosstabTotalPositionEnum totalPosition) throws JRException {
        this.orderer = orderer;
        this.order = order;
        if (orderer == null) {
            this.bucketValueComparator = order == BucketOrder.NONE ? null : BucketDefinition.createOrderComparator(comparator, order);
        } else if (Comparable.class.isAssignableFrom(valueClass)) {
            this.bucketValueComparator = ComparableComparator.getInstance();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Using arbitrary rank comparator for bucket");
            }
            this.bucketValueComparator = new ArbitraryRankComparator();
        }
        this.totalPosition = totalPosition;
        this.computeTotal = totalPosition != CrosstabTotalPositionEnum.NONE || orderer != null;
    }

    public static Comparator<Object> createOrderComparator(Comparator<Object> comparator, BucketOrder order) {
        Object orderComparator;
        switch (order) {
            case DESCENDING: {
                if (comparator == null) {
                    orderComparator = new ReverseComparator();
                    break;
                }
                orderComparator = new ReverseComparator(comparator);
                break;
            }
            case ASCENDING: {
                if (comparator == null) {
                    orderComparator = ComparableComparator.getInstance();
                    break;
                }
                orderComparator = comparator;
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_ORDER_TYPE, new Object[]{order});
            }
        }
        return orderComparator;
    }

    public boolean isSorted() {
        return this.bucketValueComparator != null;
    }

    public boolean computeTotal() {
        return this.computeTotal;
    }

    public void setComputeTotal() {
        this.computeTotal = true;
    }

    public CrosstabTotalPositionEnum getTotalPosition() {
        return this.totalPosition;
    }

    public BucketOrderer getOrderer() {
        return this.orderer;
    }

    public BucketOrder getOrder() {
        return this.order;
    }

    public boolean isMergeHeaderCells() {
        return this.mergeHeaderCells;
    }

    public void setMergeHeaderCells(boolean mergeHeaderCells) {
        this.mergeHeaderCells = mergeHeaderCells;
    }

    public Bucket create(Object value) {
        if (value == null) {
            return this.VALUE_NULL;
        }
        if (value instanceof BucketValueOrderDecorator) {
            return new OrderDecoratorBucket((BucketValueOrderDecorator)value);
        }
        return new Bucket(value);
    }

    public class OrderDecoratorBucket
    extends Bucket {
        private BucketValueOrderDecorator.OrderPosition orderPosition;

        protected OrderDecoratorBucket(BucketValueOrderDecorator<?> value) {
            super(value.getValue());
            this.orderPosition = value.getOrderPosition();
        }

        @Override
        public BucketValueOrderDecorator.OrderPosition getOrderPosition() {
            return this.orderPosition;
        }
    }

    public class Bucket
    implements Comparable<Object> {
        private final Object value;
        private final byte type;

        protected Bucket(byte type) {
            this.value = null;
            this.type = type;
        }

        protected Bucket(Object value) {
            this.value = value;
            this.type = 0;
        }

        public Bucket(Object value, byte type) {
            this.value = value;
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Bucket)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Bucket v = (Bucket)o;
            if (this.type != 0) {
                return this.type == v.type;
            }
            return v.type == 0 && this.value.equals(v.value);
        }

        public int hashCode() {
            int hash = this.type;
            if (this.type == 0) {
                hash = 37 * hash + this.value.hashCode();
            }
            return hash;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "NULL";
                }
                case 2: {
                    return "TOTAL";
                }
            }
            return String.valueOf(this.value);
        }

        @Override
        public int compareTo(Object o) {
            BucketValueOrderDecorator.OrderPosition otherOrderPosition;
            Bucket val = (Bucket)o;
            if (this.type != val.type) {
                return this.type - val.type;
            }
            if (this.type != 0) {
                return 0;
            }
            BucketValueOrderDecorator.OrderPosition orderPosition = this.getOrderPosition();
            if (orderPosition != (otherOrderPosition = val.getOrderPosition())) {
                return orderPosition.comparePosition(otherOrderPosition);
            }
            return BucketDefinition.this.bucketValueComparator.compare(this.value, val.value);
        }

        public boolean isTotal() {
            return this.type == 2;
        }

        public BucketValueOrderDecorator.OrderPosition getOrderPosition() {
            return BucketValueOrderDecorator.OrderPosition.NORMAL;
        }
    }
}

