/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.ant;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.ant.JRBaseAntTask;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.RegexpPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class JRAntCompileTask
extends JRBaseAntTask {
    private Path src;
    private File destdir;
    private File tempdir;
    private boolean keepjava;
    private String compiler;
    private Path classpath;
    private boolean xmlvalidation = true;
    private Map<String, String> reportFilesMap;

    public void setSrcdir(Path srcdir) {
        if (this.src == null) {
            this.src = srcdir;
        } else {
            this.src.append(srcdir);
        }
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setTempdir(File tempdir) {
        this.tempdir = tempdir;
    }

    public void setKeepjava(boolean keepjava) {
        this.keepjava = keepjava;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setXmlvalidation(boolean xmlvalidation) {
        this.xmlvalidation = xmlvalidation;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.reportFilesMap = new HashMap<String, String>();
        if (this.tempdir != null) {
            this.jasperReportsContext.setProperty("net.sf.jasperreports.compiler.temp.dir", String.valueOf(this.tempdir));
        }
        this.jasperReportsContext.setProperty("net.sf.jasperreports.compiler.keep.java.file", String.valueOf(this.keepjava));
        this.setCompilerClass(this.compiler);
        this.jasperReportsContext.setProperty("net.sf.jasperreports.compiler.xml.validation", String.valueOf(this.xmlvalidation));
        AntClassLoader classLoader = null;
        if (this.classpath != null) {
            this.jasperReportsContext.setProperty("net.sf.jasperreports.compiler.classpath", String.valueOf(this.classpath));
            ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
            classLoader = new AntClassLoader(parentClassLoader, this.getProject(), this.classpath, true);
            classLoader.setThreadContextLoader();
        }
        try {
            this.scanSrc();
            this.compile();
        }
        finally {
            if (classLoader != null) {
                classLoader.resetThreadContextLoader();
            }
        }
    }

    private void setCompilerClass(String compile) {
        if (this.compiler != null) {
            this.jasperReportsContext.setProperty("net.sf.jasperreports.compiler.class", this.compiler);
        }
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null || this.src.size() == 0) {
            throw new BuildException("The srcdir attribute must be set.", this.getLocation());
        }
        if (this.destdir != null && !this.destdir.isDirectory()) {
            throw new BuildException("The destination directory \"" + this.destdir + "\" does not exist or is not a directory.", this.getLocation());
        }
        if (this.tempdir != null && !this.tempdir.isDirectory()) {
            throw new BuildException("The temporary directory \"" + this.tempdir + "\" does not exist or is not a directory.", this.getLocation());
        }
    }

    protected void scanSrc() throws BuildException {
        for (Resource resource : this.src) {
            FileResource fileResource = resource instanceof FileResource ? (FileResource)resource : null;
            if (fileResource == null) continue;
            File file = fileResource.getFile();
            if (file.isDirectory()) {
                DirectoryScanner ds = this.getDirectoryScanner(file);
                String[] files = ds.getIncludedFiles();
                this.scanDir(file, this.destdir != null ? this.destdir : file, files);
                continue;
            }
            String[] files = new String[]{fileResource.getName()};
            this.scanDir(fileResource.getBaseDir(), this.destdir != null ? this.destdir : fileResource.getBaseDir(), files);
        }
    }

    protected void scanDir(File srcdir, File destdir, String[] files) {
        RegexpPatternMapper mapper = new RegexpPatternMapper();
        mapper.setFrom("^(.*)\\.(.*)$");
        mapper.setTo("\\1.jasper");
        SourceFileScanner scanner = new SourceFileScanner((Task)this);
        String[] newFiles = scanner.restrict(files, srcdir, destdir, (FileNameMapper)mapper);
        if (newFiles != null && newFiles.length > 0) {
            for (int i = 0; i < newFiles.length; ++i) {
                this.reportFilesMap.put(new File(srcdir, newFiles[i]).getAbsolutePath(), new File(destdir, mapper.mapFileName(newFiles[i])[0]).getAbsolutePath());
            }
        }
    }

    protected void compile() throws BuildException {
        Set<String> files = this.reportFilesMap.keySet();
        if (files != null && files.size() > 0) {
            boolean isError = false;
            System.out.println("Compiling " + files.size() + " report design files.");
            for (String srcFileName : files) {
                String destFileName = this.reportFilesMap.get(srcFileName);
                File destFileParent = new File(destFileName).getParentFile();
                if (!destFileParent.exists()) {
                    destFileParent.mkdirs();
                }
                try {
                    System.out.print("File : " + srcFileName + " ... ");
                    JasperCompileManager.getInstance(this.jasperReportsContext).compileToFile(srcFileName, destFileName);
                    System.out.println("OK.");
                }
                catch (JRException e) {
                    System.out.println("FAILED.");
                    System.out.println("Error compiling report design : " + srcFileName);
                    e.printStackTrace(System.out);
                    isError = true;
                }
            }
            if (isError) {
                throw new BuildException("Errors were encountered when compiling report designs.");
            }
        }
    }
}

