/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.mq;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.adempiere.exceptions.AdempiereException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.util.support.mq.AbstractMessageQueue;
import org.spin.util.support.mq.IMessageQueue;

public class ActiveMQ
extends AbstractMessageQueue {
    private CLogger log = CLogger.getCLogger(ActiveMQ.class);
    private int registrationId = 0;
    private String userName = null;
    private String password = null;
    private String url = null;
    private Connection connection;

    @Override
    public void publish(String channel, IMessageQueue payload) throws Exception {
        if (Util.isEmpty(this.userName)) {
            throw new AdempiereException("@SecretToken@ @NotFound@");
        }
        if (this.connection == null) {
            throw new AdempiereException("@Connection@ @NotFound@");
        }
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue(channel);
        MessageProducer producer = session.createProducer((Destination)destination);
        TextMessage message = null;
        if (payload.getType() == 0) {
            message = session.createTextMessage(payload.getMessageAsText());
            this.log.config("Message Type (Text)");
        } else if (payload.getType() == 1) {
            InputStream inputStream = payload.getMessageAsInputStream();
            BytesMessage bytesMessage = session.createBytesMessage();
            byte[] array = new byte[inputStream.available()];
            inputStream.read(array);
            bytesMessage.writeBytes(array);
            if (!Util.isEmpty(payload.getFileName())) {
                bytesMessage.setStringProperty("FileName", payload.getFileName());
            }
            message = bytesMessage;
            this.log.config("Message Type (File)");
        }
        if (message != null) {
            producer.send((Message)message);
            this.log.config("Message sent");
        }
    }

    @Override
    public void subscribe(String channel) throws Exception {
        if (Util.isEmpty(this.userName)) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        if (this.connection == null) {
            throw new AdempiereException("@Connection@ @NotFound@");
        }
    }

    @Override
    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        MADAppRegistration registration = MADAppRegistration.getById(Env.getCtx(), this.getAppRegistrationId(), null);
        String userName = registration.getParameterValue("UserName");
        String password = registration.getParameterValue("Password");
        String url = registration.getParameterValue("URL");
        if (Util.isEmpty(userName)) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        if (Util.isEmpty(password)) {
            throw new AdempiereException("@Password@ @NotFound@");
        }
        if (Util.isEmpty(url)) {
            throw new AdempiereException("@URL@ @NotFound@");
        }
        this.setUserName(userName);
        this.setPassword(password);
        this.setUrl(url);
    }

    @Override
    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void connect() throws Exception {
        if (this.connection == null) {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.userName, this.password, this.url);
            this.connection = connectionFactory.createConnection();
        }
        this.connection.start();
    }

    @Override
    public void disconnect() throws Exception {
        if (this.connection == null) {
            throw new AdempiereException("@Connection@ @NotFound@");
        }
        this.connection.close();
        this.connection = null;
    }

    @Override
    public String testConnection() {
        String message = null;
        try {
            MADAppRegistration registration = MADAppRegistration.getById(Env.getCtx(), this.getAppRegistrationId(), null);
            this.userName = registration.getParameterValue("UserName");
            this.password = registration.getParameterValue("Password");
            this.url = registration.getParameterValue("URL");
            String channel = registration.getParameterValue("TargetChannel");
            if (Util.isEmpty(this.userName)) {
                return "@AD_User_ID@ @NotFound@";
            }
            if (Util.isEmpty(this.password)) {
                return "@Password@ @NotFound@";
            }
            if (Util.isEmpty(this.url)) {
                return "@URL@ @NotFound@";
            }
            if (Util.isEmpty(channel)) {
                return "@Channel@ @NotFound@";
            }
            this.connect();
            this.publish(channel, new IMessageQueue(){

                @Override
                public int getType() {
                    return 1;
                }

                @Override
                public String getMessageAsText() {
                    return "Hi";
                }

                @Override
                public InputStream getMessageAsInputStream() {
                    try {
                        FileInputStream inputStream = new FileInputStream("/tmp/Factura_Nacional_1000158.pdf");
                        return inputStream;
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                @Override
                public Object getMessage() {
                    return this.getMessageAsText();
                }

                @Override
                public String getFileName() {
                    return "Test.pdf";
                }
            });
            message = "Ok";
        }
        catch (Exception e) {
            message = e.getLocalizedMessage();
        }
        return message;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

