/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.impexp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.impexp.TrxDataInterface;

public abstract class BankTransactionAbstract
implements TrxDataInterface {
    private HashMap<String, Object> values = new HashMap();

    public abstract boolean isEndTransactionLine(String var1);

    protected void addValue(String key, Object value) {
        this.values.put(key, value);
    }

    protected Object getValue(String key) {
        return this.values.get(key);
    }

    protected BigDecimal getNumber(String key) {
        Object value = this.getValue(key);
        BigDecimal bigDecimalValue = Env.ZERO;
        if (value != null) {
            if (value instanceof BigDecimal) {
                bigDecimalValue = (BigDecimal)value;
            } else if (value instanceof Double) {
                bigDecimalValue = new BigDecimal((Double)value);
            } else if (value instanceof Float) {
                bigDecimalValue = new BigDecimal(((Float)value).floatValue());
            } else if (value instanceof Integer) {
                bigDecimalValue = new BigDecimal((Integer)value);
            }
        }
        return bigDecimalValue;
    }

    protected String subString(String value, int fromPosition, int toPosition) {
        if (Util.isEmpty(value)) {
            return null;
        }
        if (fromPosition < 0) {
            return null;
        }
        if (fromPosition >= toPosition) {
            return null;
        }
        if (value.length() >= toPosition) {
            return value.substring(fromPosition, toPosition);
        }
        return value;
    }

    protected BigDecimal getNumber(char separator, String pattern, String value) throws ParseException {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator(separator);
        if (separator == '.') {
            symbols.setDecimalSeparator(',');
        } else {
            symbols.setDecimalSeparator('.');
        }
        DecimalFormat decimalFormat = new DecimalFormat(pattern, symbols);
        decimalFormat.setParseBigDecimal(true);
        return (BigDecimal)decimalFormat.parse(value);
    }

    protected Timestamp getDate(String pattern, String value) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        Date date = dateFormat.parse(value);
        return new Timestamp(date.getTime());
    }

    protected Timestamp getDate(String key) {
        Object value = this.getValue(key);
        if (value == null) {
            return null;
        }
        return (Timestamp)value;
    }

    protected String getString(String key) {
        Object value = this.getValue(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void parseLine(String line) throws Exception {
        if (Util.isEmpty(line = this.processValue(line))) {
            return;
        }
    }

    protected abstract String processValue(String var1);

    public abstract boolean isCompleteData();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            buffer.append("Key=").append(entry.getKey()).append(", Value=").append(entry.getValue()).append(Env.NL);
        }
        return buffer.toString();
    }
}

