/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import com.sun.enterprise.admin.util.Logger;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADToken;
import org.spin.model.MADTokenDefinition;
import org.spin.util.ITokenGenerator;

public class TokenGeneratorHandler {
    private static TokenGeneratorHandler tokenHandler = null;
    private Map<String, ITokenGenerator> tokenGeneratorMap = new HashMap<String, ITokenGenerator>();
    private static final CLogger logger = CLogger.getCLogger(TokenGeneratorHandler.class);

    public static TokenGeneratorHandler getInstance() {
        if (tokenHandler == null) {
            tokenHandler = new TokenGeneratorHandler();
        }
        return tokenHandler;
    }

    private TokenGeneratorHandler() {
    }

    private ITokenGenerator getTokenGenerator(String tokenType) throws Exception {
        if (!this.tokenGeneratorMap.containsKey(tokenType)) {
            this.loadClass(tokenType);
        }
        return this.tokenGeneratorMap.get(tokenType);
    }

    public String generateToken(String tokenType, int userId) throws Exception {
        return this.getTokenGenerator(tokenType).generateToken(tokenType, userId);
    }

    public boolean validateToken(String tokenType, String token, int userId) throws Exception {
        return this.getTokenGenerator(tokenType).validateToken(token, userId);
    }

    public MADToken getToken(String tokenType) throws Exception {
        return this.getTokenGenerator(tokenType).getToken();
    }

    private String getClassname(String tokenType) {
        MADTokenDefinition definition = MADTokenDefinition.getByTokenType(Env.getCtx(), tokenType, null);
        if (definition == null) {
            return null;
        }
        return definition.getClassname();
    }

    private Class<?> getHandlerClass(String tokenType) {
        String className = this.getClassname(tokenType);
        if (Util.isEmpty(className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (ITokenGenerator.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != ITokenGenerator.class) continue;
                logger.log(Level.SEVERE, "Error loading class, Use: " + className);
                return clazz;
            }
        }
        catch (Exception e) {
            Logger.logError((String)("Loading class Error" + e.getMessage()));
        }
        logger.log(Level.SEVERE, "Not found Class: " + className);
        return null;
    }

    private void loadClass(String tokenType) throws Exception {
        Class<?> clazz = this.getHandlerClass(tokenType);
        ITokenGenerator generator = null;
        if (clazz == null) {
            logger.log(Level.SEVERE, "Class not found, Using Standard Class");
            generator = null;
            throw new Exception("Class for connection not found");
        }
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        generator = (ITokenGenerator)constructor.newInstance(new Object[0]);
        this.tokenGeneratorMap.put(tokenType, generator);
    }
}

