/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRLeave;
import org.eevolution.model.MHRLeaveType;
import org.eevolution.model.MHRWorkShift;
import org.eevolution.model.X_HR_Leave;

public class TNAUtil {
    public static double getIncidenceSum(Properties properties, String string, String string2, int n, Timestamp timestamp, Timestamp timestamp2, String string3) {
        MHRConcept mHRConcept = MHRConcept.getByValue(properties, string, string3);
        if (mHRConcept == null) {
            return 0.0;
        }
        int n2 = 0;
        if (!Util.isEmpty(string2)) {
            MHRWorkShift mHRWorkShift = MHRWorkShift.getByValue(properties, string2, string3);
            n2 = mHRWorkShift.getHR_WorkShift_ID();
        }
        return TNAUtil.getIncidenceSum(properties, mHRConcept.getHR_Concept_ID(), n2, n, timestamp, timestamp2, string3);
    }

    public static double getIncidenceSum(Properties properties, int n, int n2, int n3, Timestamp timestamp, Timestamp timestamp2, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HR_Concept_ID=?");
        arrayList.add(n);
        stringBuffer.append(" AND C_BPartner_ID=?");
        arrayList.add(n3);
        stringBuffer.append(" AND ").append("DateDoc").append(" BETWEEN ? AND ?");
        arrayList.add(timestamp);
        arrayList.add(timestamp2);
        stringBuffer.append(" AND ").append("DocStatus").append(" IN('CO', 'CL')");
        if (n2 > 0) {
            stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_AttendanceBatch b WHERE HR_Incidence.HR_AttendanceBatch_ID = b.HR_AttendanceBatch_ID AND b.HR_WorkShift_ID=?)");
            arrayList.add(n2);
        }
        StringBuffer stringBuffer2 = new StringBuffer("SELECT COALESCE(SUM(Qty), SUM(Amt), 0) FROM ").append("HR_Incidence").append(" WHERE ").append(stringBuffer);
        BigDecimal bigDecimal = DB.getSQLValueBDEx(string, stringBuffer2.toString(), arrayList);
        return bigDecimal.doubleValue();
    }

    public static long getLeaveTimeBetween(Properties properties, int n, String string, Timestamp timestamp, Timestamp timestamp2, boolean bl, String string2) {
        List<MHRLeave> list = TNAUtil.getLeaveListBetween(properties, n, string, timestamp, timestamp2, string2);
        AtomicLong atomicLong = new AtomicLong();
        AtomicLong atomicLong2 = new AtomicLong();
        AtomicReference atomicReference = new AtomicReference();
        AtomicReference atomicReference2 = new AtomicReference();
        list.stream().sorted(Comparator.comparing(X_HR_Leave::getStartDate)).forEach(mHRLeave -> {
            atomicLong.addAndGet(TimeUtil.getMillisecondsBetween(mHRLeave.getStartDate(), mHRLeave.getEndDate()));
            Timestamp timestamp = atomicReference.getAndSet(mHRLeave.getStartDate());
            Timestamp timestamp2 = atomicReference2.getAndSet(mHRLeave.getEndDate());
            if (timestamp != null && timestamp2 != null && TimeUtil.isValid(timestamp, timestamp2, mHRLeave.getStartDate())) {
                Timestamp timestamp3 = timestamp2;
                if (timestamp2.getTime() > mHRLeave.getEndDate().getTime()) {
                    timestamp3 = mHRLeave.getEndDate();
                }
                atomicLong2.addAndGet(TimeUtil.getMillisecondsBetween(mHRLeave.getStartDate(), timestamp3));
            }
        });
        if (bl) {
            return atomicLong.get() - atomicLong2.get();
        }
        return atomicLong.get();
    }

    public static MHRLeave getFirstLeaveBetween(Properties properties, int n, String string, Timestamp timestamp, Timestamp timestamp2, String string2) {
        Optional<MHRLeave> optional = TNAUtil.getLeaveListBetween(properties, n, string, timestamp, timestamp2, string2).stream().sorted(Comparator.comparing(X_HR_Leave::getStartDate)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static MHRLeave getLastLeaveBetween(Properties properties, int n, String string, Timestamp timestamp, Timestamp timestamp2, String string2) {
        Optional<MHRLeave> optional = TNAUtil.getLeaveListBetween(properties, n, string, timestamp, timestamp2, string2).stream().sorted(Comparator.comparing(X_HR_Leave::getEndDate).reversed()).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static Timestamp getLeaveStartDateBetween(Properties properties, int n, String string, Timestamp timestamp, Timestamp timestamp2, String string2) {
        MHRLeave mHRLeave = TNAUtil.getFirstLeaveBetween(properties, n, string, timestamp, timestamp2, string2);
        if (mHRLeave != null) {
            return mHRLeave.getStartDate();
        }
        return null;
    }

    public static Timestamp getLeaveEndDateBetween(Properties properties, int n, String string, Timestamp timestamp, Timestamp timestamp2, String string2) {
        MHRLeave mHRLeave = TNAUtil.getLastLeaveBetween(properties, n, string, timestamp, timestamp2, string2);
        if (mHRLeave != null) {
            return mHRLeave.getEndDate();
        }
        return null;
    }

    public static double getLeaveHoursBetween(Properties properties, int n, String string, Timestamp timestamp, Timestamp timestamp2, boolean bl, String string2) {
        return TimeUtil.getHoursFromDuration(TNAUtil.getLeaveTimeBetween(properties, n, string, timestamp, timestamp2, bl, string2));
    }

    public static int getLeaveMinutesBetween(Properties properties, int n, String string, Timestamp timestamp, Timestamp timestamp2, boolean bl, String string2) {
        return TimeUtil.getMinutesFromDuration(TNAUtil.getLeaveTimeBetween(properties, n, string, timestamp, timestamp2, bl, string2));
    }

    public static int getLeaveDaysBetween(Properties properties, int n, String string, Timestamp timestamp, Timestamp timestamp2, boolean bl, String string2) {
        return TimeUtil.getDaysFromDuration(TNAUtil.getLeaveTimeBetween(properties, n, string, timestamp, timestamp2, bl, string2));
    }

    public static boolean isLeaveAllowedEncashment(Properties properties, String string, String string2) {
        MHRLeaveType mHRLeaveType = MHRLeaveType.getByValue(properties, string, string2);
        return mHRLeaveType != null && mHRLeaveType.isAllowedEncashment();
    }

    public static boolean isLeaveAllowedEncashment(String string) {
        return TNAUtil.isLeaveAllowedEncashment(Env.getCtx(), string, null);
    }

    public static List<MHRLeave> getLeaveListBetween(Properties properties, int n, String string, Timestamp timestamp, Timestamp timestamp2, String string2) {
        MHRLeaveType mHRLeaveType;
        String string3 = "";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add(timestamp);
        arrayList.add(timestamp2);
        if (!Util.isEmpty(string) && (mHRLeaveType = MHRLeaveType.getByValue(properties, string, string2)) != null) {
            string3 = " AND HR_LeaveType_ID = ?";
            arrayList.add(mHRLeaveType.getHR_LeaveType_ID());
        }
        return new Query(properties, "HR_Leave", "DocStatus IN('CO') AND C_BPartner_ID = ? AND StartDate <= ? AND EndDate >= ?" + string3, string2).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("StartDate").list();
    }

    public static List<MHRLeave> getLeaveListAttendanceTime(Properties properties, int n, String string, Timestamp timestamp, String string2) {
        MHRLeaveType mHRLeaveType;
        String string3 = "";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add(timestamp);
        if (!Util.isEmpty(string) && (mHRLeaveType = MHRLeaveType.getByValue(properties, string, string2)) != null) {
            string3 = " AND HR_LeaveType_ID = ?";
            arrayList.add(mHRLeaveType.getHR_LeaveType_ID());
        }
        return new Query(properties, "HR_Leave", "DocStatus IN('CO') AND C_BPartner_ID = ? AND ? BETWEEN StartDate AND EndDate" + string3, string2).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("StartDate").list();
    }

    public static String getDurationUnitFromTimeUnit(String string) {
        if (Util.isEmpty(string)) {
            return null;
        }
        if (string.equals("I")) {
            return "m";
        }
        if (string.equals("H")) {
            return "h";
        }
        if (string.equals("D")) {
            return "D";
        }
        if (string.equals("W")) {
            return "W";
        }
        if (string.equals("M")) {
            return "M";
        }
        if (string.equals("Y")) {
            return "Y";
        }
        return null;
    }

    public static String getDurationUnitFromFrequencyType(String string) {
        if (Util.isEmpty(string)) {
            return null;
        }
        if (string.equals("M")) {
            return "m";
        }
        if (string.equals("H")) {
            return "h";
        }
        if (string.equals("D")) {
            return "D";
        }
        if (string.equals("N")) {
            return "M";
        }
        if (string.equals("Y")) {
            return "Y";
        }
        return null;
    }
}

