/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMAmortization;
import org.spin.model.MFMAmortizationSummary;
import org.spin.model.MFMBatch;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMTransaction;
import org.spin.model.MFMTransactionType;
import org.spin.util.AbstractFunctionalSetting;
import org.spin.util.AmortizationValue;
import org.spin.util.LoanUtil;

public class LoanInterestProcess
extends AbstractFunctionalSetting {
    public LoanInterestProcess(MFMFunctionalSetting mFMFunctionalSetting) {
        super(mFMFunctionalSetting);
    }

    @Override
    public String run() {
        MFMAgreement mFMAgreement = (MFMAgreement)this.getParameter("MFMAgreement");
        MFMBatch mFMBatch = (MFMBatch)this.getParameter("MFMBatch");
        String string = (String)this.getParameter("TRX_NAME");
        if (mFMAgreement == null || mFMBatch == null) {
            return null;
        }
        MFMTransactionType mFMTransactionType = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LIN");
        MFMTransactionType mFMTransactionType2 = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LIT");
        if (mFMTransactionType == null) {
            throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ LIN");
        }
        HashMap<String, Object> hashMap = LoanUtil.calculateLoanInterest(this.getCtx(), mFMAgreement.getFM_Agreement_ID(), new Timestamp(System.currentTimeMillis()), string);
        if (hashMap == null || hashMap.isEmpty()) {
            return null;
        }
        List list = (List)hashMap.get("AMORTIZATION_LIST");
        if (list == null) {
            return null;
        }
        AtomicReference<BigDecimal> atomicReference = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> atomicReference2 = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> atomicReference3 = new AtomicReference<BigDecimal>(Env.ZERO);
        list.forEach(amortizationValue -> {
            atomicReference.updateAndGet(bigDecimal -> bigDecimal.add(amortizationValue.getCapitalAmtFee()));
            atomicReference2.updateAndGet(bigDecimal -> bigDecimal.add(amortizationValue.getInterestAmtFee()));
            atomicReference3.updateAndGet(bigDecimal -> bigDecimal.add(amortizationValue.getTaxAmtFee()));
        });
        List<MFMAccount> list2 = MFMAccount.getAccountFromAgreement(mFMAgreement);
        MFMAccount mFMAccount = null;
        if (list2.isEmpty()) {
            mFMAccount = new MFMAccount(mFMAgreement);
            mFMAccount.saveEx();
        } else {
            mFMAccount = list2.get(0);
        }
        for (AmortizationValue amortizationValue2 : list) {
            MFMTransaction mFMTransaction = mFMBatch.addTransaction(mFMTransactionType.getFM_TransactionType_ID(), amortizationValue2.getInterestAmtFee());
            if (mFMTransaction != null) {
                mFMTransaction.set_ValueOfColumn("FM_Amortization_ID", (Object)amortizationValue2.getAmortizationId());
                mFMTransaction.saveEx();
            }
            if (mFMTransactionType2 != null && amortizationValue2.getTaxAmtFee() != null && (mFMTransaction = mFMBatch.addTransaction(mFMTransactionType2.getFM_TransactionType_ID(), amortizationValue2.getTaxAmtFee())) != null) {
                mFMTransaction.set_ValueOfColumn("FM_Amortization_ID", (Object)amortizationValue2.getAmortizationId());
                mFMTransaction.saveEx();
            }
            MFMAmortization mFMAmortization = new MFMAmortization(this.getCtx(), amortizationValue2.getAmortizationId(), string);
            mFMAmortization.setCurrentCapitalAmt(atomicReference.get());
            mFMAmortization.setCurrentInterestAmt(atomicReference2.get());
            mFMAmortization.setCurrentTaxAmt(atomicReference3.get());
            mFMAmortization.saveEx();
            MFMAmortizationSummary.setCurrentInterest(this.getCtx(), mFMAccount.getFM_Account_ID(), amortizationValue2.getAmortizationId(), mFMBatch.getDateDoc(), atomicReference.get(), atomicReference2.get(), atomicReference3.get(), string);
        }
        return null;
    }
}

