/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.PO;
import org.compiere.model.X_C_Charge;
import org.compiere.util.Env;
import org.spin.model.MFMRate;
import org.spin.model.X_FM_Rate;

public class Interest {
    private int rateId;
    private int chargeId;
    private BigDecimal interestRate;
    private BigDecimal taxRate;
    private Properties context;
    private String transactionName;
    private Timestamp runningDate;

    public final Interest withContext(Properties properties) {
        this.context = properties;
        return this;
    }

    public final Interest withTransactionName(String string) {
        this.transactionName = string;
        return this;
    }

    public final int getRateId() {
        return this.rateId;
    }

    public final Interest withRateId(int n) {
        this.rateId = n;
        return this;
    }

    public final String getTransactionName() {
        return this.transactionName;
    }

    public final Timestamp getRunningDate() {
        return this.runningDate;
    }

    public final Interest withRunningDate(Timestamp timestamp) {
        this.runningDate = timestamp;
        return this;
    }

    public static Interest newInstance() {
        return new Interest();
    }

    public final int getChargeId() {
        return this.chargeId;
    }

    public final BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public final BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public Interest buildRate() {
        PO pO;
        if (this.context == null) {
            throw new AdempiereException("Missing Context");
        }
        if (this.rateId <= 0) {
            throw new AdempiereException("Missing Rate ID");
        }
        if (this.rateId == 0) {
            return this;
        }
        X_C_Charge x_C_Charge = null;
        if (this.rateId != 0) {
            pO = MFMRate.getById(this.context, this.rateId);
            this.interestRate = ((MFMRate)pO).getValidRate(this.runningDate);
            x_C_Charge = MCharge.get(this.context, ((X_FM_Rate)pO).getC_Charge_ID());
        }
        if (x_C_Charge != null) {
            pO = (MTaxCategory)x_C_Charge.getC_TaxCategory();
            MTax mTax = ((MTaxCategory)pO).getDefaultTax();
            this.interestRate = this.interestRate.divide(Env.ONEHUNDRED);
            this.taxRate = mTax.getRate().divide(Env.ONEHUNDRED);
            this.interestRate = this.interestRate.add(this.interestRate.multiply(this.taxRate));
        }
        return this;
    }

    public String toString() {
        return "Interest [rateId=" + this.rateId + ", chargeId=" + this.chargeId + ", interestRate=" + this.interestRate + ", taxRate=" + this.taxRate + ", runningDate=" + this.runningDate + "]";
    }
}

