/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.compiere.model.MCurrency;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMAmortization;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMProduct;
import org.spin.util.AbstractFunctionalSetting;
import org.spin.util.AmortizationValue;
import org.spin.util.LoanUtil;

public class FrenchLoanAmortization
extends AbstractFunctionalSetting {
    public FrenchLoanAmortization(MFMFunctionalSetting mFMFunctionalSetting) {
        super(mFMFunctionalSetting);
    }

    @Override
    public String run() {
        MFMAgreement mFMAgreement = (MFMAgreement)this.getParameter("PO");
        return this.generateAmortization(mFMAgreement);
    }

    private String generateAmortization(MFMAgreement mFMAgreement) {
        List list = new ArrayList();
        MFMProduct mFMProduct = (MFMProduct)mFMAgreement.getFM_Product();
        List<MFMAccount> list2 = mFMAgreement.getAccounts();
        for (MFMAccount mFMAccount : list2) {
            if (MFMAmortization.checkAccount(mFMAccount)) continue;
            MFMAmortization.deleteForAccount(mFMAccount);
            MCurrency mCurrency = (MCurrency)mFMAccount.getC_Currency();
            BigDecimal bigDecimal = (BigDecimal)mFMAccount.get_Value("CapitalAmt");
            int n = ((BigDecimal)mFMAccount.get_Value("FeesQty")).intValue();
            Timestamp timestamp = (Timestamp)mFMAccount.get_Value("StartDate");
            Timestamp timestamp2 = (Timestamp)mFMAccount.get_Value("EndDate");
            Timestamp timestamp3 = (Timestamp)mFMAccount.get_Value("PayDate");
            String string = mFMAccount.get_ValueAsString("PaymentFrequency");
            list = (List)LoanUtil.calculateFrenchAmortization(mFMProduct.getFM_Product_ID(), bigDecimal, n, timestamp, timestamp2, timestamp3, string, mFMAccount.getCtx()).get("AMORTIZATION_LIST");
            for (AmortizationValue amortizationValue : list) {
                MFMAmortization.createAmortization(mFMAccount.getCtx(), amortizationValue.getCapitalAmtFee().setScale(mCurrency.getStdPrecision(), 4), "", amortizationValue.getDueDate(), amortizationValue.getEndDate(), mFMAccount.getFM_Account_ID(), amortizationValue.getInterestAmtFee().setScale(mCurrency.getStdPrecision(), 4), amortizationValue.getPeriodNo(), amortizationValue.getStartDate(), amortizationValue.getTaxAmtFee().setScale(mCurrency.getStdPrecision(), 4), mFMAccount.get_TrxName());
            }
        }
        return null;
    }
}

