/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAccountProduct;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMBatch;
import org.spin.model.MFMFunctionalApplicability;
import org.spin.model.MFMProduct;
import org.spin.model.X_FM_Account;
import org.spin.util.AbstractFunctionalSetting;

public class FinancialSetting {
    private static FinancialSetting settingEngine = null;
    private HashMap<String, Object> returnValues;
    public static final String PARAMETER_PO = "PO";
    public static final String PARAMETER_CTX = "CTX";
    public static final String PARAMETER_TRX_NAME = "TRX_NAME";
    public static final String AGREEMENT_PO = "MFMAgreement";
    public static final String ACCOUNT_PO = "MFMAccount";
    public static final String BATCH_PO = "MFMBatch";

    private FinancialSetting() {
    }

    public static synchronized FinancialSetting get() {
        if (settingEngine == null) {
            settingEngine = new FinancialSetting();
        }
        return settingEngine;
    }

    public HashMap<String, Object> getReturnValues() {
        return this.returnValues;
    }

    public String fireDocValidate(PO pO, int n, int n2) {
        if (pO == null || n2 <= 0) {
            return null;
        }
        MFMProduct mFMProduct = MFMProduct.getById(pO.getCtx(), n2);
        List<MFMFunctionalApplicability> list = mFMProduct.getApplicability(pO.get_TableName(), ModelValidator.documentEventValidators[n]);
        this.returnValues = new HashMap();
        return this.runApplicability(pO.getCtx(), pO.get_TrxName(), pO, list, null);
    }

    public String fireModelChange(PO pO, int n, int n2) {
        if (pO == null || n2 <= 0) {
            return null;
        }
        MFMProduct mFMProduct = MFMProduct.getById(pO.getCtx(), n2);
        if (mFMProduct == null) {
            return null;
        }
        List<MFMFunctionalApplicability> list = mFMProduct.getApplicability(pO.get_TableName(), ModelValidator.tableEventValidators[n]);
        this.returnValues = new HashMap();
        return this.runApplicability(pO.getCtx(), pO.get_TrxName(), pO, list, null);
    }

    public String fire(Properties properties, int n, String string, HashMap<String, Object> hashMap, String string2) {
        if (n <= 0) {
            return null;
        }
        MFMProduct mFMProduct = MFMProduct.getById(properties, n);
        if (mFMProduct == null) {
            return null;
        }
        List<MFMFunctionalApplicability> list = mFMProduct.getApplicability(string);
        this.returnValues = new HashMap();
        return this.runApplicability(properties, string2, null, list, hashMap);
    }

    public String fireProcessAgreement(Properties properties, MFMAgreement mFMAgreement, String string) {
        if (mFMAgreement == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        List<MFMAccountProduct> list = mFMAgreement.getAccountProducts();
        for (MFMAccountProduct mFMAccountProduct : list) {
            MFMAccount mFMAccount = MFMAccount.getById(mFMAccountProduct.getCtx(), mFMAccountProduct.getFM_Account_ID(), string);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(AGREEMENT_PO, mFMAgreement);
            hashMap.put(ACCOUNT_PO, mFMAccount);
            String string2 = this.fire(properties, mFMAccountProduct.getFM_Product_ID(), "P", hashMap, string);
            if (Util.isEmpty(string2)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(Env.NL);
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    private String runApplicability(Properties properties, String string, PO pO, List<MFMFunctionalApplicability> list, HashMap<String, Object> hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (MFMFunctionalApplicability mFMFunctionalApplicability : list) {
                Object object;
                AbstractFunctionalSetting abstractFunctionalSetting = mFMFunctionalApplicability.getSetting();
                if (abstractFunctionalSetting == null) continue;
                MFMBatch mFMBatch = null;
                abstractFunctionalSetting.setFunctionalApplicability(mFMFunctionalApplicability);
                abstractFunctionalSetting.setParameter(PARAMETER_PO, pO);
                abstractFunctionalSetting.setParameter(PARAMETER_CTX, properties);
                abstractFunctionalSetting.setParameter(PARAMETER_TRX_NAME, string);
                if (mFMFunctionalApplicability.getEventType().equals("P")) {
                    object = (MFMAccount)hashMap.get(ACCOUNT_PO);
                    this.reversePreviousBatch(properties, string, mFMFunctionalApplicability.getFM_FunctionalSetting_ID(), ((X_FM_Account)object).getFM_Account_ID());
                    mFMBatch = new MFMBatch(properties, 0, string);
                    mFMBatch.setDateDoc(new Timestamp(System.currentTimeMillis()));
                    mFMBatch.setFM_Account_ID(((X_FM_Account)object).getFM_Account_ID());
                    mFMBatch.setFM_FunctionalSetting_ID(mFMFunctionalApplicability.getFM_FunctionalSetting_ID());
                    mFMBatch.setAD_Org_ID(((PO)object).getAD_Org_ID());
                    mFMBatch.setC_DocType_ID();
                    mFMBatch.saveEx();
                    abstractFunctionalSetting.setParameter(BATCH_PO, mFMBatch);
                }
                if (hashMap != null) {
                    abstractFunctionalSetting.setParameters(hashMap);
                }
                if (!Util.isEmpty((String)(object = abstractFunctionalSetting.run()))) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(Env.NL);
                    }
                    stringBuffer.append((String)object);
                }
                for (Map.Entry<String, Object> entry : abstractFunctionalSetting.getReturnValues().entrySet()) {
                    this.returnValues.put(entry.getKey(), entry.getValue());
                }
                if (mFMBatch == null) continue;
                mFMBatch.processIt("CO");
                mFMBatch.saveEx();
            }
        }
        catch (Exception exception) {
            stringBuffer.append(exception);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    private void reversePreviousBatch(Properties properties, String string, int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add(n2);
        MFMBatch mFMBatch = (MFMBatch)new Query(properties, "FM_Batch", "FM_FunctionalSetting_ID=? AND FM_Account_ID=? AND DocStatus='CO'", string).setParameters(arrayList).setOrderBy("DateDoc DESC").first();
        if (mFMBatch != null) {
            mFMBatch.reverseAccrualIt();
        }
    }
}

