/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.File;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.pdf.ITextDocument;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.util.AbstractExportFormat;

public class ExportFormatPDF
extends AbstractExportFormat {
    private static CLogger log = CLogger.getCLogger(ExportFormatPDF.class);

    public ExportFormatPDF(Properties ctx, ReportEngine reportEngine) {
        this.setCtx(ctx);
        this.setReportEngine(reportEngine);
    }

    @Override
    public String getExtension() {
        return "pdf";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FilePDF");
    }

    @Override
    public boolean exportToFile(File file) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        return this.createPDF(file);
    }

    public boolean createPDF(File file) {
        String fileName = null;
        URI uri = null;
        try {
            File fil = file;
            if (file == null) {
                fil = File.createTempFile("ReportEngine", ".pdf");
            }
            fileName = fil.getAbsolutePath();
            uri = fil.toURI();
            if (fil.exists()) {
                fil.delete();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "file", e);
            return false;
        }
        log.fine(uri.toString());
        try {
            this.getReportEngine().getView();
            ArchiveEngine.get().archive(this.getLayoutEngine(), this.getPrintInfo());
            new ITextDocument().getPDFAsFile(fileName, this.getReportEngine().getLayout().getPageable(false));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", e);
            return false;
        }
        File file2 = new File(fileName);
        log.info(file2.getAbsolutePath() + " - " + file2.length());
        return file2.exists();
    }
}

