/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.PO;
import org.compiere.model.X_C_Charge;
import org.compiere.util.Env;
import org.spin.model.MFMDunning;
import org.spin.model.MFMDunningLevel;
import org.spin.model.MFMRate;
import org.spin.model.X_FM_Rate;

public class Dunning {
    private int dunningId;
    private int dunningRateId;
    private int graceDay;
    private int chargeId;
    private BigDecimal interestRate;
    private BigDecimal taxRate;
    private Properties context;
    private String transactionName;
    private Timestamp runningDate;
    private MFMDunning dunning;

    public final Dunning withContext(Properties properties) {
        this.context = properties;
        return this;
    }

    public final Dunning withTransactionName(String string) {
        this.transactionName = string;
        return this;
    }

    public final String getTransactionName() {
        return this.transactionName;
    }

    public final Timestamp getRunningDate() {
        return this.runningDate;
    }

    public final Dunning withRunningDate(Timestamp timestamp) {
        this.runningDate = timestamp;
        return this;
    }

    public static Dunning newInstance() {
        return new Dunning();
    }

    public final int getDunningId() {
        return this.dunningId;
    }

    public final Dunning withDunningId(int n) {
        this.dunningId = n;
        return this;
    }

    public final int getDunningRateId() {
        return this.dunningRateId;
    }

    public final Dunning withDunningRateId(int n) {
        this.dunningRateId = n;
        return this;
    }

    public final int getGraceDay() {
        return this.graceDay;
    }

    public final int getChargeId() {
        return this.chargeId;
    }

    public final BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public final BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public Dunning buildRate() {
        PO pO;
        if (this.context == null) {
            throw new AdempiereException("Missing Context");
        }
        if (this.dunningId <= 0) {
            throw new AdempiereException("Missing Dunning ID");
        }
        if (this.graceDay < 0) {
            throw new AdempiereException("Missing Grace Day");
        }
        if (this.runningDate == null) {
            this.runningDate = new Timestamp(System.currentTimeMillis());
        }
        if (this.dunningRateId == 0 && this.dunningId == 0) {
            return null;
        }
        X_C_Charge x_C_Charge = null;
        if (this.dunningRateId != 0) {
            pO = MFMRate.getById(this.context, this.dunningRateId);
            this.interestRate = ((MFMRate)pO).getValidRate(this.runningDate);
            this.interestRate = this.interestRate != null ? this.interestRate.divide(Env.ONEHUNDRED) : Env.ZERO;
            x_C_Charge = MCharge.get(this.context, ((X_FM_Rate)pO).getC_Charge_ID());
        }
        if (x_C_Charge != null) {
            pO = (MTaxCategory)x_C_Charge.getC_TaxCategory();
            MTax mTax = ((MTaxCategory)pO).getDefaultTax();
            this.taxRate = mTax.getRate();
            this.taxRate = this.taxRate != null ? this.taxRate.divide(Env.ONEHUNDRED) : Env.ZERO;
        }
        if (this.dunningId > 0) {
            this.dunning = MFMDunning.getById(this.context, this.dunningId);
        }
        return this;
    }

    public Dunning buildRateFromLevel(int n) {
        int n2;
        if (this.dunning == null) {
            return this;
        }
        MFMDunningLevel mFMDunningLevel = this.dunning.getValidLevelInstance(n);
        if (mFMDunningLevel == null) {
            return this;
        }
        if (this.dunningRateId == 0 && (n2 = mFMDunningLevel.getFM_Rate_ID()) > 0) {
            MFMRate mFMRate = MFMRate.getById(this.context, n2);
            this.interestRate = mFMRate.getValidRate(this.runningDate);
            MCharge mCharge = MCharge.get(this.context, mFMRate.getC_Charge_ID());
            if (mCharge != null) {
                MTaxCategory mTaxCategory = (MTaxCategory)mCharge.getC_TaxCategory();
                MTax mTax = mTaxCategory.getDefaultTax();
                this.interestRate = this.interestRate.divide(Env.ONEHUNDRED);
                this.taxRate = mTax.getRate().divide(Env.ONEHUNDRED);
            }
        }
        if (this.interestRate == null || this.interestRate.doubleValue() == 0.0 || this.taxRate == null) {
            return this;
        }
        return this;
    }

    public final MFMDunning getDunning() {
        return this.dunning;
    }

    public String toString() {
        return "Dunning [dunningId=" + this.dunningId + ", dunningRateId=" + this.dunningRateId + ", graceDay=" + this.graceDay + ", chargeId=" + this.chargeId + ", interestRate=" + this.interestRate + ", taxRate=" + this.taxRate + ", runningDate=" + this.runningDate + "]";
    }
}

