/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.spin.model.MFMAccount;
import org.spin.model.MFMBatch;
import org.spin.model.MFMFunctionalApplicability;
import org.spin.model.MFMFunctionalSetting;

public abstract class AbstractFunctionalSetting {
    private MFMFunctionalSetting setting;
    private MFMFunctionalApplicability applicability;
    private HashMap<String, Object> parameters = new HashMap();
    private HashMap<String, Object> returnValues = new HashMap();
    private Properties ctx;

    public AbstractFunctionalSetting(MFMFunctionalSetting mFMFunctionalSetting) {
        this.setting = mFMFunctionalSetting;
        this.ctx = mFMFunctionalSetting.getCtx();
    }

    public Properties getCtx() {
        return this.ctx;
    }

    public void setFunctionalApplicability(MFMFunctionalApplicability mFMFunctionalApplicability) {
        this.applicability = mFMFunctionalApplicability;
    }

    public MFMFunctionalApplicability getFunctionalApplicability() {
        return this.applicability;
    }

    public MFMFunctionalSetting getFunctionalSetting() {
        return this.setting;
    }

    public void setParameter(String string, Object object) {
        this.parameters.put(string, object);
    }

    public void setParameters(HashMap<String, Object> hashMap) {
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    public Object getParameter(String string) {
        return this.parameters.get(string);
    }

    public int getParameterAsInt(String string) {
        Object object = this.getParameter(string);
        if (object != null && object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public BigDecimal getParameterAsBigDecimal(String string) {
        Object object = this.getParameter(string);
        if (object != null && object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        return Env.ZERO;
    }

    public void setReturnValue(String string, Object object) {
        this.returnValues.put(string, object);
    }

    public Object getReturnValue(String string) {
        return this.returnValues.get(string);
    }

    public HashMap<String, Object> getReturnValues() {
        return this.returnValues;
    }

    protected MFMBatch createBatch(Timestamp timestamp) {
        String string = (String)this.getParameter("TRX_NAME");
        PO pO = (PO)this.getParameter("PO");
        MFMAccount mFMAccount = (MFMAccount)this.parameters.get("MFMAccount");
        if (mFMAccount == null) {
            return null;
        }
        MFMBatch mFMBatch = new MFMBatch(this.getCtx(), 0, string);
        if (timestamp == null) {
            timestamp = new Timestamp(System.currentTimeMillis());
        }
        mFMBatch.setDateDoc(timestamp);
        mFMBatch.setFM_Account_ID(mFMAccount.getFM_Account_ID());
        mFMBatch.setFM_FunctionalSetting_ID(this.applicability.getFM_FunctionalSetting_ID());
        if (pO != null) {
            mFMBatch.setAD_Org_ID(pO.getAD_Org_ID());
        }
        mFMBatch.setC_DocType_ID();
        mFMBatch.saveEx();
        return mFMBatch;
    }

    public abstract String run();
}

