/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.X_AD_Browse_Field;
import org.compiere.Adempiere;
import org.compiere.model.I_AD_BrowseCustom;
import org.compiere.model.I_AD_ProcessCustom;
import org.compiere.model.MBrowseCustom;
import org.compiere.model.MBrowseFieldCustom;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MFieldCustom;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessCustom;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProcessParaCustom;
import org.compiere.model.MTab;
import org.compiere.model.MTabCustom;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.MWindowCustom;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Field;
import org.compiere.model.X_AD_Process_Para;
import org.compiere.model.X_AD_Tab;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class ASPUtil {
    private static ASPUtil instance = null;
    private int clientId;
    private int roleId;
    private int userId;
    private String language;
    private Properties context;
    private static final String CACHE_KEY = "Client_Customization_";
    private static CCache<String, MProcess> processCache = new CCache("Client_Customization_AD_Process", 20);
    private static CCache<String, List<MProcessPara>> processParameterCache = new CCache("Client_Customization_AD_Process_Para", 20);
    private static CCache<String, MBrowse> browseCache = new CCache("Client_Customization_AD_Browse", 20);
    private static CCache<String, List<MBrowseField>> browseFieldCache = new CCache("Client_Customization_AD_Browse_Field", 20);
    private static CCache<String, MWindow> windowCache = new CCache("Client_Customization_AD_Window", 20);
    private static CCache<String, List<MTab>> tabCache = new CCache("Client_Customization_AD_Tab", 20);
    private static CCache<String, List<MField>> fieldCache = new CCache("Client_Customization_AD_Field", 20);
    private final int CLIENT = 1;
    private final int ROLE = 2;
    private final int USER = 3;

    private ASPUtil(Properties context, int clientId, int roleId, int userId, String language) {
        if (context == null) {
            throw new AdempiereException("@ContextIsMandatory@");
        }
        this.loadValues(context, clientId, roleId, userId, language);
    }

    private void loadValues(Properties context, int clientId, int roleId, int userId, String language) {
        this.context = context;
        this.clientId = clientId;
        this.roleId = roleId;
        this.userId = userId;
        this.language = language;
    }

    public static ASPUtil getInstance(Properties context) {
        return ASPUtil.getInstance(context, Env.getAD_Client_ID(context), Env.getAD_Role_ID(context), Env.getAD_User_ID(context), Env.getAD_Language(context));
    }

    public static ASPUtil getInstance(Properties context, int clientId, int roleId, int userId, String language) {
        if (instance == null) {
            instance = new ASPUtil(context, clientId, roleId, userId, language);
        } else {
            instance.loadValues(context, clientId, roleId, userId, language);
        }
        return instance;
    }

    public static ASPUtil getInstance() {
        return ASPUtil.getInstance(Env.getCtx());
    }

    public MProcess getProcess(int processId) {
        MProcess process = processCache.get(this.getUserKey(processId));
        if (process == null) {
            process = processCache.get(this.getRoleKey(processId));
        }
        if (process == null) {
            process = processCache.get(this.getClientKey(processId));
        }
        if (process == null) {
            process = processCache.get(this.getDictionaryKey(processId));
        }
        if (process == null) {
            process = this.getProcessForASP(processId);
        }
        return process;
    }

    public MBrowse getBrowse(int browseId) {
        MBrowse browse = browseCache.get(this.getUserKey(browseId));
        if (browse == null) {
            browse = browseCache.get(this.getRoleKey(browseId));
        }
        if (browse == null) {
            browse = browseCache.get(this.getClientKey(browseId));
        }
        if (browse == null) {
            browse = browseCache.get(this.getDictionaryKey(browseId));
        }
        if (browse == null) {
            browse = this.getBrowseForASP(browseId);
        }
        return browse;
    }

    public List<MBrowseField> getBrowseFields(int browseId) {
        if (browseCache.get(this.getDictionaryKey(browseId)) == null) {
            this.getBrowse(browseId);
        }
        if (browseCache.get(this.getUserKey(browseId)) != null) {
            return browseFieldCache.get(this.getUserKey(browseId));
        }
        if (browseCache.get(this.getRoleKey(browseId)) != null) {
            return browseFieldCache.get(this.getRoleKey(browseId));
        }
        if (browseCache.get(this.getClientKey(browseId)) != null) {
            return browseFieldCache.get(this.getClientKey(browseId));
        }
        return browseFieldCache.get(this.getDictionaryKey(browseId));
    }

    public List<MBrowseField> getBrowseCriteriaFields(int browseId) {
        List<MBrowseField> fields = this.getBrowseFields(browseId);
        if (fields == null) {
            return null;
        }
        return fields.stream().filter(field -> field.isActive() && field.isQueryCriteria()).sorted(Comparator.comparing(X_AD_Browse_Field::getSeqNoGrid)).collect(Collectors.toList());
    }

    public List<MBrowseField> getBrowseIdentifierFields(int browseId) {
        List<MBrowseField> fields = this.getBrowseFields(browseId);
        if (fields == null) {
            return null;
        }
        return fields.stream().filter(field -> field.isActive() && field.isIdentifier()).sorted(Comparator.comparing(X_AD_Browse_Field::getSeqNo)).collect(Collectors.toList());
    }

    public List<MBrowseField> getBrowseOrderByFields(int browseId) {
        List<MBrowseField> fields = this.getBrowseFields(browseId);
        if (fields == null) {
            return null;
        }
        return fields.stream().filter(field -> field.isActive() && field.isOrderBy() && field.isDisplayed()).sorted(Comparator.comparing(X_AD_Browse_Field::getSeqNo)).collect(Collectors.toList());
    }

    public List<MBrowseField> getBrowseDisplayFields(int browseId) {
        List<MBrowseField> fields = this.getBrowseFields(browseId);
        if (fields == null) {
            return null;
        }
        return fields.stream().filter(field -> field.isActive() && field.isDisplayed() || field.isIdentifier()).sorted(Comparator.comparing(X_AD_Browse_Field::getSeqNo)).collect(Collectors.toList());
    }

    public MBrowseField getBrowseFieldKey(int browseId) {
        List<MBrowseField> fields = this.getBrowseFields(browseId);
        if (fields == null) {
            return null;
        }
        return fields.stream().filter(field -> field.isActive() && field.isKey()).sorted(Comparator.comparing(X_AD_Browse_Field::getSeqNo)).findFirst().get();
    }

    public MWindow getWindow(int windowId) {
        MWindow window = windowCache.get(this.getUserKey(windowId));
        if (window == null) {
            window = windowCache.get(this.getRoleKey(windowId));
        }
        if (window == null) {
            window = windowCache.get(this.getClientKey(windowId));
        }
        if (window == null) {
            window = windowCache.get(this.getDictionaryKey(windowId));
        }
        if (window == null) {
            window = this.getWindowForASP(windowId);
        }
        return window;
    }

    public List<MTab> getWindowTabs(int windowId) {
        if (windowCache.get(this.getDictionaryKey(windowId)) == null) {
            this.getWindow(windowId);
        }
        if (windowCache.get(this.getUserKey(windowId)) != null) {
            return tabCache.get(this.getUserKey(windowId));
        }
        if (windowCache.get(this.getRoleKey(windowId)) != null) {
            return tabCache.get(this.getRoleKey(windowId));
        }
        if (windowCache.get(this.getClientKey(windowId)) != null) {
            return tabCache.get(this.getClientKey(windowId));
        }
        return tabCache.get(this.getDictionaryKey(windowId));
    }

    public MTab getWindowTab(int windowId, int tabId) {
        List<MTab> tabs = this.getWindowTabs(windowId);
        if (tabs == null || tabs.isEmpty()) {
            return null;
        }
        Optional<MTab> optionalTab = tabs.stream().filter(tab -> tab.getAD_Tab_ID() == tabId).findFirst();
        if (optionalTab.isPresent()) {
            return optionalTab.get();
        }
        return null;
    }

    public List<MField> getWindowFields(int tabId) {
        MTab tab = MTab.get(this.context, tabId);
        int windowId = tab.getAD_Window_ID();
        if (windowCache.get(this.getDictionaryKey(tab.getAD_Window_ID())) == null || fieldCache.get(this.getDictionaryKey(tabId)) == null) {
            this.getWindow(windowId);
        }
        if (windowCache.get(this.getUserKey(windowId)) != null) {
            return fieldCache.get(this.getUserKey(tabId));
        }
        if (windowCache.get(this.getRoleKey(windowId)) != null) {
            return fieldCache.get(this.getRoleKey(tabId));
        }
        if (windowCache.get(this.getClientKey(windowId)) != null) {
            return fieldCache.get(this.getClientKey(tabId));
        }
        return fieldCache.get(this.getDictionaryKey(tabId));
    }

    public List<MProcessPara> getProcessParameters(int processId) {
        if (processCache.get(this.getDictionaryKey(processId)) == null) {
            this.getProcess(processId);
        }
        if (processCache.get(this.getUserKey(processId)) != null) {
            return processParameterCache.get(this.getUserKey(processId));
        }
        if (processCache.get(this.getRoleKey(processId)) != null) {
            return processParameterCache.get(this.getRoleKey(processId));
        }
        if (processCache.get(this.getClientKey(processId)) != null) {
            return processParameterCache.get(this.getClientKey(processId));
        }
        return processParameterCache.get(this.getDictionaryKey(processId));
    }

    private MProcess getProcessForASP(int processId) {
        MProcess process = MProcess.get(this.context, processId);
        if (process == null) {
            return process;
        }
        this.loadTranslation(process);
        processCache.put(this.getDictionaryKey(processId), process.getDuplicated());
        MTable newTable = MTable.get(this.context, I_AD_ProcessCustom.Table_ID);
        if (newTable == null || Util.isEmpty(newTable.getTableName())) {
            this.loadProcessParameters(process);
            return process;
        }
        process = this.getClientProcess(process);
        process = this.getRoleProcess(process);
        process = this.getUserProcess(process);
        return process;
    }

    private MBrowse getBrowseForASP(int processId) {
        MBrowse browse = MBrowse.get(this.context, processId);
        if (browse == null) {
            return browse;
        }
        browseCache.put(this.getDictionaryKey(processId), browse.getDuplicated());
        MTable newTable = MTable.get(this.context, I_AD_BrowseCustom.Table_ID);
        if (newTable == null || Util.isEmpty(newTable.getTableName())) {
            this.loadBrowseFields(browse);
            return browse;
        }
        browse = this.getClientBrowse(browse);
        browse = this.getRoleBrowse(browse);
        browse = this.getUserBrowse(browse);
        return browse;
    }

    private MWindow getWindowForASP(int windowId) {
        MWindow window = MWindow.get(this.context, windowId);
        windowCache.put(this.getDictionaryKey(windowId), window.getDuplicated());
        MTable newTable = MTable.get(this.context, "AD_WindowCustom");
        if (newTable == null || Util.isEmpty(newTable.getTableName())) {
            this.loadWindowTabs(window);
            return window;
        }
        window = this.getClientWindow(window);
        window = this.getRoleWindow(window);
        window = this.getUserWindow(window);
        return window;
    }

    private List<MProcessPara> mergeParameters(List<MProcessPara> processParameters, List<MProcessParaCustom> customProcessParameters, boolean overwrite) {
        ArrayList<Object> mergedParameters = null;
        if (overwrite) {
            mergedParameters = new ArrayList();
            for (MProcessPara parameter : processParameters) {
                MProcessPara parameterToAdd = parameter.getDuplicated();
                parameterToAdd.setIsActive(false);
                mergedParameters.add(parameterToAdd);
            }
        } else {
            mergedParameters = new ArrayList<MProcessPara>(processParameters);
        }
        for (int index = 0; index < mergedParameters.size(); ++index) {
            MProcessPara parameter;
            parameter = (MProcessPara)mergedParameters.get(index);
            customProcessParameters.stream().filter(customParameter -> customParameter.getAD_Process_Para_ID() == parameter.getAD_Process_Para_ID()).forEach(customParameter -> this.mergeProcessParameter(parameter, (MProcessParaCustom)customParameter, overwrite));
            mergedParameters.set(index, parameter);
        }
        mergedParameters.sort(Comparator.comparing(X_AD_Process_Para::getSeqNo));
        return mergedParameters;
    }

    private List<MBrowseField> mergeBrowseFields(List<MBrowseField> browseFields, List<MBrowseFieldCustom> customBrowseFields, boolean overwrite) {
        ArrayList<Object> mergedFields = null;
        if (overwrite) {
            mergedFields = new ArrayList();
            for (MBrowseField field : browseFields) {
                MBrowseField fieldToAdd = field.getDuplicated();
                fieldToAdd.setIsActive(false);
                mergedFields.add(fieldToAdd);
            }
        } else {
            mergedFields = new ArrayList<MBrowseField>(browseFields);
        }
        for (int index = 0; index < mergedFields.size(); ++index) {
            MBrowseField field;
            field = (MBrowseField)mergedFields.get(index);
            customBrowseFields.stream().filter(customParameter -> customParameter.getAD_Browse_Field_ID() == field.getAD_Browse_Field_ID()).forEach(customField -> this.mergeBrowseField(field, (MBrowseFieldCustom)customField, overwrite));
            mergedFields.set(index, field);
        }
        mergedFields.sort(Comparator.comparing(X_AD_Browse_Field::getSeqNo));
        return mergedFields;
    }

    private List<MTab> mergeTabs(List<MTab> windowTabs, List<MTabCustom> customWindowTabs, boolean overwrite, int level) {
        ArrayList<Object> mergedTabs = null;
        if (overwrite) {
            mergedTabs = new ArrayList();
            for (MTab parameter : windowTabs) {
                MTab tabToAdd = parameter.getDuplicated();
                tabToAdd.setIsActive(false);
                mergedTabs.add(tabToAdd);
            }
        } else {
            mergedTabs = new ArrayList<MTab>(windowTabs);
        }
        for (int index = 0; index < mergedTabs.size(); ++index) {
            MTab tab = (MTab)mergedTabs.get(index);
            List<MField> fields = this.loadFields(tab);
            if (level == 1) {
                fields = fieldCache.get(this.getClientKey(tab.getAD_Tab_ID()));
            } else if (level == 2) {
                fields = fieldCache.get(this.getClientKey(tab.getAD_Tab_ID()));
            } else if (level == 3) {
                fields = fieldCache.get(this.getRoleKey(tab.getAD_Tab_ID()));
            }
            for (MTabCustom customTab : customWindowTabs) {
                if (customTab.getAD_Tab_ID() != tab.getAD_Tab_ID()) continue;
                this.mergeTab(tab, customTab, overwrite, fields, level);
            }
            mergedTabs.set(index, tab);
        }
        mergedTabs.sort(Comparator.comparing(X_AD_Tab::getSeqNo));
        return mergedTabs;
    }

    private List<MProcessPara> loadProcessParameters(MProcess process) {
        List<MProcessPara> parameters = processParameterCache.get(this.getDictionaryKey(process.getAD_Process_ID()));
        if (parameters != null) {
            return parameters;
        }
        processParameterCache.put(this.getDictionaryKey(process.getAD_Process_ID()), process.getParametersAsList());
        parameters = process.getASPParameters();
        parameters.forEach(parameter -> this.loadTranslation((PO)parameter));
        processParameterCache.put(this.getClientKey(process.getAD_Process_ID()), parameters);
        processParameterCache.put(this.getRoleKey(process.getAD_Process_ID()), parameters);
        processParameterCache.put(this.getUserKey(process.getAD_Process_ID()), parameters);
        return parameters;
    }

    private List<MBrowseField> loadBrowseFields(MBrowse browse) {
        List<MBrowseField> fields = browseFieldCache.get(this.getDictionaryKey(browse.getAD_Browse_ID()));
        if (fields != null) {
            return fields;
        }
        browseFieldCache.put(this.getDictionaryKey(browse.getAD_Browse_ID()), browse.getFields());
        fields = browse.getFields();
        browseFieldCache.put(this.getClientKey(browse.getAD_Browse_ID()), fields);
        browseFieldCache.put(this.getRoleKey(browse.getAD_Browse_ID()), fields);
        browseFieldCache.put(this.getUserKey(browse.getAD_Browse_ID()), fields);
        return fields;
    }

    private List<MTab> loadWindowTabs(MWindow window) {
        List<MTab> tabs = tabCache.get(this.getDictionaryKey(window.getAD_Window_ID()));
        if (tabs != null) {
            return tabs;
        }
        tabs = window.getASPTabs();
        tabs.forEach(tab -> this.loadTranslation((PO)tab));
        tabCache.put(this.getDictionaryKey(window.getAD_Window_ID()), tabs);
        tabCache.put(this.getClientKey(window.getAD_Window_ID()), tabs);
        tabCache.put(this.getRoleKey(window.getAD_Window_ID()), tabs);
        tabCache.put(this.getUserKey(window.getAD_Window_ID()), tabs);
        tabs.stream().forEach(tab -> this.loadFields((MTab)tab));
        return tabs;
    }

    private List<MField> loadFields(MTab tab) {
        List<MField> fields = fieldCache.get(this.getDictionaryKey(tab.getAD_Tab_ID()));
        if (fields != null) {
            return fields;
        }
        fields = tab.getASPFields();
        fields.forEach(field -> this.loadTranslation((PO)field));
        fieldCache.put(this.getDictionaryKey(tab.getAD_Tab_ID()), fields);
        fieldCache.put(this.getClientKey(tab.getAD_Tab_ID()), fields);
        fieldCache.put(this.getRoleKey(tab.getAD_Tab_ID()), fields);
        fieldCache.put(this.getUserKey(tab.getAD_Tab_ID()), fields);
        return fields;
    }

    private List<MWindowCustom> getClientWindowList(int windowId) {
        String whereClause = "EXISTS(SELECT 1 FROM ASP_ClientLevel cl WHERE cl.AD_Client_ID = ? AND cl.ASP_Level_ID = AD_WindowCustom.ASP_Level_ID) AND AD_Window_ID = ?";
        return new Query(this.context, "AD_WindowCustom", whereClause, null).setParameters(this.clientId, windowId).setOnlyActiveRecords(true).list();
    }

    private List<MProcessCustom> getClientProcessList(int processId) {
        String whereClause = "EXISTS(SELECT 1 FROM ASP_ClientLevel cl WHERE cl.AD_Client_ID = ? AND cl.ASP_Level_ID = AD_ProcessCustom.ASP_Level_ID) AND AD_Process_ID = ?";
        return new Query(this.context, "AD_ProcessCustom", whereClause, null).setParameters(this.clientId, processId).setOnlyActiveRecords(true).list();
    }

    private List<MBrowseCustom> getClientBrowseList(int browseId) {
        String whereClause = "EXISTS(SELECT 1 FROM ASP_ClientLevel cl WHERE cl.AD_Client_ID = ? AND cl.ASP_Level_ID = AD_BrowseCustom.ASP_Level_ID) AND AD_Browse_ID = ?";
        return new Query(this.context, "AD_BrowseCustom", whereClause, null).setParameters(this.clientId, browseId).setOnlyActiveRecords(true).list();
    }

    private List<MWindowCustom> getRoleWindowList(int windowId) {
        String whereClause = "AD_Role_ID = ? AND AD_Window_ID = ?";
        return new Query(this.context, "AD_WindowCustom", whereClause, null).setParameters(this.roleId, windowId).setOnlyActiveRecords(true).list();
    }

    private List<MProcessCustom> getRoleProcessList(int processId) {
        String whereClause = "AD_Role_ID = ? AND AD_Process_ID = ?";
        return new Query(this.context, "AD_ProcessCustom", whereClause, null).setParameters(this.roleId, processId).setOnlyActiveRecords(true).list();
    }

    private List<MBrowseCustom> getRoleBrowseList(int browseId) {
        String whereClause = "AD_Role_ID = ? AND AD_Process_ID = ?";
        return new Query(this.context, "AD_BrowseCustom", whereClause, null).setParameters(this.roleId, browseId).setOnlyActiveRecords(true).list();
    }

    private List<MProcessCustom> getUserProcessList(int processId) {
        String whereClause = "AD_User_ID = ? AND AD_Process_ID = ?";
        return new Query(this.context, "AD_ProcessCustom", whereClause, null).setParameters(this.userId, processId).setOnlyActiveRecords(true).list();
    }

    private List<MBrowseCustom> getUserBrowseList(int browseId) {
        String whereClause = "AD_User_ID = ? AND AD_Browse_ID = ?";
        return new Query(this.context, "AD_BrowseCustom", whereClause, null).setParameters(this.userId, browseId).setOnlyActiveRecords(true).list();
    }

    private List<MWindowCustom> getUserWindowList(int windowId) {
        String whereClause = "AD_User_ID = ? AND AD_Window_ID = ?";
        return new Query(this.context, "AD_WindowCustom", whereClause, null).setParameters(this.userId, windowId).setOnlyActiveRecords(true).list();
    }

    private MWindow getClientWindow(MWindow window) {
        List<MTab> clientTabs = this.loadWindowTabs(window);
        MWindow clientWindow = window.getDuplicated();
        List<MWindowCustom> customWindowList = this.getClientWindowList(window.getAD_Window_ID());
        if (customWindowList != null && customWindowList.size() > 0) {
            for (MWindowCustom customWindow : customWindowList) {
                this.mergeWindow(clientWindow, customWindow);
                clientTabs = this.mergeTabs(clientTabs, customWindow.getTabs(), customWindow.getHierarchyType().equals("O"), 1);
            }
            windowCache.put(this.getClientKey(window.getAD_Window_ID()), clientWindow);
            tabCache.put(this.getClientKey(window.getAD_Window_ID()), clientTabs);
        } else {
            this.loadTranslation(window);
        }
        return clientWindow;
    }

    private MProcess getClientProcess(MProcess process) {
        List<MProcessPara> clientParameters = this.loadProcessParameters(process);
        MProcess clientProcess = process.getDuplicated();
        List<MProcessCustom> customProcessList = this.getClientProcessList(process.getAD_Process_ID());
        if (customProcessList != null && customProcessList.size() > 0) {
            for (MProcessCustom customProcess : customProcessList) {
                this.mergeProcess(clientProcess, customProcess);
                clientParameters = this.mergeParameters(clientParameters, customProcess.getParameters(), customProcess.getHierarchyType().equals("O"));
            }
            processCache.put(this.getClientKey(process.getAD_Process_ID()), clientProcess);
            processParameterCache.put(this.getClientKey(process.getAD_Process_ID()), clientParameters);
        }
        return clientProcess;
    }

    private MBrowse getClientBrowse(MBrowse browse) {
        List<MBrowseField> clientBrowseFields = this.loadBrowseFields(browse);
        MBrowse clientBrowse = browse.getDuplicated();
        List<MBrowseCustom> customBrowseList = this.getClientBrowseList(browse.getAD_Browse_ID());
        if (customBrowseList != null && customBrowseList.size() > 0) {
            for (MBrowseCustom customBrowse : customBrowseList) {
                this.mergeBrowse(clientBrowse, customBrowse);
                clientBrowseFields = this.mergeBrowseFields(clientBrowseFields, customBrowse.getFields(), customBrowse.getHierarchyType().equals("O"));
            }
            browseCache.put(this.getClientKey(browse.getAD_Browse_ID()), clientBrowse);
            browseFieldCache.put(this.getClientKey(browse.getAD_Browse_ID()), clientBrowseFields);
        }
        return clientBrowse;
    }

    private MBrowse getRoleBrowse(MBrowse browse) {
        MBrowse roleBrowse = browse.getDuplicated();
        List<MBrowseField> roleFields = browseFieldCache.get(this.getRoleKey(browse.getAD_Browse_ID()));
        List<MBrowseCustom> customBrowseList = this.getRoleBrowseList(browse.getAD_Browse_ID());
        if (customBrowseList != null && customBrowseList.size() > 0) {
            for (MBrowseCustom customBrowse : customBrowseList) {
                this.mergeBrowse(roleBrowse, customBrowse);
                roleFields = this.mergeBrowseFields(roleFields, customBrowse.getFields(), customBrowse.getHierarchyType().equals("O"));
            }
            browseCache.put(this.getRoleKey(browse.getAD_Browse_ID()), roleBrowse);
            browseFieldCache.put(this.getRoleKey(browse.getAD_Browse_ID()), roleFields);
        }
        return roleBrowse;
    }

    private MBrowse getUserBrowse(MBrowse browse) {
        MBrowse userFields = browse.getDuplicated();
        List<MBrowseField> userBrowseFields = browseFieldCache.get(this.getUserKey(browse.getAD_Browse_ID()));
        List<MBrowseCustom> customBrowseList = this.getUserBrowseList(browse.getAD_Browse_ID());
        if (customBrowseList != null && customBrowseList.size() > 0) {
            for (MBrowseCustom customBrowse : customBrowseList) {
                this.mergeBrowse(userFields, customBrowse);
                userBrowseFields = this.mergeBrowseFields(userBrowseFields, customBrowse.getFields(), customBrowse.getHierarchyType().equals("O"));
            }
            browseCache.put(this.getUserKey(browse.getAD_Browse_ID()), userFields);
            browseFieldCache.put(this.getUserKey(browse.getAD_Browse_ID()), userBrowseFields);
        }
        return userFields;
    }

    private MProcess getRoleProcess(MProcess process) {
        MProcess roleProcess = process.getDuplicated();
        List<MProcessPara> roleParameters = processParameterCache.get(this.getRoleKey(process.getAD_Process_ID()));
        List<MProcessCustom> customProcessList = this.getRoleProcessList(process.getAD_Process_ID());
        if (customProcessList != null && customProcessList.size() > 0) {
            for (MProcessCustom customProcess : customProcessList) {
                this.mergeProcess(roleProcess, customProcess);
                roleParameters = this.mergeParameters(roleParameters, customProcess.getParameters(), customProcess.getHierarchyType().equals("O"));
            }
            processCache.put(this.getRoleKey(process.getAD_Process_ID()), roleProcess);
            processParameterCache.put(this.getRoleKey(process.getAD_Process_ID()), roleParameters);
        }
        return roleProcess;
    }

    private MWindow getRoleWindow(MWindow window) {
        MWindow roleWindow = window.getDuplicated();
        List<MTab> roleTabs = tabCache.get(this.getClientKey(window.getAD_Window_ID()));
        List<MWindowCustom> customWindowList = this.getRoleWindowList(window.getAD_Window_ID());
        if (customWindowList != null && customWindowList.size() > 0) {
            for (MWindowCustom customWindow : customWindowList) {
                this.mergeWindow(roleWindow, customWindow);
                roleTabs = this.mergeTabs(roleTabs, customWindow.getTabs(), customWindow.getHierarchyType().equals("O"), 2);
            }
            windowCache.put(this.getRoleKey(window.getAD_Window_ID()), roleWindow);
            tabCache.put(this.getRoleKey(window.getAD_Window_ID()), roleTabs);
        }
        return roleWindow;
    }

    private MProcess getUserProcess(MProcess process) {
        MProcess userProcess = process.getDuplicated();
        List<MProcessPara> userParameters = processParameterCache.get(this.getUserKey(process.getAD_Process_ID()));
        List<MProcessCustom> customProcessList = this.getUserProcessList(process.getAD_Process_ID());
        if (customProcessList != null && customProcessList.size() > 0) {
            for (MProcessCustom customProcess : customProcessList) {
                this.mergeProcess(userProcess, customProcess);
                userParameters = this.mergeParameters(userParameters, customProcess.getParameters(), customProcess.getHierarchyType().equals("O"));
            }
            processCache.put(this.getUserKey(process.getAD_Process_ID()), userProcess);
            processParameterCache.put(this.getUserKey(process.getAD_Process_ID()), userParameters);
        }
        return userProcess;
    }

    private MWindow getUserWindow(MWindow window) {
        MWindow userWindow = window.getDuplicated();
        List<MTab> userTabs = tabCache.get(this.getRoleKey(window.getAD_Window_ID()));
        List<MWindowCustom> customProcessList = this.getUserWindowList(window.getAD_Window_ID());
        if (customProcessList != null && customProcessList.size() > 0) {
            for (MWindowCustom customProcess : customProcessList) {
                this.mergeWindow(userWindow, customProcess);
                userTabs = this.mergeTabs(userTabs, customProcess.getTabs(), customProcess.getHierarchyType().equals("O"), 3);
            }
            windowCache.put(this.getUserKey(window.getAD_Window_ID()), userWindow);
            tabCache.put(this.getUserKey(window.getAD_Window_ID()), userTabs);
        }
        return userWindow;
    }

    private String getClientKey(int objectId) {
        return objectId + "|C|" + this.clientId + "|" + this.language;
    }

    private String getRoleKey(int objectId) {
        return objectId + "|R|" + this.roleId + "|" + this.language;
    }

    private String getUserKey(int objectId) {
        return objectId + "|U|" + this.userId + "|" + this.language;
    }

    private String getDictionaryKey(int objectId) {
        return String.valueOf(objectId) + "|" + this.language;
    }

    private void mergeProcess(MProcess process, MProcessCustom customProcess) {
        if (!Util.isEmpty(customProcess.getName())) {
            process.setName(customProcess.getName());
        }
        if (!Util.isEmpty(customProcess.getDescription())) {
            process.setDescription(customProcess.getDescription());
        }
        if (!Util.isEmpty(customProcess.getHelp())) {
            process.setHelp(customProcess.getHelp());
        }
        if (!Language.isBaseLanguage(this.language)) {
            String value = customProcess.get_Translation("Name", this.language);
            if (Util.isEmpty(value)) {
                value = process.get_Translation("Name", this.language);
            }
            if (!Util.isEmpty(value)) {
                process.setName(value);
            }
            if (Util.isEmpty(value = customProcess.get_Translation("Description", this.language))) {
                value = process.get_Translation("Description", this.language);
            }
            if (!Util.isEmpty(value)) {
                process.setDescription(value);
            }
            if (Util.isEmpty(value = customProcess.get_Translation("Help", this.language))) {
                value = process.get_Translation("Help", this.language);
            }
            if (!Util.isEmpty(value)) {
                process.setHelp(value);
            }
        }
        if (!Util.isEmpty(customProcess.getShowHelp())) {
            process.setShowHelp(customProcess.getShowHelp());
        }
        if (customProcess.getAD_ReportView_ID() > 0) {
            process.setAD_ReportView_ID(customProcess.getAD_ReportView_ID());
        }
        if (customProcess.getAD_PrintFormat_ID() > 0) {
            process.setAD_PrintFormat_ID(customProcess.getAD_PrintFormat_ID());
        }
        if (!Util.isEmpty(customProcess.getIsDirectPrint())) {
            process.setIsDirectPrint(customProcess.getIsDirectPrint().equals("Y"));
        }
        if (customProcess.getAD_Browse_ID() > 0) {
            process.setAD_Browse_ID(customProcess.getAD_Browse_ID());
        }
        if (customProcess.getAD_Form_ID() > 0) {
            process.setAD_Form_ID(customProcess.getAD_Form_ID());
        }
        if (customProcess.getAD_Workflow_ID() > 0) {
            process.setAD_Workflow_ID(customProcess.getAD_Workflow_ID());
        }
    }

    private void mergeBrowse(MBrowse browse, MBrowseCustom customBrowse) {
        if (!Util.isEmpty(customBrowse.getName())) {
            browse.setName(customBrowse.getName());
        }
        if (!Util.isEmpty(customBrowse.getDescription())) {
            browse.setDescription(customBrowse.getDescription());
        }
        if (!Util.isEmpty(customBrowse.getHelp())) {
            browse.setHelp(customBrowse.getHelp());
        }
        if (!Language.isBaseLanguage(this.language)) {
            String value = customBrowse.get_Translation("Name", this.language);
            if (Util.isEmpty(value)) {
                value = browse.get_Translation("Name", this.language);
            }
            if (!Util.isEmpty(value)) {
                browse.setName(value);
            }
            if (Util.isEmpty(value = customBrowse.get_Translation("Description", this.language))) {
                value = browse.get_Translation("Description", this.language);
            }
            if (!Util.isEmpty(value)) {
                browse.setDescription(value);
            }
            if (Util.isEmpty(value = customBrowse.get_Translation("Help", this.language))) {
                value = browse.get_Translation("Help", this.language);
            }
            if (!Util.isEmpty(value)) {
                browse.setHelp(value);
            }
        }
        if (customBrowse.getAD_Process_ID() > 0) {
            browse.setAD_Process_ID(customBrowse.getAD_Process_ID());
        }
        if (!Util.isEmpty(customBrowse.getWhereClause())) {
            browse.setWhereClause(customBrowse.getWhereClause());
        }
        if (customBrowse.getAD_Window_ID() > 0) {
            browse.setAD_Window_ID(customBrowse.getAD_Window_ID());
        }
        if (customBrowse.getAD_Table_ID() > 0) {
            browse.setAD_Table_ID(customBrowse.getAD_Table_ID());
        }
        if (!Util.isEmpty(customBrowse.getIsUpdateable())) {
            browse.setIsUpdateable(customBrowse.getIsUpdateable().equals("Y"));
        }
        if (!Util.isEmpty(customBrowse.getIsDeleteable())) {
            browse.setIsDeleteable(customBrowse.getIsDeleteable().equals("Y"));
        }
        if (!Util.isEmpty(customBrowse.getIsSelectedByDefault())) {
            browse.setIsSelectedByDefault(customBrowse.getIsSelectedByDefault().equals("Y"));
        }
        if (!Util.isEmpty(customBrowse.getIsCollapsibleByDefault())) {
            browse.setIsCollapsibleByDefault(customBrowse.getIsCollapsibleByDefault().equals("Y"));
        }
        if (!Util.isEmpty(customBrowse.getIsExecutedQueryByDefault())) {
            browse.setIsExecutedQueryByDefault(customBrowse.getIsExecutedQueryByDefault().equals("Y"));
        }
        if (!Util.isEmpty(customBrowse.getIsShowTotal())) {
            browse.setIsShowTotal(customBrowse.getIsShowTotal().equals("Y"));
        }
    }

    private void mergeWindow(MWindow window, MWindowCustom customWindow) {
        if (!Util.isEmpty(customWindow.getName())) {
            window.setName(customWindow.getName());
        }
        if (!Util.isEmpty(customWindow.getDescription())) {
            window.setDescription(customWindow.getDescription());
        }
        if (!Util.isEmpty(customWindow.getHelp())) {
            window.setHelp(customWindow.getHelp());
        }
        if (!Language.isBaseLanguage(this.language)) {
            String value = customWindow.get_Translation("Name", this.language);
            if (Util.isEmpty(value)) {
                value = window.get_Translation("Name", this.language);
            }
            if (!Util.isEmpty(value)) {
                window.setName(value);
            }
            if (Util.isEmpty(value = customWindow.get_Translation("Description", this.language))) {
                value = window.get_Translation("Description", this.language);
            }
            if (!Util.isEmpty(value)) {
                window.setDescription(value);
            }
            if (Util.isEmpty(value = customWindow.get_Translation("Help", this.language))) {
                value = window.get_Translation("Help", this.language);
            }
            if (!Util.isEmpty(value)) {
                window.setHelp(value);
            }
        }
        if (!Util.isEmpty(customWindow.getWindowType())) {
            window.setWindowType(customWindow.getWindowType());
        }
        if (customWindow.getAD_ContextInfo_ID() > 0) {
            window.setAD_ContextInfo_ID(customWindow.getAD_ContextInfo_ID());
        }
    }

    private void loadTranslation(PO entity) {
        if (!Language.isBaseLanguage(this.language)) {
            String value = entity.get_Translation("Name", this.language);
            if (!Util.isEmpty(value)) {
                entity.set_ValueOfColumn("Name", (Object)value);
            }
            if (!Util.isEmpty(value = entity.get_Translation("Description", this.language))) {
                entity.set_ValueOfColumn("Description", (Object)value);
            }
            if (!Util.isEmpty(value = entity.get_Translation("Help", this.language))) {
                entity.set_ValueOfColumn("Help", (Object)value);
            }
        }
    }

    private void mergeTab(MTab tab, MTabCustom customTab, boolean overwrite, List<MField> fields, int level) {
        if (!Util.isEmpty(customTab.getName())) {
            tab.setName(customTab.getName());
        }
        if (!Util.isEmpty(customTab.getDescription())) {
            tab.setDescription(customTab.getDescription());
        }
        if (!Util.isEmpty(customTab.getHelp())) {
            tab.setHelp(customTab.getHelp());
        }
        if (!Util.isEmpty(customTab.getCommitWarning())) {
            tab.setCommitWarning(customTab.getCommitWarning());
        }
        if (!Language.isBaseLanguage(this.language)) {
            String value = customTab.get_Translation("Name", this.language);
            if (Util.isEmpty(value)) {
                value = tab.get_Translation("Name", this.language);
            }
            if (!Util.isEmpty(value)) {
                tab.setName(value);
            }
            if (Util.isEmpty(value = customTab.get_Translation("Description", this.language))) {
                value = tab.get_Translation("Description", this.language);
            }
            if (!Util.isEmpty(value)) {
                tab.setDescription(value);
            }
            if (Util.isEmpty(value = customTab.get_Translation("Help", this.language))) {
                value = tab.get_Translation("Help", this.language);
            }
            if (!Util.isEmpty(value)) {
                tab.setHelp(value);
            }
            if (Util.isEmpty(value = customTab.get_Translation("CommitWarning", this.language))) {
                value = tab.get_Translation("CommitWarning", this.language);
            }
            if (!Util.isEmpty(value)) {
                tab.setCommitWarning(value);
            }
        }
        if (overwrite) {
            tab.setIsActive(customTab.isActive());
            tab.setSeqNo(customTab.getSeqNo());
            tab.setTabLevel(customTab.getTabLevel());
        } else {
            if (customTab.isActive()) {
                tab.setIsActive(customTab.isActive());
            }
            if (customTab.getSeqNo() > 0) {
                tab.setSeqNo(customTab.getSeqNo());
            }
            if (customTab.getTabLevel() > 0) {
                tab.setTabLevel(customTab.getTabLevel());
            }
        }
        if (!Util.isEmpty(customTab.getIsSingleRow())) {
            tab.setIsSingleRow(customTab.getIsSingleRow().equals("Y"));
        }
        if (customTab.getAD_Process_ID() > 0) {
            tab.setAD_Process_ID(customTab.getAD_Process_ID());
        }
        if (!Util.isEmpty(customTab.getIsReadOnly())) {
            tab.setIsReadOnly(customTab.getIsReadOnly().equals("Y"));
        }
        if (!Util.isEmpty(customTab.getIsInsertRecord())) {
            tab.setIsInsertRecord(customTab.getIsInsertRecord().equals("Y"));
        }
        if (customTab.getAD_ContextInfo_ID() > 0) {
            tab.setAD_ContextInfo_ID(customTab.getAD_ContextInfo_ID());
        }
        if (customTab.getAD_Image_ID() > 0) {
            tab.setAD_Image_ID(customTab.getAD_Image_ID());
        }
        if (!Util.isEmpty(customTab.getDisplayLogic())) {
            tab.setDisplayLogic(customTab.getDisplayLogic());
        }
        if (!Util.isEmpty(customTab.getReadOnlyLogic())) {
            tab.setReadOnlyLogic(customTab.getReadOnlyLogic());
        }
        if (!Util.isEmpty(customTab.getWhereClause())) {
            tab.setWhereClause(customTab.getWhereClause());
        }
        if (!Util.isEmpty(customTab.getOrderByClause())) {
            tab.setOrderByClause(customTab.getOrderByClause());
        }
        fields = this.mergeFields(fields, customTab.getFields(), overwrite);
        if (level == 1) {
            fieldCache.put(this.getClientKey(tab.getAD_Tab_ID()), fields);
        } else if (level == 2) {
            fieldCache.put(this.getRoleKey(tab.getAD_Tab_ID()), fields);
        } else if (level == 3) {
            fieldCache.put(this.getUserKey(tab.getAD_Tab_ID()), fields);
        }
    }

    private List<MField> mergeFields(List<MField> fields, List<MFieldCustom> customFields, boolean overwrite) {
        ArrayList<Object> mergedFields = null;
        if (overwrite) {
            mergedFields = new ArrayList();
            for (MField field : fields) {
                MField fieldToAdd = field.getDuplicated();
                MColumn column = MColumn.get(field.getCtx(), field.getAD_Column_ID());
                if (!column.isKey() && !column.isParent()) {
                    fieldToAdd.setIsActive(false);
                }
                mergedFields.add(fieldToAdd);
            }
        } else {
            mergedFields = new ArrayList<MField>(fields);
        }
        for (int index = 0; index < mergedFields.size(); ++index) {
            MField field;
            field = (MField)mergedFields.get(index);
            customFields.stream().filter(customField -> customField.getAD_Field_ID() == field.getAD_Field_ID()).forEach(customField -> this.mergeField(field, (MFieldCustom)customField, overwrite));
            mergedFields.set(index, field);
        }
        mergedFields.sort(Comparator.comparing(X_AD_Field::getSeqNo));
        return mergedFields;
    }

    private void mergeProcessParameter(MProcessPara processParameter, MProcessParaCustom customProcessParameter, boolean overwrite) {
        if (!Util.isEmpty(customProcessParameter.getName())) {
            processParameter.setName(customProcessParameter.getName());
        }
        if (!Util.isEmpty(customProcessParameter.getDescription())) {
            processParameter.setDescription(customProcessParameter.getDescription());
        }
        if (!Util.isEmpty(customProcessParameter.getHelp())) {
            processParameter.setHelp(customProcessParameter.getHelp());
        }
        if (!Language.isBaseLanguage(this.language)) {
            String value = customProcessParameter.get_Translation("Name", this.language);
            if (Util.isEmpty(value)) {
                value = processParameter.get_Translation("Name", this.language);
            }
            if (!Util.isEmpty(value)) {
                processParameter.setName(value);
            }
            if (Util.isEmpty(value = customProcessParameter.get_Translation("Description", this.language))) {
                value = processParameter.get_Translation("Description", this.language);
            }
            if (!Util.isEmpty(value)) {
                processParameter.setDescription(value);
            }
            if (Util.isEmpty(value = customProcessParameter.get_Translation("Help", this.language))) {
                value = processParameter.get_Translation("Help", this.language);
            }
            if (!Util.isEmpty(value)) {
                processParameter.setHelp(value);
            }
        }
        if (customProcessParameter.getAD_Reference_ID() > 0) {
            processParameter.setAD_Reference_ID(customProcessParameter.getAD_Reference_ID());
        }
        if (customProcessParameter.getAD_Reference_Value_ID() > 0) {
            processParameter.setAD_Reference_Value_ID(customProcessParameter.getAD_Reference_Value_ID());
        }
        if (!Util.isEmpty(customProcessParameter.getIsMandatory())) {
            processParameter.setIsMandatory(customProcessParameter.getIsMandatory().equals("Y"));
        }
        if (customProcessParameter.getAD_Val_Rule_ID() > 0) {
            processParameter.setAD_Val_Rule_ID(customProcessParameter.getAD_Val_Rule_ID());
        }
        if (overwrite) {
            processParameter.setSeqNo(customProcessParameter.getSeqNo());
            processParameter.setIsActive(customProcessParameter.isActive());
        } else if (customProcessParameter.getSeqNo() > 0) {
            processParameter.setSeqNo(customProcessParameter.getSeqNo());
        }
        processParameter.setIsActive(customProcessParameter.isActive());
        if (!Util.isEmpty(customProcessParameter.getDefaultValue())) {
            processParameter.setDefaultValue(customProcessParameter.getDefaultValue());
        }
        if (!Util.isEmpty(customProcessParameter.getDefaultValue2())) {
            processParameter.setDefaultValue2(customProcessParameter.getDefaultValue2());
        }
        if (!Util.isEmpty(customProcessParameter.getIsRange())) {
            processParameter.setIsRange(customProcessParameter.getIsRange().equals("Y"));
        }
        if (!Util.isEmpty(customProcessParameter.getDisplayLogic())) {
            processParameter.setDisplayLogic(customProcessParameter.getDisplayLogic());
        }
        if (!Util.isEmpty(customProcessParameter.getReadOnlyLogic())) {
            processParameter.setReadOnlyLogic(customProcessParameter.getReadOnlyLogic());
        }
        if (!Util.isEmpty(customProcessParameter.getIsInfoOnly())) {
            processParameter.setIsInfoOnly(customProcessParameter.getIsInfoOnly().equals("Y"));
        }
        if (!Util.isEmpty(customProcessParameter.getVFormat())) {
            processParameter.setVFormat(customProcessParameter.getVFormat());
        }
        if (!Util.isEmpty(customProcessParameter.getValueMin())) {
            processParameter.setValueMin(customProcessParameter.getValueMin());
        }
        if (!Util.isEmpty(customProcessParameter.getValueMax())) {
            processParameter.setValueMax(customProcessParameter.getValueMax());
        }
    }

    private void mergeBrowseField(MBrowseField browseField, MBrowseFieldCustom customBrowseField, boolean overwrite) {
        if (!Util.isEmpty(customBrowseField.getName())) {
            browseField.setName(customBrowseField.getName());
        }
        if (!Util.isEmpty(customBrowseField.getDescription())) {
            browseField.setDescription(customBrowseField.getDescription());
        }
        if (!Util.isEmpty(customBrowseField.getHelp())) {
            browseField.setHelp(customBrowseField.getHelp());
        }
        if (!Language.isBaseLanguage(this.language)) {
            String value = customBrowseField.get_Translation("Name", this.language);
            if (Util.isEmpty(value)) {
                value = browseField.get_Translation("Name", this.language);
            }
            if (!Util.isEmpty(value)) {
                browseField.setName(value);
            }
            if (Util.isEmpty(value = customBrowseField.get_Translation("Description", this.language))) {
                value = browseField.get_Translation("Description", this.language);
            }
            if (!Util.isEmpty(value)) {
                browseField.setDescription(value);
            }
            if (Util.isEmpty(value = customBrowseField.get_Translation("Help", this.language))) {
                value = browseField.get_Translation("Help", this.language);
            }
            if (!Util.isEmpty(value)) {
                browseField.setHelp(value);
            }
        }
        if (customBrowseField.getAD_Reference_ID() > 0) {
            browseField.setAD_Reference_ID(customBrowseField.getAD_Reference_ID());
        }
        if (customBrowseField.getAD_Reference_Value_ID() > 0) {
            browseField.setAD_Reference_Value_ID(customBrowseField.getAD_Reference_Value_ID());
        }
        if (!Util.isEmpty(customBrowseField.getIsMandatory())) {
            browseField.setIsMandatory(customBrowseField.getIsMandatory().equals("Y"));
        }
        if (customBrowseField.getAD_Val_Rule_ID() > 0) {
            browseField.setAD_Val_Rule_ID(customBrowseField.getAD_Val_Rule_ID());
        }
        if (overwrite) {
            browseField.setSeqNo(customBrowseField.getSeqNo());
            browseField.setSeqNoGrid(customBrowseField.getSeqNoGrid());
            browseField.setIsActive(customBrowseField.isActive());
            browseField.setIsDisplayed(customBrowseField.isDisplayed());
            browseField.setIsQueryCriteria(customBrowseField.isQueryCriteria());
            browseField.setIsOrderBy(customBrowseField.isOrderBy());
            browseField.setSortNo(customBrowseField.getSortNo());
        } else {
            if (customBrowseField.getSeqNo() > 0) {
                browseField.setSeqNo(customBrowseField.getSeqNo());
                browseField.setSeqNoGrid(customBrowseField.getSeqNoGrid());
            }
            if (customBrowseField.getSeqNoGrid() > 0) {
                browseField.setSeqNoGrid(customBrowseField.getSeqNoGrid());
            }
            if (customBrowseField.isActive()) {
                browseField.setIsActive(customBrowseField.isActive());
            }
            if (customBrowseField.isQueryCriteria()) {
                browseField.setIsQueryCriteria(customBrowseField.isQueryCriteria());
            }
        }
        if (!Util.isEmpty(customBrowseField.getDefaultValue())) {
            browseField.setDefaultValue(customBrowseField.getDefaultValue());
        }
        if (!Util.isEmpty(customBrowseField.getDefaultValue2())) {
            browseField.setDefaultValue2(customBrowseField.getDefaultValue2());
        }
        if (!Util.isEmpty(customBrowseField.getIsRange())) {
            browseField.setIsRange(customBrowseField.getIsRange().equals("Y"));
        }
        if (!Util.isEmpty(customBrowseField.getDisplayLogic())) {
            browseField.setDisplayLogic(customBrowseField.getDisplayLogic());
        }
        if (!Util.isEmpty(customBrowseField.getReadOnlyLogic())) {
            browseField.setReadOnlyLogic(customBrowseField.getReadOnlyLogic());
        }
        if (!Util.isEmpty(customBrowseField.getIsInfoOnly())) {
            browseField.setIsInfoOnly(customBrowseField.getIsInfoOnly().equals("Y"));
        }
        if (!Util.isEmpty(customBrowseField.getVFormat())) {
            browseField.setVFormat(customBrowseField.getVFormat());
        }
        if (!Util.isEmpty(customBrowseField.getValueMin())) {
            browseField.setValueMin(customBrowseField.getValueMin());
        }
        if (!Util.isEmpty(customBrowseField.getValueMax())) {
            browseField.setValueMax(customBrowseField.getValueMax());
        }
        if (customBrowseField.getAxis_Column_ID() > 0) {
            browseField.setAxis_Column_ID(customBrowseField.getAxis_Column_ID());
        }
        if (customBrowseField.getAxis_Parent_Column_ID() > 0) {
            browseField.setAxis_Parent_Column_ID(customBrowseField.getAxis_Parent_Column_ID());
        }
    }

    private void mergeField(MField field, MFieldCustom customField, boolean overwrite) {
        if (!Util.isEmpty(customField.getName())) {
            field.setName(customField.getName());
        }
        if (!Util.isEmpty(customField.getDescription())) {
            field.setDescription(customField.getDescription());
        }
        if (!Util.isEmpty(customField.getHelp())) {
            field.setHelp(customField.getHelp());
        }
        if (!Language.isBaseLanguage(this.language)) {
            String value = customField.get_Translation("Name", this.language);
            if (Util.isEmpty(value)) {
                value = field.get_Translation("Name", this.language);
            }
            if (!Util.isEmpty(value)) {
                field.setName(value);
            }
            if (Util.isEmpty(value = customField.get_Translation("Description", this.language))) {
                value = field.get_Translation("Description", this.language);
            }
            if (!Util.isEmpty(value)) {
                field.setDescription(value);
            }
            if (Util.isEmpty(value = customField.get_Translation("Help", this.language))) {
                value = field.get_Translation("Help", this.language);
            }
            if (!Util.isEmpty(value)) {
                field.setHelp(value);
            }
        }
        if (overwrite) {
            field.setSeqNo(customField.getSeqNo());
            field.setSeqNoGrid(customField.getSeqNoGrid());
            field.setIsActive(customField.isActive());
        } else {
            if (customField.getSeqNo() > 0) {
                field.setSeqNo(customField.getSeqNo());
            }
            if (customField.getSeqNoGrid() > 0) {
                field.setSeqNoGrid(customField.getSeqNoGrid());
            }
            if (customField.isActive()) {
                field.setIsActive(customField.isActive());
            }
        }
        field.setIsDisplayed(customField.isDisplayed());
        if (!Util.isEmpty(customField.getIsEmbedded())) {
            field.setIsEmbedded(customField.getIsEmbedded().equals("Y"));
        }
        if (customField.getAD_FieldGroup_ID() > 0) {
            field.setAD_FieldGroup_ID(customField.getAD_FieldGroup_ID());
        }
        if (!Util.isEmpty(customField.getIsDisplayedGrid())) {
            field.setIsDisplayedGrid(customField.getIsDisplayedGrid().equals("Y"));
        }
        if (!Util.isEmpty(customField.getIsReadOnly())) {
            field.setIsReadOnly(customField.getIsReadOnly().equals("Y"));
        }
        if (!Util.isEmpty(customField.getIsAllowCopy())) {
            field.setIsAllowCopy(customField.getIsAllowCopy().equals("Y"));
        }
        if (!Util.isEmpty(customField.getDisplayLogic())) {
            field.setDisplayLogic(customField.getDisplayLogic());
        }
        if (!Util.isEmpty(customField.getIsEncrypted())) {
            field.setIsEncrypted(customField.getIsEncrypted().equals("Y"));
        }
        if (!Util.isEmpty(customField.getIsSameLine())) {
            field.setIsSameLine(customField.getIsSameLine().equals("Y"));
        }
        if (customField.getSortNo() > 0) {
            field.setSortNo(new BigDecimal(customField.getSortNo()));
        }
        if (!Util.isEmpty(customField.getObscureType())) {
            field.setObscureType(customField.getObscureType());
        }
        if (!Util.isEmpty(customField.getIsHeading())) {
            field.setIsHeading(customField.getIsHeading().equals("Y"));
        }
        if (!Util.isEmpty(customField.getIsFieldOnly())) {
            field.setIsFieldOnly(customField.getIsFieldOnly().equals("Y"));
        }
        if (customField.getAD_FieldDefinition_ID() > 0) {
            field.setAD_FieldDefinition_ID(customField.getAD_FieldDefinition_ID());
        }
        if (customField.getAD_Reference_ID() > 0) {
            field.setAD_Reference_ID(customField.getAD_Reference_ID());
        }
        if (customField.getAD_Reference_Value_ID() > 0) {
            field.setAD_Reference_Value_ID(customField.getAD_Reference_Value_ID());
        }
        if (customField.getAD_Val_Rule_ID() > 0) {
            field.setAD_Val_Rule_ID(customField.getAD_Val_Rule_ID());
        }
        if (!Util.isEmpty(customField.getIsMandatory())) {
            field.setIsMandatory(customField.getIsMandatory());
        }
        if (customField.getAD_Image_ID() > 0) {
            field.setAD_Image_ID(customField.getAD_Image_ID());
        }
        if (!Util.isEmpty(customField.getDefaultValue())) {
            field.setDefaultValue(customField.getDefaultValue());
        }
        if (!Util.isEmpty(customField.getIsQuickEntry())) {
            field.setIsQuickEntry(customField.getIsQuickEntry().equals("Y"));
        }
        if (!Util.isEmpty(customField.getInfoFactoryClass())) {
            field.setInfoFactoryClass(customField.getInfoFactoryClass());
        }
        if (customField.getAD_ContextInfo_ID() > 0) {
            field.setAD_ContextInfo_ID(customField.getAD_ContextInfo_ID());
        }
    }

    public static void main(String[] args) {
        Adempiere.startup(false);
        int clientId = 11;
        int roleId = 102;
        int userId = 100;
        String language = "es_VE";
        ASPUtil aspUtil = ASPUtil.getInstance(Env.getCtx(), clientId, roleId, userId, language);
        MProcess process = aspUtil.getProcess(54015);
        List<MProcessPara> processParameterList = aspUtil.getProcessParameters(54015);
        System.err.println("Name " + process.getName());
        for (MProcessPara parameter : processParameterList) {
            System.err.println(parameter.getColumnName() + ", " + parameter.isActive() + ", " + parameter.isRange());
        }
        MWindow window = aspUtil.getWindow(53553);
        List<MTab> tabs = aspUtil.getWindowTabs(53553);
        System.err.println("Window == " + window.getName());
        for (MTab tab : tabs) {
            System.err.println("Tab == " + tab.getName());
            List<MField> fields = aspUtil.getWindowFields(tab.getAD_Tab_ID());
            for (MField field : fields) {
                System.err.println("Field == " + field.getName() + " Displayed: " + field.isDisplayed() + " Active: " + field.isActive());
            }
        }
    }
}

