/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MArchive;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MClientInfo;
import org.compiere.model.MImage;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.spin.process.SetupFileStorageSystemAbstract;
import org.spin.util.AttachmentUtil;

public class SetupFileStorageSystem
extends SetupFileStorageSystemAbstract {
    private AtomicInteger processed = new AtomicInteger();
    private AtomicInteger ignored = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();

    @Override
    protected String doIt() throws Exception {
        this.migrateAttachment();
        this.migrateImage();
        this.migrateArchive();
        if (this.errors.get() == 0) {
            MClientInfo clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID());
            clientInfo.setFileHandler_ID(this.getFileHandlerId());
            clientInfo.saveEx();
        }
        return "@Processed@ (" + this.processed.get() + ") @Ignored@ (" + this.ignored.get() + ") @Errors@ (" + this.errors.get() + ")";
    }

    private void migrateAttachment() {
        this.addLog("@AD_Attachment_ID@");
        new Query(this.getCtx(), "AD_Attachment", null, this.get_TrxName()).setClient_ID().list().forEach(attachment -> Arrays.asList(attachment.getEntries()).forEach(entry -> Trx.run(new TrxRunnable((MAttachment)attachment, (MAttachmentEntry)entry){
            final /* synthetic */ MAttachment val$attachment;
            final /* synthetic */ MAttachmentEntry val$entry;
            {
                this.val$attachment = mAttachment;
                this.val$entry = mAttachmentEntry;
            }

            @Override
            public void run(String trxName) {
                int attachmentReferenceId = DB.getSQLValue(SetupFileStorageSystem.this.get_TrxName(), "SELECT AD_AttachmentReference_ID FROM AD_AttachmentReference WHERE AD_Attachment_ID = ? AND FileName = ?", this.val$attachment.getAD_Attachment_ID(), this.val$entry.getName());
                if (attachmentReferenceId < 0) {
                    try {
                        AttachmentUtil.getInstance(SetupFileStorageSystem.this.getCtx()).withFileHandlerId(SetupFileStorageSystem.this.getFileHandlerId()).withAttachmentId(this.val$attachment.getAD_Attachment_ID()).withFileName(this.val$entry.getName()).withDescription(Msg.getMsg(SetupFileStorageSystem.this.getCtx(), "CreatedFromSetupExternalStorage")).withData(this.val$entry.getData()).saveAttachment();
                        SetupFileStorageSystem.this.addLog(this.val$entry.getName() + ": @Ok@");
                        SetupFileStorageSystem.this.processed.incrementAndGet();
                    }
                    catch (Exception e) {
                        SetupFileStorageSystem.this.log.warning("Error: " + e.getLocalizedMessage());
                        SetupFileStorageSystem.this.addLog("@ErrorProcessingFile@ " + this.val$entry.getName() + ": " + e.getLocalizedMessage());
                        SetupFileStorageSystem.this.errors.incrementAndGet();
                    }
                } else {
                    SetupFileStorageSystem.this.addLog(this.val$entry.getName() + ": @Ignored@");
                    SetupFileStorageSystem.this.ignored.incrementAndGet();
                }
            }
        })));
    }

    private void migrateImage() {
        this.addLog("@AD_Image_ID@");
        KeyNamePair[] imageArray = DB.getKeyNamePairs("SELECT AD_Image_ID, Name FROM AD_Image WHERE AD_Client_ID = ? AND NOT EXISTS(SELECT 1 FROM AD_AttachmentReference ar WHERE ar.AD_Image_ID = AD_Image.AD_Image_ID)", false, this.getAD_Client_ID());
        Arrays.asList(imageArray).forEach(imagePair -> Trx.run(new TrxRunnable((KeyNamePair)imagePair){
            final /* synthetic */ KeyNamePair val$imagePair;
            {
                this.val$imagePair = keyNamePair;
            }

            @Override
            public void run(String trxName) {
                MImage image = MImage.get(SetupFileStorageSystem.this.getCtx(), this.val$imagePair.getKey());
                try {
                    AttachmentUtil.getInstance(SetupFileStorageSystem.this.getCtx()).withFileHandlerId(SetupFileStorageSystem.this.getFileHandlerId()).withImageId(image.getAD_Image_ID()).withFileName(image.getName()).withDescription(Msg.getMsg(SetupFileStorageSystem.this.getCtx(), "CreatedFromSetupExternalStorage")).withData(image.getData()).saveAttachment();
                    SetupFileStorageSystem.this.addLog(image.getName() + ": @Ok@");
                    SetupFileStorageSystem.this.processed.incrementAndGet();
                }
                catch (Exception e) {
                    SetupFileStorageSystem.this.log.warning("Error: " + e.getLocalizedMessage());
                    SetupFileStorageSystem.this.addLog("@ErrorProcessingFile@ " + image.getName() + ": " + e.getLocalizedMessage());
                    SetupFileStorageSystem.this.errors.incrementAndGet();
                }
            }
        }));
    }

    private void migrateArchive() {
        this.addLog("@AD_Archive_ID@");
        KeyNamePair[] archiveArray = DB.getKeyNamePairs("SELECT AD_Archive_ID, Name FROM AD_Archive WHERE AD_Client_ID = ? AND NOT EXISTS(SELECT 1 FROM AD_AttachmentReference ar WHERE ar.AD_Archive_ID = AD_Archive.AD_Archive_ID)", false, this.getAD_Client_ID());
        Arrays.asList(archiveArray).forEach(archivePair -> Trx.run(new TrxRunnable((KeyNamePair)archivePair){
            final /* synthetic */ KeyNamePair val$archivePair;
            {
                this.val$archivePair = keyNamePair;
            }

            @Override
            public void run(String trxName) {
                MArchive archive = new MArchive(SetupFileStorageSystem.this.getCtx(), this.val$archivePair.getKey(), trxName);
                try {
                    String fileName = archive.getName() + ".pdf";
                    AttachmentUtil.getInstance(SetupFileStorageSystem.this.getCtx()).withFileHandlerId(SetupFileStorageSystem.this.getFileHandlerId()).withArchiveId(archive.getAD_Archive_ID()).withFileName(fileName).withDescription(Msg.getMsg(SetupFileStorageSystem.this.getCtx(), "CreatedFromSetupExternalStorage")).withData(archive.getBinaryData()).saveAttachment();
                    SetupFileStorageSystem.this.addLog(fileName + ": @Ok@");
                    SetupFileStorageSystem.this.processed.incrementAndGet();
                }
                catch (Exception e) {
                    SetupFileStorageSystem.this.log.warning("Error: " + e.getLocalizedMessage());
                    SetupFileStorageSystem.this.addLog("@ErrorProcessingFile@ " + archive.getName() + ": " + e.getLocalizedMessage());
                    SetupFileStorageSystem.this.errors.incrementAndGet();
                }
            }
        }));
    }
}

