/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MPayment;
import org.compiere.model.MQuery;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_PrintForm;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.process.PaySelectionSendRemittanceAbstract;

public class PaySelectionSendRemittance
extends PaySelectionSendRemittanceAbstract {
    private MMailText mailText = null;
    private X_AD_PrintForm printForm = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@C_PaySelection_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.printForm = (X_AD_PrintForm)new Query(this.getCtx(), "AD_PrintForm", null, this.get_TrxName()).setClient_ID().first();
        if (this.printForm == null) {
            throw new AdempiereException("@Remittance_PrintFormat_ID@ @NotFound@");
        }
        if (this.printForm.getRemittance_MailText_ID() == 0 && this.getMailTextId() == 0) {
            throw new AdempiereException("@Remittance_MailText_ID@ @NotFound@");
        }
        if (this.getMailTextId() == 0) {
            this.setMailTextId(this.printForm.getRemittance_MailText_ID());
        }
        this.mailText = new MMailText(Env.getCtx(), this.getMailTextId(), this.get_TrxName());
        String bpWhereClause = "";
        if (this.getBPartnerId() != 0) {
            bpWhereClause = " AND C_BPartner_ID = " + this.getBPartnerId();
        }
        AtomicInteger sent = new AtomicInteger();
        AtomicInteger all = new AtomicInteger();
        new Query(this.getCtx(), "C_Payment", "EXISTS(SELECT 1 FROM C_PaySelectionCheck psc \tWHERE psc.C_PaySelection_ID = ? \tAND psc.C_Payment_ID = C_Payment.C_Payment_ID) AND DocStatus IN('CO', 'CL')" + bpWhereClause, this.get_TrxName()).setParameters(this.getRecord_ID()).setClient_ID().list().stream().forEach(payment -> {
            all.addAndGet(1);
            if (this.sendMail((MPayment)payment)) {
                sent.addAndGet(1);
            }
        });
        return "@Processed@: " + all.get() + " - @Sent@: " + sent.get() + " - @Errors@: " + (all.get() - sent.get());
    }

    private boolean sendMail(MPayment payment) {
        MBPartner businessPartner;
        Optional<MUser> optionalUser;
        String businessPartnerBankAccountMail = null;
        MUser businessPartnerBankAccountContact = null;
        if (payment.getC_BP_BankAccount_ID() != 0) {
            MBPBankAccount bankAccount = (MBPBankAccount)payment.getC_BP_BankAccount();
            businessPartnerBankAccountMail = bankAccount.getA_EMail();
            if (bankAccount.getAD_User_ID() != 0) {
                businessPartnerBankAccountContact = MUser.get(this.getCtx(), bankAccount.getAD_User_ID());
                if (Util.isEmpty(businessPartnerBankAccountMail) && !Util.isEmpty(businessPartnerBankAccountContact.getEMail())) {
                    businessPartnerBankAccountMail = businessPartnerBankAccountContact.getEMail();
                }
            }
        }
        if (Util.isEmpty(businessPartnerBankAccountMail) && (optionalUser = Arrays.asList((businessPartner = (MBPartner)payment.getC_BPartner()).getContacts(false)).stream().filter(contact -> !Util.isEmpty(contact.getEMail())).filter(contact -> !Util.isEmpty(contact.getNotificationType()) && (contact.getNotificationType().equals("E") || contact.getNotificationType().equals("B"))).findFirst()).isPresent()) {
            businessPartnerBankAccountContact = optionalUser.get();
            businessPartnerBankAccountMail = businessPartnerBankAccountContact.getEMail();
        }
        if (Util.isEmpty(businessPartnerBankAccountMail)) {
            this.addLog(payment.getC_Payment_ID(), payment.getDateTrx(), null, "@EMail@ @NotFound@ @C_Payment_ID@: " + payment.getDocumentNo());
            return false;
        }
        EMail email = null;
        MClient client = MClient.get(this.getCtx());
        if (this.getAD_User_ID() != 0) {
            MUser from = MUser.get(this.getCtx(), this.getAD_User_ID());
            email = client.createEMail(from, businessPartnerBankAccountMail, null, null, this.mailText.isHtml());
        }
        if (email == null) {
            this.addLog(payment.getC_Payment_ID(), null, null, "@RequestActionEMailNoFrom@: " + businessPartnerBankAccountMail);
            return false;
        }
        if (!email.isValid()) {
            this.addLog(payment.getC_Payment_ID(), null, null, "@RequestActionEMailNoTo@: " + businessPartnerBankAccountMail);
            return false;
        }
        File paymentReport = this.getPDF(payment);
        if (paymentReport == null) {
            this.addLog(payment.getC_Payment_ID(), null, null, "@FilePDF@ @NotFound@");
            return false;
        }
        this.mailText.setPO(payment);
        if (businessPartnerBankAccountContact != null) {
            this.mailText.setUser(businessPartnerBankAccountContact);
        }
        this.mailText.setBPartner((MBPartner)payment.getC_BPartner());
        String message = this.mailText.getMailText(true);
        if (this.mailText.isHtml()) {
            email.setMessageHTML(this.mailText.getMailHeader(), message);
        } else {
            email.setSubject(this.mailText.getMailHeader());
            email.setMessageText(message);
        }
        this.log.fine(businessPartnerBankAccountMail + " - " + paymentReport);
        email.addAttachment(paymentReport);
        String msg = email.send();
        if (businessPartnerBankAccountContact != null) {
            MUserMail userMail = new MUserMail(this.mailText, businessPartnerBankAccountContact.getAD_User_ID(), email);
            userMail.saveEx();
        }
        if (!msg.equals("OK")) {
            this.addLog(payment.getC_Payment_ID(), null, null, "@RequestActionEMailError@: " + msg);
            return false;
        }
        return true;
    }

    private File getPDF(MPayment payment) {
        MPrintFormat format = MPrintFormat.get(this.getCtx(), this.printForm.getRemittance_PrintFormat_ID(), false);
        MQuery query = new MQuery("C_PaySelection_Remittance_v");
        query.addRestriction("C_Payment_ID", "=", new Integer(payment.getC_Payment_ID()));
        PrintInfo info = new PrintInfo(payment.getDocumentNo(), payment.get_Table_ID(), payment.getC_Payment_ID(), payment.getC_BPartner_ID());
        info.setDescription(payment.getDocumentInfo());
        ReportEngine reportEngine = new ReportEngine(this.getCtx(), format, query, info);
        return reportEngine.getPDF();
    }
}

