/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRShiftGroup;
import org.eevolution.model.MHRWorkGroup;
import org.eevolution.model.MHRWorkShift;
import org.eevolution.model.X_HR_Employee;
import org.eevolution.model.X_HR_WorkGroup;
import org.spin.model.MHRAttendanceBatch;
import org.spin.model.MHRAttendanceRecord;
import org.spin.model.X_HR_AttendanceRecord;
import org.spin.model.X_I_HR_AttendanceRecord;
import org.spin.process.ImportAttendanceAbstract;

public class ImportAttendance
extends ImportAttendanceAbstract {
    private MHRAttendanceBatch attendanceBatch = null;
    private int attendanceQuantity = 0;

    @Override
    protected String doIt() throws Exception {
        if (this.isDeleteOldImported()) {
            Arrays.stream(this.getAttendanceIds(true, true, null)).forEach(n -> {
                X_I_HR_AttendanceRecord x_I_HR_AttendanceRecord = new X_I_HR_AttendanceRecord(this.getCtx(), n, null);
                x_I_HR_AttendanceRecord.deleteEx(true);
            });
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicInteger atomicInteger2 = new AtomicInteger(0);
        Arrays.stream(this.getAttendanceIds(false, false, null)).forEach(n -> Trx.run(string -> {
            X_I_HR_AttendanceRecord x_I_HR_AttendanceRecord = new X_I_HR_AttendanceRecord(this.getCtx(), n, string);
            boolean bl = this.fillIdValues(x_I_HR_AttendanceRecord);
            if (bl && !this.isValidateOnly()) {
                if (this.importRecord(x_I_HR_AttendanceRecord)) {
                    atomicInteger.updateAndGet(n -> n + 1);
                } else {
                    atomicInteger2.updateAndGet(n -> n + 1);
                }
            }
        }));
        this.processDocument(null);
        return "@HR_AttendanceRecord_ID@ @Import@ @Records@ " + atomicInteger.get() + " @Errors@ " + atomicInteger2.get();
    }

    private int getWorkShiftId(int n) {
        PO pO;
        Object object;
        MHREmployee mHREmployee = MHREmployee.getById(this.getCtx(), n);
        int n2 = 0;
        if (mHREmployee.getHR_ShiftGroup_ID() != 0 && (object = ((MHRShiftGroup)(pO = MHRShiftGroup.getById(this.getCtx(), mHREmployee.getHR_ShiftGroup_ID(), this.get_TrxName()))).getWorkShiftList(false)) != null) {
            n2 = object.get(0).getHR_WorkShift_ID();
        }
        if (n2 <= 0 && mHREmployee.getHR_WorkGroup_ID() > 0) {
            List<MHRWorkShift> list;
            pO = MHRWorkGroup.getById(this.getCtx(), mHREmployee.getHR_WorkGroup_ID(), this.get_TrxName());
            if (((X_HR_WorkGroup)pO).getHR_WorkShift_ID() > 0) {
                n2 = ((X_HR_WorkGroup)pO).getHR_WorkShift_ID();
            }
            if (n2 <= 0 && ((X_HR_WorkGroup)pO).getHR_ShiftGroup_ID() > 0 && (list = ((MHRShiftGroup)(object = MHRShiftGroup.getById(this.getCtx(), ((X_HR_WorkGroup)pO).getHR_ShiftGroup_ID(), this.get_TrxName()))).getWorkShiftList(false)) != null) {
                n2 = list.get(0).getHR_WorkShift_ID();
            }
        }
        return n2;
    }

    private boolean importRecord(X_I_HR_AttendanceRecord x_I_HR_AttendanceRecord) {
        PO pO;
        int n = this.getWorkShiftId(x_I_HR_AttendanceRecord.getHR_Employee_ID());
        MHRWorkShift mHRWorkShift = MHRWorkShift.getById(this.getCtx(), n);
        if (this.attendanceBatch != null && (this.attendanceBatch.getHR_Employee_ID() != x_I_HR_AttendanceRecord.getHR_Employee_ID() || mHRWorkShift.getMinAttendanceRequire() <= this.attendanceQuantity)) {
            this.processDocument(x_I_HR_AttendanceRecord);
            this.attendanceBatch = null;
        }
        if (this.attendanceBatch == null) {
            this.attendanceQuantity = 0;
            this.attendanceBatch = new MHRAttendanceBatch(this.getCtx(), 0, this.get_TrxName());
            this.attendanceBatch.setDateDoc(TimeUtil.getDay(x_I_HR_AttendanceRecord.getAttendanceTime()));
            pO = MHREmployee.getById(this.getCtx(), x_I_HR_AttendanceRecord.getHR_Employee_ID());
            this.attendanceBatch.setC_BPartner_ID(((X_HR_Employee)pO).getC_BPartner_ID());
            this.attendanceBatch.setHR_Employee_ID(x_I_HR_AttendanceRecord.getHR_Employee_ID());
            n = this.getWorkShiftId(((X_HR_Employee)pO).getHR_Employee_ID());
            if (n <= 0) {
                this.setImportError(x_I_HR_AttendanceRecord, "@HR_WorkShift_ID@ @NotFound@").saveEx(x_I_HR_AttendanceRecord.get_TrxName());
                this.attendanceBatch = null;
            } else {
                this.attendanceBatch.setHR_WorkShift_ID(n);
                this.attendanceBatch.saveEx();
            }
        }
        if (this.attendanceBatch != null) {
            pO = new MHRAttendanceRecord(this.attendanceBatch);
            ((X_HR_AttendanceRecord)pO).setAttendanceTime(x_I_HR_AttendanceRecord.getAttendanceTime());
            ((X_HR_AttendanceRecord)pO).setSeqNo(this.attendanceQuantity * 10);
            pO.saveEx();
            x_I_HR_AttendanceRecord.setHR_AttendanceBatch_ID(this.attendanceBatch.getHR_AttendanceBatch_ID());
            x_I_HR_AttendanceRecord.setHR_AttendanceRecord_ID(((X_HR_AttendanceRecord)pO).getHR_AttendanceRecord_ID());
            x_I_HR_AttendanceRecord.setI_IsImported(true);
            x_I_HR_AttendanceRecord.setI_ErrorMsg("");
            x_I_HR_AttendanceRecord.setProcessed(true);
            x_I_HR_AttendanceRecord.saveEx();
            ++this.attendanceQuantity;
            return true;
        }
        return false;
    }

    private void processDocument(X_I_HR_AttendanceRecord x_I_HR_AttendanceRecord) {
        if (this.attendanceBatch == null) {
            return;
        }
        if (!this.attendanceBatch.processIt("CO") && x_I_HR_AttendanceRecord != null) {
            this.setImportError(x_I_HR_AttendanceRecord, "@Error@ " + this.attendanceBatch.getProcessMsg());
        }
        this.attendanceBatch.saveEx();
        this.addLog(this.attendanceBatch.getHR_AttendanceBatch_ID(), this.attendanceBatch.getDateDoc(), null, this.attendanceBatch.toString());
    }

    private X_I_HR_AttendanceRecord setImportError(X_I_HR_AttendanceRecord x_I_HR_AttendanceRecord, String string) {
        x_I_HR_AttendanceRecord.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), string));
        x_I_HR_AttendanceRecord.setI_IsImported(false);
        x_I_HR_AttendanceRecord.setProcessed(false);
        this.addLog(x_I_HR_AttendanceRecord.getI_HR_AttendanceRecord_ID(), x_I_HR_AttendanceRecord.getAttendanceTime(), null, x_I_HR_AttendanceRecord.getI_ErrorMsg());
        return x_I_HR_AttendanceRecord;
    }

    private boolean fillIdValues(X_I_HR_AttendanceRecord x_I_HR_AttendanceRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        x_I_HR_AttendanceRecord.setI_ErrorMsg("");
        String string = "SELECT HR_Employee_ID FROM HR_Employee WHERE TRIM(Code) = TRIM(?) AND (EmployeeStatus = '13' OR EmployeeStatus IS NULL) AND AD_Client_ID = " + this.getClientId();
        int n = DB.getSQLValue(null, string, x_I_HR_AttendanceRecord.getCode());
        if (n > 0) {
            x_I_HR_AttendanceRecord.setHR_Employee_ID(n);
        } else {
            stringBuilder.append("@HR_Employee_ID@ @NotFound@");
        }
        if (n > 0) {
            if (this.getWorkShiftId(n) <= 0) {
                stringBuilder.append(" @HR_WorkShift_ID@ @NotFound@");
            }
        } else {
            stringBuilder.append(" @HR_WorkShift_ID@ @NotFound@");
        }
        if (stringBuilder.length() > 0) {
            this.setImportError(x_I_HR_AttendanceRecord, stringBuilder.toString()).saveEx(x_I_HR_AttendanceRecord.get_TrxName());
        }
        if (x_I_HR_AttendanceRecord.getI_ErrorMsg() != null && x_I_HR_AttendanceRecord.getI_ErrorMsg().length() > 0) {
            x_I_HR_AttendanceRecord.setProcessed(false);
            x_I_HR_AttendanceRecord.setI_IsImported(false);
            x_I_HR_AttendanceRecord.saveEx();
            return false;
        }
        x_I_HR_AttendanceRecord.saveEx();
        return true;
    }

    private int[] getAttendanceIds(boolean bl, boolean bl2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("I_IsImported").append("=? AND ").append("Processed").append("=?");
        return new Query(this.getCtx(), "I_HR_AttendanceRecord", stringBuilder.toString(), string).setOnlyActiveRecords(true).setParameters(bl, bl2).setOrderBy("Code, AttendanceTime").getIDs();
    }
}

