/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_AD_User;
import org.compiere.model.X_C_BankAccount;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMProduct;
import org.spin.process.GeneratePaySelectionFromLoanAbstract;

public class GeneratePaySelectionFromLoan
extends GeneratePaySelectionFromLoanAbstract {
    private int seqNo = 10;
    private MPaySelection paymentSelection = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0 && this.getBankAccountId() == 0 && this.getPayDate() == null) {
            throw new AdempiereException("@C_PaySelection_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getRecord_ID() > 0 || !this.isSplitPaySelection()) {
            PO pO;
            if (this.getRecord_ID() > 0) {
                this.paymentSelection = new MPaySelection(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
                this.seqNo = this.paymentSelection.getLastLineNo();
            } else if (!this.isSplitPaySelection()) {
                this.paymentSelection = new MPaySelection(this.getCtx(), 0, this.get_TrxName());
                this.paymentSelection.setC_BankAccount_ID(this.getBankAccountId());
                this.paymentSelection.setDateDoc(this.getPayDate());
                this.paymentSelection.setPayDate(this.getPayDate());
                if (this.getDocTypeTargetId() > 0) {
                    this.paymentSelection.setC_DocType_ID(this.getDocTypeTargetId());
                }
                pO = MUser.get(this.getCtx(), this.getAD_User_ID());
                Object object = "";
                if (pO != null) {
                    object = ((X_AD_User)pO).getName();
                }
                this.paymentSelection.setDescription(Msg.getMsg(Env.getCtx(), "VPaySelect") + " - " + (String)object + " - " + DisplayType.getDateFormat(15).format(this.getPayDate()));
            }
            pO = MBankAccount.get(this.getCtx(), this.getBankAccountId());
            for (Integer n : this.getSelectionKeys()) {
                BigDecimal bigDecimal;
                int n2 = n;
                MFMAccount mFMAccount = new MFMAccount(this.getCtx(), n2, this.get_TrxName());
                BigDecimal bigDecimal2 = this.getSelectionAsBigDecimal(n, "AC_OpenCapitalAmt");
                if (bigDecimal2.compareTo(bigDecimal = this.getSelectionAsBigDecimal(n, "AC_PayAmt")) < 0) {
                    throw new AdempiereException("@LoanManagement.OpenCapitalLessPay@");
                }
                MFMAgreement mFMAgreement = (MFMAgreement)mFMAccount.getFM_Agreement();
                MFMProduct mFMProduct = MFMProduct.getById(this.getCtx(), mFMAgreement.get_ValueAsInt("FM_Product_ID"));
                if (mFMProduct == null) {
                    throw new AdempiereException("@FM_Product_ID@ @NotFound@");
                }
                int n3 = mFMProduct.get_ValueAsInt("C_Charge_ID");
                if (this.paymentSelection.is_new()) {
                    this.paymentSelection.setAD_Org_ID(mFMAgreement.getAD_Org_ID());
                    this.paymentSelection.saveEx();
                }
                this.seqNo += 10;
                MPaySelectionLine mPaySelectionLine = new MPaySelectionLine(this.paymentSelection, this.seqNo, this.getPaymentRule());
                mPaySelectionLine.setC_BPartner_ID(mFMAgreement.get_ValueAsInt("C_BPartner_ID"));
                if (n3 != 0) {
                    mPaySelectionLine.setC_Charge_ID(n3);
                }
                mPaySelectionLine.setIsSOTrx(false);
                mPaySelectionLine.setAmtSource(bigDecimal);
                int n4 = MConversionRate.getConversionRateId(mFMAccount.getC_Currency_ID(), ((X_C_BankAccount)pO).getC_Currency_ID(), this.getPayDate(), 0, this.getAD_Client_ID(), this.paymentSelection.getAD_Org_ID());
                if (n4 <= 0 && mFMAccount.getC_Currency_ID() != ((X_C_BankAccount)pO).getC_Currency_ID()) {
                    throw new AdempiereException(MConversionRate.getErrorMessage(this.getCtx(), "NoCurrencyConversion", mFMAccount.getC_Currency_ID(), ((X_C_BankAccount)pO).getC_Currency_ID(), 0, this.getPayDate(), this.get_TrxName()));
                }
                BigDecimal bigDecimal3 = this.convert(n4, bigDecimal);
                if (bigDecimal3 == null && mFMAccount.getC_Currency_ID() == ((X_C_BankAccount)pO).getC_Currency_ID()) {
                    bigDecimal3 = bigDecimal;
                }
                mPaySelectionLine.setOpenAmt(bigDecimal3);
                mPaySelectionLine.setPayAmt(bigDecimal3);
                mPaySelectionLine.setDiscountAmt(Env.ZERO);
                mPaySelectionLine.setDifferenceAmt(Env.ZERO);
                if (n4 > 0) {
                    mPaySelectionLine.setC_Conversion_Rate_ID(n4);
                    MConversionRate mConversionRate = MConversionRate.get(this.getCtx(), n4);
                    if (mConversionRate.getC_ConversionType_ID() != 0) {
                        mPaySelectionLine.setC_ConversionType_ID(mConversionRate.getC_ConversionType_ID());
                    }
                }
                mPaySelectionLine.set_ValueOfColumn("FM_Account_ID", (Object)mFMAccount.getFM_Account_ID());
                mPaySelectionLine.saveEx();
            }
            this.completeDocument();
            stringBuffer.append("@C_PaySelection_ID@: [" + this.paymentSelection.getDocumentNo() + "]");
        } else {
            for (Integer n : this.getSelectionKeys()) {
                this.paymentSelection = new MPaySelection(this.getCtx(), 0, this.get_TrxName());
                this.paymentSelection.setC_BankAccount_ID(this.getBankAccountId());
                this.paymentSelection.setDateDoc(this.getPayDate());
                this.paymentSelection.setPayDate(this.getPayDate());
                if (this.getDocTypeTargetId() > 0) {
                    this.paymentSelection.setC_DocType_ID(this.getDocTypeTargetId());
                }
                MBankAccount mBankAccount = MBankAccount.get(this.getCtx(), this.getBankAccountId());
                int n5 = n;
                MFMAccount mFMAccount = new MFMAccount(this.getCtx(), n5, this.get_TrxName());
                MFMAgreement mFMAgreement = (MFMAgreement)mFMAccount.getFM_Agreement();
                MFMProduct mFMProduct = MFMProduct.getById(this.getCtx(), mFMAgreement.get_ValueAsInt("FM_Product_ID"));
                if (mFMProduct == null) {
                    throw new AdempiereException("@FM_Product_ID@ @NotFound@");
                }
                int n6 = mFMProduct.get_ValueAsInt("C_Charge_ID");
                MBPartner mBPartner = MBPartner.get(this.getCtx(), mFMAgreement.get_ValueAsInt("C_BPartner_ID"));
                if (mBPartner == null) continue;
                this.paymentSelection.setDescription(Msg.parseTranslation(this.getCtx(), "@GeneratedFromLoan@ - " + mBPartner.getValue() + " - " + mBPartner.getName() + " " + DisplayType.getDateFormat(15).format(this.getPayDate())));
                this.paymentSelection.setAD_Org_ID(mFMAgreement.getAD_Org_ID());
                this.paymentSelection.saveEx();
                MPaySelectionLine mPaySelectionLine = new MPaySelectionLine(this.paymentSelection, this.seqNo, this.getPaymentRule());
                BigDecimal bigDecimal = this.getSelectionAsBigDecimal(n, "AC_OpenCapitalAmt");
                BigDecimal bigDecimal4 = this.getSelectionAsBigDecimal(n, "AC_PayAmt");
                if (bigDecimal.compareTo(bigDecimal4) < 0) {
                    throw new AdempiereException("@LoanManagement.OpenCapitalLessPay@");
                }
                this.seqNo += 10;
                mPaySelectionLine.setC_BPartner_ID(mBPartner.getC_BPartner_ID());
                if (n6 != 0) {
                    mPaySelectionLine.setC_Charge_ID(n6);
                }
                mPaySelectionLine.setIsSOTrx(false);
                mPaySelectionLine.setAmtSource(bigDecimal4);
                int n7 = MConversionRate.getConversionRateId(mFMAccount.getC_Currency_ID(), mBankAccount.getC_Currency_ID(), this.getPayDate(), 0, this.getAD_Client_ID(), this.paymentSelection.getAD_Org_ID());
                if (n7 <= 0 && mFMAccount.getC_Currency_ID() != mBankAccount.getC_Currency_ID()) {
                    throw new AdempiereException(MConversionRate.getErrorMessage(this.getCtx(), "NoCurrencyConversion", mFMAccount.getC_Currency_ID(), mBankAccount.getC_Currency_ID(), 0, this.getPayDate(), this.get_TrxName()));
                }
                BigDecimal bigDecimal5 = this.convert(n7, bigDecimal4);
                if (bigDecimal5 == null && mFMAccount.getC_Currency_ID() == mBankAccount.getC_Currency_ID()) {
                    bigDecimal5 = bigDecimal4;
                }
                mPaySelectionLine.setOpenAmt(bigDecimal5);
                mPaySelectionLine.setPayAmt(bigDecimal5);
                mPaySelectionLine.setDiscountAmt(Env.ZERO);
                mPaySelectionLine.setDifferenceAmt(Env.ZERO);
                if (n7 > 0) {
                    mPaySelectionLine.setC_Conversion_Rate_ID(n7);
                    MConversionRate mConversionRate = MConversionRate.get(this.getCtx(), n7);
                    if (mConversionRate.getC_ConversionType_ID() != 0) {
                        mPaySelectionLine.setC_ConversionType_ID(mConversionRate.getC_ConversionType_ID());
                    }
                }
                mPaySelectionLine.set_ValueOfColumn("FM_Account_ID", (Object)mFMAccount.getFM_Account_ID());
                mPaySelectionLine.saveEx();
                this.completeDocument();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("@C_PaySelection_ID@: [" + this.paymentSelection.getDocumentNo() + "]");
            }
        }
        return stringBuffer.toString();
    }

    private BigDecimal convert(int n, BigDecimal bigDecimal) {
        if (n <= 0 || bigDecimal == null) {
            return null;
        }
        MConversionRate mConversionRate = MConversionRate.get(this.getCtx(), n);
        BigDecimal bigDecimal2 = bigDecimal.multiply(mConversionRate.getMultiplyRate());
        int n2 = MCurrency.getStdPrecision(this.getCtx(), mConversionRate.getC_Currency_ID_To());
        if (bigDecimal2.scale() > n2) {
            bigDecimal2 = bigDecimal2.setScale(n2, 4);
        }
        return bigDecimal2;
    }

    private void completeDocument() {
        this.paymentSelection.load(this.get_TrxName());
        if (!this.paymentSelection.processIt("CO")) {
            throw new AdempiereException("@Error@ " + this.paymentSelection.getProcessMsg());
        }
        this.paymentSelection.saveEx();
    }
}

