/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.List;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.process.CreateOrderFromReturnOrderAbstract;

public class CreateOrderFromReturnOrder
extends CreateOrderFromReturnOrderAbstract {
    private Hashtable<Integer, MOrder> orders;
    private int created = 0;
    private StringBuffer generatedDocuments = new StringBuffer();

    @Override
    protected String doIt() throws Exception {
        if (Util.isEmpty(this.getDocAction())) {
            this.setDocAction("CO");
        }
        this.orders = new Hashtable();
        List<Integer> recordIds = this.getSelectionKeys();
        recordIds.stream().forEach(key -> {
            MOrderLine returnOrderLine = new MOrderLine(this.getCtx(), (int)key, this.get_TrxName());
            int uomId = this.getSelectionAsInt((int)key, "CO_C_UOM_ID");
            BigDecimal qtyEntered = this.getSelectionAsBigDecimal((int)key, "CO_QtyEntered");
            this.log.fine("Line QtyEntered=" + qtyEntered + ", Product=" + returnOrderLine.getM_Product_ID() + ", Key=" + key);
            this.createOrder(returnOrderLine, qtyEntered, uomId);
        });
        this.processingOrders();
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createOrder(MOrderLine returnOrderLine, BigDecimal qtyEntered, int uomId) {
        MOrder order = this.getOrder(returnOrderLine);
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setC_UOM_ID(uomId);
        BigDecimal qtyOrdered = null;
        int precision = 2;
        if (returnOrderLine.getM_Product_ID() > 0) {
            MProduct product = MProduct.get(Env.getCtx(), returnOrderLine.getM_Product_ID());
            if (product != null) {
                orderLine.setM_Product_ID(product.getM_Product_ID(), uomId);
                precision = product.getUOMPrecision();
                if (product.getC_UOM_ID() != uomId) {
                    qtyEntered = qtyEntered.setScale(precision, 5);
                    qtyOrdered = MUOMConversion.convertProductFrom(Env.getCtx(), returnOrderLine.getM_Product_ID(), uomId, qtyEntered);
                }
            }
        } else if (returnOrderLine.getC_Charge_ID() != 0) {
            orderLine.setC_Charge_ID(returnOrderLine.getC_Charge_ID());
        }
        qtyEntered = qtyEntered.setScale(precision, 5);
        if (qtyOrdered == null) {
            qtyOrdered = qtyEntered;
        }
        orderLine.setQtyEntered(qtyEntered);
        orderLine.setQtyOrdered(qtyOrdered);
        orderLine.setRef_OrderLine_ID(returnOrderLine.getC_OrderLine_ID());
        orderLine.saveEx();
    }

    private MOrder getOrder(MOrderLine orderLine) {
        MOrder order = this.orders.get(orderLine.getC_Order_ID());
        if (order != null) {
            return order;
        }
        MOrder returnOrder = orderLine.getParent();
        order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues(returnOrder, order);
        order.setDateOrdered(this.getDateOrdered());
        order.setDatePromised(this.getDateOrdered());
        order.addDescription(Msg.parseTranslation(this.getCtx(), "@Created@ @From@ " + returnOrder.getDocumentNo()));
        order.setDocumentNo(null);
        if (this.getDocTypeTargetId() > 0) {
            order.setC_DocType_ID(this.getDocTypeTargetId());
        } else {
            order.setC_DocTypeTarget_ID();
        }
        order.setBPartner((MBPartner)returnOrder.getC_BPartner());
        order.setRef_Order_ID(returnOrder.getC_Order_ID());
        order.setDocAction(this.getDocAction());
        order.setDocStatus("DR");
        order.setProcessed(false);
        order.setIsSOTrx(returnOrder.isSOTrx());
        order.saveEx();
        this.orders.put(returnOrder.getC_Order_ID(), order);
        return order;
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private void processingOrders() {
        if (this.orders == null) {
            return;
        }
        this.orders.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            MOrder order = (MOrder)entry.getValue();
            order.setDocAction(this.getDocAction());
            if (!order.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + order.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + order.getDocumentInfo());
            }
            order.saveEx();
            ++this.created;
            this.addToMessage(order.getDocumentNo());
        });
    }
}

