/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_Role;
import org.compiere.model.I_AD_User;
import org.compiere.model.I_ASP_Level;
import org.compiere.model.MFieldCustom;
import org.compiere.model.MTabCustom;
import org.compiere.model.MWindowCustom;
import org.compiere.model.PO;
import org.spin.process.ASPCopyWindowFromAbstract;

public class ASPCopyWindowFrom
extends ASPCopyWindowFromAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        AtomicInteger counter = new AtomicInteger(0);
        this.getSelectionKeys().forEach(customWindowId -> {
            MWindowCustom fromCustomWindow = new MWindowCustom(this.getCtx(), (int)customWindowId, this.get_TrxName());
            MWindowCustom toCustomWindow = new MWindowCustom(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromCustomWindow, toCustomWindow);
            if (this.getTable_ID() == I_ASP_Level.Table_ID) {
                toCustomWindow.setASP_Level_ID(this.getRecord_ID());
            } else if (this.getTable_ID() == I_AD_Role.Table_ID) {
                toCustomWindow.setAD_Role_ID(this.getRecord_ID());
            } else if (this.getTable_ID() == I_AD_User.Table_ID) {
                toCustomWindow.setAD_User_ID(this.getRecord_ID());
            }
            toCustomWindow.saveEx();
            List<MTabCustom> fromTabList = fromCustomWindow.getTabs();
            List<MTabCustom> toTabList = toCustomWindow.getTabs();
            if (fromTabList != null && fromTabList.size() > 0) {
                toTabList.forEach(tab -> {
                    tab.setIsActive(false);
                    tab.setSeqNo(0);
                    tab.saveEx();
                });
                fromTabList.forEach(fromTab -> {
                    Optional<MTabCustom> maybeCustomTab = toTabList.stream().filter(toTab -> toTab.getAD_Tab_ID() == fromTab.getAD_Tab_ID()).findFirst();
                    if (maybeCustomTab.isPresent()) {
                        MTabCustom tabToOverwrite = maybeCustomTab.get();
                        tabToOverwrite.overwriteValuesFromCustomTab((MTabCustom)fromTab);
                        tabToOverwrite.saveEx();
                        counter.incrementAndGet();
                        List<MFieldCustom> fromFieldList = fromTab.getFields();
                        List<MFieldCustom> toFieldList = tabToOverwrite.getFields();
                        if (fromFieldList != null && fromFieldList.size() != 0) {
                            toFieldList.forEach(field -> {
                                field.setIsDisplayed(false);
                                field.saveEx();
                            });
                            fromFieldList.forEach(fromField -> {
                                Optional<MFieldCustom> maybeCustomField = toFieldList.stream().filter(toField -> toField.getAD_Field_ID() == fromField.getAD_Field_ID()).findFirst();
                                if (maybeCustomField.isPresent()) {
                                    MFieldCustom fieldToOverwrite = maybeCustomField.get();
                                    fieldToOverwrite.overwriteValuesFromCustomField((MFieldCustom)fromField);
                                    fieldToOverwrite.saveEx();
                                }
                            });
                        }
                    }
                });
            }
        });
        return "@Update@: " + counter.get();
    }
}

