/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_Role;
import org.compiere.model.I_AD_User;
import org.compiere.model.I_ASP_Level;
import org.compiere.model.MProcessCustom;
import org.compiere.model.MProcessParaCustom;
import org.compiere.model.PO;
import org.spin.process.ASPCopyProcessFromAbstract;

public class ASPCopyProcessFrom
extends ASPCopyProcessFromAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        AtomicInteger counter = new AtomicInteger(0);
        this.getSelectionKeys().forEach(customProcessId -> {
            MProcessCustom fromCustomProcess = new MProcessCustom(this.getCtx(), (int)customProcessId, this.get_TrxName());
            MProcessCustom toCustomProcess = new MProcessCustom(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromCustomProcess, toCustomProcess);
            if (this.getTable_ID() == I_ASP_Level.Table_ID) {
                toCustomProcess.setASP_Level_ID(this.getRecord_ID());
            } else if (this.getTable_ID() == I_AD_Role.Table_ID) {
                toCustomProcess.setAD_Role_ID(this.getRecord_ID());
            } else if (this.getTable_ID() == I_AD_User.Table_ID) {
                toCustomProcess.setAD_User_ID(this.getRecord_ID());
            }
            toCustomProcess.saveEx();
            List<MProcessParaCustom> fromParameterList = fromCustomProcess.getParameters();
            List<MProcessParaCustom> toParameterList = toCustomProcess.getParameters();
            if (fromParameterList != null && fromParameterList.size() != 0) {
                toParameterList.forEach(parameter -> {
                    parameter.setIsActive(false);
                    parameter.saveEx();
                });
                fromParameterList.forEach(fromParameter -> {
                    Optional<MProcessParaCustom> maybeCustomParameter = toParameterList.stream().filter(toParameter -> toParameter.getAD_Process_Para_ID() == fromParameter.getAD_Process_Para_ID()).findFirst();
                    if (maybeCustomParameter.isPresent()) {
                        MProcessParaCustom parameterToOverwrite = maybeCustomParameter.get();
                        parameterToOverwrite.overwriteValuesFromCustomParameter((MProcessParaCustom)fromParameter);
                        parameterToOverwrite.saveEx();
                        counter.incrementAndGet();
                    }
                });
            }
        });
        return "@Update@: " + counter.get();
    }
}

