/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MFieldCustom;
import org.compiere.model.MTabCustom;
import org.spin.process.ASPCopyFromTabAbstract;

public class ASPCopyFromTab
extends ASPCopyFromTabAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@AD_TabCustom_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        MTabCustom fromCustomTab = new MTabCustom(this.getCtx(), this.getTabCustomId(), this.get_TrxName());
        MTabCustom toCustomTab = new MTabCustom(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        List<MFieldCustom> fromFieldList = fromCustomTab.getFields();
        if (fromFieldList == null || fromFieldList.size() == 0) {
            return "@AD_FieldCustom_ID@ = 0";
        }
        toCustomTab.getFields().forEach(field -> {
            field.setIsDisplayed(false);
            field.saveEx();
        });
        List<MFieldCustom> toFieldList = toCustomTab.getFields();
        AtomicInteger counter = new AtomicInteger(0);
        fromFieldList.forEach(fromField -> {
            Optional<MFieldCustom> maybeCustomField = toFieldList.stream().filter(toField -> toField.getAD_Field().getAD_Column_ID() == fromField.getAD_Field().getAD_Column_ID()).findFirst();
            if (maybeCustomField.isPresent()) {
                MFieldCustom fieldToOverwrite = maybeCustomField.get();
                fieldToOverwrite.overwriteValuesFromCustomField((MFieldCustom)fromField);
                fieldToOverwrite.saveEx();
                counter.incrementAndGet();
            }
        });
        return "@Update@: " + counter.get();
    }
}

