/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAgreement;

public class OpenUpModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(OpenUpModelValidator.class);
    private int clientId = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
        }
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public int getAD_Client_ID() {
        return this.clientId;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    @Override
    public String docValidate(PO entity, int timing) {
        if (entity instanceof MInvoice && timing == 7) {
            log.fine("MInvoice [" + entity + "] TIMING_BEFORE_COMPLETE");
            MInvoice invoice = (MInvoice)entity;
            int financialAccountId = invoice.get_ValueAsInt("FM_Account_ID");
            if (financialAccountId <= 0) {
                return null;
            }
            MFMAccount account = new MFMAccount(invoice.getCtx(), financialAccountId, invoice.get_TrxName());
            MFMAgreement loan = (MFMAgreement)account.getFM_Agreement();
            if (loan == null) {
                return null;
            }
            if (loan.get_ValueAsInt("UY_ViaLoan_ID") != 0) {
                invoice.set_ValueOfColumn("UY_ViaLoan_ID", (Object)loan.get_ValueAsInt("UY_ViaLoan_ID"));
                invoice.saveEx();
            }
        }
        return null;
    }
}

