/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.model.X_HR_ShiftIncidence;

public class MHRShiftIncidence
extends X_HR_ShiftIncidence {
    private static final long serialVersionUID = 625050579283149689L;
    private static CCache<String, List<MHRShiftIncidence>> shiftIncidenceForDaysCache = new CCache("HR_ShiftIncidence", 1000);
    private static CCache<String, List<MHRShiftIncidence>> shiftIncidenceListCache = new CCache("HR_ShiftIncidence", 1000);

    public MHRShiftIncidence(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRShiftIncidence(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public boolean evaluateTime(Timestamp timestamp) {
        Timestamp timestamp2 = TimeUtil.getDayTime(this.getTimeFrom(), timestamp);
        if (this.isMandatoryRange()) {
            return TimeUtil.isValid(this.getTimeFrom(), this.getTimeTo(), timestamp2);
        }
        return TimeUtil.isValid(this.getTimeFrom(), timestamp2, timestamp2);
    }

    public boolean isFixedValue() {
        return this.getFixedQty() != null && !this.getFixedQty().equals(Env.ZERO) || this.getFixedAmt() != null && !this.getFixedAmt().equals(Env.ZERO);
    }

    public long getDurationInMillis(Timestamp timestamp) {
        if (!this.evaluateTime(timestamp)) {
            return -1L;
        }
        long l = 0L;
        Timestamp timestamp2 = TimeUtil.getDayTime(this.getTimeFrom(), timestamp);
        Timestamp timestamp3 = this.getBeginningTime();
        Timestamp timestamp4 = this.getTimeFrom();
        Timestamp timestamp5 = this.getTimeTo();
        if (timestamp5.before(timestamp4)) {
            timestamp5 = TimeUtil.getDayTime(TimeUtil.addDays(timestamp5, 1), timestamp5);
        }
        if (this.getEventType().equals("I")) {
            if (timestamp3 == null) {
                timestamp3 = timestamp4;
            }
            if (!TimeUtil.isValid(timestamp3, this.getTimeTo(), timestamp2)) {
                l = -1L;
            } else if (this.isAnticipatedRecord()) {
                l = timestamp5.getTime() - timestamp2.getTime();
            } else if (timestamp2.after(timestamp3)) {
                l = timestamp2.getTime() - timestamp3.getTime();
            }
        } else if (this.getEventType().equals("O")) {
            if (timestamp3 == null) {
                timestamp3 = timestamp4;
            }
            if (this.isAnticipatedRecord()) {
                timestamp3 = this.getTimeTo();
                if (timestamp2.before(timestamp4)) {
                    timestamp2 = timestamp4;
                }
                l = timestamp3.getTime() - timestamp2.getTime();
            } else if (timestamp2.after(timestamp3)) {
                if (timestamp2.after(timestamp5)) {
                    timestamp2 = timestamp5;
                }
                l = timestamp2.getTime() - timestamp3.getTime();
            }
        }
        return l;
    }

    public static List<MHRShiftIncidence> getShiftIncidenceList(Properties properties, int n, boolean bl) {
        String string = "IncidenceList|" + n;
        List<MHRShiftIncidence> list = shiftIncidenceListCache.get(string);
        if ((bl || list == null) && (list = new Query(properties, "HR_ShiftIncidence", "HR_WorkShift_ID = ?", null).setParameters(n).list()) != null) {
            shiftIncidenceListCache.put(string, list);
        }
        return list;
    }

    public static List<MHRShiftIncidence> getShiftIncidenceList(Properties properties, int n, String string, Timestamp timestamp) {
        String string2 = n + "|";
        if (timestamp == null || Util.isEmpty(string)) {
            return new ArrayList<MHRShiftIncidence>();
        }
        List<MHRShiftIncidence> list = shiftIncidenceForDaysCache.get(string2 + string + TimeUtil.getDayOfWeek(timestamp));
        if (list != null) {
            return list;
        }
        list = MHRShiftIncidence.getShiftIncidenceList(properties, n, false);
        String string3 = "I";
        String string4 = "O";
        String string5 = "A";
        String string6 = "L";
        if (list != null) {
            shiftIncidenceForDaysCache.put(string2 + string3 + 1, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string4 + 1, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string5 + 1, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string6 + 1, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string3 + 2, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string4 + 2, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string5 + 2, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string6 + 2, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string3 + 3, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string4 + 3, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string5 + 3, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string6 + 3, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string3 + 4, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string4 + 4, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string5 + 4, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string6 + 4, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string3 + 5, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string4 + 5, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string5 + 5, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string6 + 5, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string3 + 6, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string4 + 6, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string5 + 6, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string6 + 6, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string3 + 7, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string4 + 7, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string5 + 7, new ArrayList());
            shiftIncidenceForDaysCache.put(string2 + string6 + 7, new ArrayList());
            for (MHRShiftIncidence mHRShiftIncidence : list) {
                if (!(mHRShiftIncidence.isOnSunday() || mHRShiftIncidence.isOnMonday() || mHRShiftIncidence.isOnTuesday() || mHRShiftIncidence.isOnWednesday() || mHRShiftIncidence.isOnThursday() || mHRShiftIncidence.isOnFriday() || mHRShiftIncidence.isOnSaturday())) {
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 1).add(mHRShiftIncidence);
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 2).add(mHRShiftIncidence);
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 3).add(mHRShiftIncidence);
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 4).add(mHRShiftIncidence);
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 5).add(mHRShiftIncidence);
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 6).add(mHRShiftIncidence);
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 7).add(mHRShiftIncidence);
                    continue;
                }
                if (mHRShiftIncidence.isOnSunday()) {
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 1).add(mHRShiftIncidence);
                }
                if (mHRShiftIncidence.isOnMonday()) {
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 2).add(mHRShiftIncidence);
                }
                if (mHRShiftIncidence.isOnTuesday()) {
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 3).add(mHRShiftIncidence);
                }
                if (mHRShiftIncidence.isOnWednesday()) {
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 4).add(mHRShiftIncidence);
                }
                if (mHRShiftIncidence.isOnThursday()) {
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 5).add(mHRShiftIncidence);
                }
                if (mHRShiftIncidence.isOnFriday()) {
                    shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 6).add(mHRShiftIncidence);
                }
                if (!mHRShiftIncidence.isOnSaturday()) continue;
                shiftIncidenceForDaysCache.get(string2 + mHRShiftIncidence.getEventType() + 7).add(mHRShiftIncidence);
            }
        }
        if ((list = shiftIncidenceForDaysCache.get(string2 + string + TimeUtil.getDayOfWeek(timestamp))) == null) {
            return new ArrayList<MHRShiftIncidence>();
        }
        return list;
    }

    @Override
    public String toString() {
        return "MHRShiftIncidence [getBeginningTime()=" + this.getBeginningTime() + ", getDescription()=" + this.getDescription() + ", getEventType()=" + this.getEventType() + ", getHR_Concept_ID()=" + this.getHR_Concept_ID() + ", isOnFriday()=" + this.isOnFriday() + ", isOnMonday()=" + this.isOnMonday() + ", isOnSaturday()=" + this.isOnSaturday() + ", isOnSunday()=" + this.isOnSunday() + ", isOnThursday()=" + this.isOnThursday() + ", isOnTuesday()=" + this.isOnTuesday() + ", isOnWednesday()=" + this.isOnWednesday() + ", getTimeFrom()=" + this.getTimeFrom() + ", getTimeTo()=" + this.getTimeTo() + ", getTimeUnit()=" + this.getTimeUnit() + "]";
    }
}

