/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.model.MHRAttendanceBatch;
import org.spin.model.MHRShiftIncidence;
import org.spin.model.X_HR_Incidence;

public class MHRIncidence
extends X_HR_Incidence
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20180728L;
    public static final String DocBaseType_Standard = "TNI";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MHRIncidence(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRIncidence(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRIncidence(MHRAttendanceBatch mHRAttendanceBatch, MHRShiftIncidence mHRShiftIncidence, long l) {
        super(mHRAttendanceBatch.getCtx(), 0, mHRAttendanceBatch.get_TrxName());
        this.setHR_AttendanceBatch_ID(mHRAttendanceBatch.getHR_AttendanceBatch_ID());
        this.setDateDoc(mHRAttendanceBatch.getDateDoc());
        this.setServiceDate(mHRAttendanceBatch.getDateDoc());
        this.setC_BPartner_ID(mHRAttendanceBatch.getC_BPartner_ID());
        this.setHR_Employee_ID(mHRAttendanceBatch.getHR_Employee_ID());
        this.setHR_ShiftIncidence_ID(mHRShiftIncidence.getHR_ShiftIncidence_ID());
        this.setHR_Concept_ID(mHRShiftIncidence.getHR_Concept_ID());
        if (l == 0L || Util.isEmpty(mHRShiftIncidence.getTimeUnit())) {
            if (mHRShiftIncidence.getFixedQty() != null && !mHRShiftIncidence.getFixedQty().equals(Env.ZERO)) {
                this.setQty(mHRShiftIncidence.getFixedQty());
            }
            if (mHRShiftIncidence.getFixedAmt() != null && !mHRShiftIncidence.getFixedAmt().equals(Env.ZERO)) {
                this.setAmt(mHRShiftIncidence.getFixedAmt());
            }
        } else {
            double d = MHRIncidence.getTime(mHRShiftIncidence.getTimeUnit(), l);
            if (d == 0.0) {
                throw new AdempiereException("@TimeUnit@ @NotFound@");
            }
            this.setQty(new BigDecimal(d));
        }
    }

    public MHRIncidence(MHRAttendanceBatch mHRAttendanceBatch, MHRShiftIncidence mHRShiftIncidence, BigDecimal bigDecimal) {
        super(mHRAttendanceBatch.getCtx(), 0, mHRAttendanceBatch.get_TrxName());
        this.setHR_AttendanceBatch_ID(mHRAttendanceBatch.getHR_AttendanceBatch_ID());
        this.setDateDoc(mHRAttendanceBatch.getDateDoc());
        this.setServiceDate(mHRAttendanceBatch.getDateDoc());
        this.setC_BPartner_ID(mHRAttendanceBatch.getC_BPartner_ID());
        this.setHR_Employee_ID(mHRAttendanceBatch.getHR_Employee_ID());
        this.setHR_ShiftIncidence_ID(mHRShiftIncidence.getHR_ShiftIncidence_ID());
        this.setHR_Concept_ID(mHRShiftIncidence.getHR_Concept_ID());
        if (bigDecimal == null || bigDecimal.doubleValue() == 0.0 || Util.isEmpty(mHRShiftIncidence.getTimeUnit())) {
            if (mHRShiftIncidence.getFixedQty() != null && !mHRShiftIncidence.getFixedQty().equals(Env.ZERO)) {
                this.setQty(mHRShiftIncidence.getFixedQty());
            }
            if (mHRShiftIncidence.getFixedAmt() != null && !mHRShiftIncidence.getFixedAmt().equals(Env.ZERO)) {
                this.setAmt(mHRShiftIncidence.getFixedAmt());
            }
        } else {
            if (bigDecimal == null || bigDecimal.doubleValue() == 0.0) {
                throw new AdempiereException("@TimeUnit@ @NotFound@");
            }
            this.setQty(bigDecimal);
        }
    }

    public static double getTime(String string, long l) {
        if (Util.isEmpty(string)) {
            return 0.0;
        }
        double d = 0.0;
        if (string.equals("I")) {
            d = (double)l / 60000.0;
        } else if (string.equals("H")) {
            d = (double)l / 3600000.0;
        } else if (string.equals("D")) {
            d = (double)l / 8.64E7;
        }
        return d;
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    public void setC_DocType_ID() {
        String string = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID = ? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType = ?  AND IsActive = 'Y' ORDER BY AD_Org_ID, IsDefault DESC";
        int n = DB.getSQLValue(null, string, this.getAD_Client_ID(), DocBaseType_Standard);
        if (n <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", DocBaseType=" + DocBaseType_Standard);
        } else {
            this.log.fine("(APS) - TNI");
            this.setC_DocType_ID(n);
        }
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (bl && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID();
        }
        return super.beforeSave(bl);
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), mDocType.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String string;
        if (!this.m_justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (mDocType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (mDocType.isOverwriteSeqOnComplete()) {
            String string = null;
            int n = this.p_info.getColumnIndex("C_DocType_ID");
            if (n == -1) {
                n = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (n != -1) {
                string = DB.getDocumentNo(this.get_ValueAsInt(n), this.get_TrxName(), true);
            }
            if (string != null) {
                this.setDocumentNo(string);
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int customizeValidActions(String string, Object object, String string2, String string3, int n, String[] stringArray, String[] stringArray2, int n2) {
        if (n == Table_ID) {
            if (string.equals("DR") || string.equals("IP") || string.equals("IN")) {
                stringArray2[n2++] = "PR";
            } else if (string.equals("CO")) {
                stringArray2[n2++] = "RE";
                stringArray2[n2++] = "VO";
            }
        }
        return n2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MHRIncidence[").append(this.getSummary()).append("]");
        return stringBuffer.toString();
    }
}

