/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.MRule;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.Scriptlet;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRWorkGroup;
import org.eevolution.model.MHRWorkShift;
import org.eevolution.model.X_HR_Payroll;
import org.eevolution.model.X_HR_WorkShift;
import org.spin.model.MHRAttendanceRecord;
import org.spin.model.MHRIncidence;
import org.spin.model.MHRShiftIncidence;
import org.spin.model.MHRShiftSchedule;
import org.spin.model.X_HR_AttendanceBatch;
import org.spin.util.TNAUtil;

public class MHRAttendanceBatch
extends X_HR_AttendanceBatch
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20180728L;
    private List<MHRAttendanceRecord> attendanceRecordList = null;
    public static final String DocBaseType_Standard = "TNA";
    HashMap<String, Object> scriptCtx = new HashMap();
    private MHRShiftIncidence shiftIncidence;
    private MHRAttendanceRecord attendance;
    private MHRAttendanceRecord firstAttendance;
    private MHRAttendanceRecord lastAttendance;
    private MHRIncidence incidence;
    private MHREmployee employee;
    private MHRWorkShift workShift;
    private static StringBuffer scriptImport = new StringBuffer(" import org.eevolution.model.*;" + Env.NL + "import org.compiere.model.*;" + Env.NL + "import org.adempiere.model.*;" + Env.NL + "import org.spin.model.*;" + Env.NL + "import org.compiere.util.*;" + Env.NL + "import org.spin.util.*;" + Env.NL + "import java.util.*;" + Env.NL + "import java.math.*;" + Env.NL + "import java.sql.*;");
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MHRAttendanceBatch(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRAttendanceBatch(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), mDocType.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = this.processShiftIncidence();
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public void setC_DocType_ID() {
        String string = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID = ? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType = ?  AND IsActive = 'Y' ORDER BY AD_Org_ID, IsDefault DESC";
        int n = DB.getSQLValue(null, string, this.getAD_Client_ID(), DocBaseType_Standard);
        if (n <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", DocBaseType=" + DocBaseType_Standard);
        } else {
            this.log.fine("(APS) - TNA");
            this.setC_DocType_ID(n);
        }
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (bl && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID();
        }
        return super.beforeSave(bl);
    }

    private BigDecimal processAttendance() {
        List<MHRShiftIncidence> list = MHRShiftIncidence.getShiftIncidenceList(this.getCtx(), this.workShift.getHR_WorkShift_ID(), "A", this.getDateDoc());
        BigDecimal bigDecimal = Env.ZERO;
        for (MHRShiftIncidence mHRShiftIncidence : list) {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            for (MHRAttendanceRecord mHRAttendanceRecord : this.getLines(false)) {
                if (l2 == 0L) {
                    l2 = mHRAttendanceRecord.getAttendanceTime().getTime();
                } else {
                    l3 = mHRAttendanceRecord.getAttendanceTime().getTime();
                }
                if (l2 == 0L || l3 == 0L) continue;
                l += l3 - l2;
                l3 = 0L;
                l2 = 0L;
            }
            if (l == 0L) continue;
            MHRIncidence mHRIncidence = new MHRIncidence(this, mHRShiftIncidence, l);
            if (this.get_ValueAsInt("S_Contract_ID") > 0) {
                mHRIncidence.set_ValueOfColumn("S_Contract_ID", (Object)this.get_ValueAsInt("S_Contract_ID"));
            }
            if (this.get_ValueAsInt("S_ContractLine_ID") > 0) {
                mHRIncidence.set_ValueOfColumn("S_ContractLine_ID", (Object)this.get_ValueAsInt("S_ContractLine_ID"));
            }
            this.shiftIncidence = mHRShiftIncidence;
            this.incidence = mHRIncidence;
            if (mHRShiftIncidence.getAD_Rule_ID() > 0) {
                this.processRule(mHRIncidence);
            }
            mHRIncidence.saveEx();
            bigDecimal = bigDecimal.add(new BigDecimal(MHRIncidence.getTime("H", l)));
        }
        return bigDecimal;
    }

    private void processLeave(BigDecimal bigDecimal) {
        this.scriptCtx.remove("_LeaveDurationInMillis");
        this.scriptCtx.remove("_LeaveHours");
        this.scriptCtx.remove("_LeaveMinutes");
        this.scriptCtx.remove("_AttendanceDurationInMillis");
        this.scriptCtx.remove("_AttendanceHours");
        this.scriptCtx.remove("_AttendanceMinutes");
        List<MHRShiftIncidence> list = MHRShiftIncidence.getShiftIncidenceList(this.getCtx(), this.workShift.getHR_WorkShift_ID(), "L", this.getDateDoc());
        BigDecimal bigDecimal2 = this.workShift.getNoOfHours();
        if (bigDecimal2 == null) {
            return;
        }
        BigDecimal bigDecimal3 = bigDecimal2.subtract(bigDecimal);
        if (bigDecimal3.signum() <= 0) {
            return;
        }
        long l = bigDecimal3.longValue() * 3600000L;
        long l2 = bigDecimal.longValue() * 3600000L;
        this.scriptCtx.put("_LeaveDurationInMillis", l);
        this.scriptCtx.put("_LeaveHours", bigDecimal3.doubleValue());
        this.scriptCtx.put("_LeaveMinutes", TimeUtil.getMinutesFromDuration(l));
        this.scriptCtx.put("_AttendanceDurationInMillis", l2);
        this.scriptCtx.put("_AttendanceHours", bigDecimal.doubleValue());
        this.scriptCtx.put("_AttendanceMinutes", TimeUtil.getMinutesFromDuration(l2));
        list.stream().forEach(mHRShiftIncidence -> {
            MHRIncidence mHRIncidence = new MHRIncidence(this, (MHRShiftIncidence)mHRShiftIncidence, l);
            if (this.get_ValueAsInt("S_Contract_ID") > 0) {
                mHRIncidence.set_ValueOfColumn("S_Contract_ID", (Object)this.get_ValueAsInt("S_Contract_ID"));
            }
            if (this.get_ValueAsInt("S_ContractLine_ID") > 0) {
                mHRIncidence.set_ValueOfColumn("S_ContractLine_ID", (Object)this.get_ValueAsInt("S_ContractLine_ID"));
            }
            this.shiftIncidence = mHRShiftIncidence;
            this.incidence = mHRIncidence;
            if (mHRShiftIncidence.getAD_Rule_ID() > 0) {
                this.processRule(mHRIncidence);
            }
            mHRIncidence.saveEx();
        });
    }

    private void loadBatchVariables() {
        Serializable serializable;
        MBPartner mBPartner = (MBPartner)this.getC_BPartner();
        List<MHRAttendanceRecord> list = this.getLines(false);
        if (!this.isLeave()) {
            this.firstAttendance = (MHRAttendanceRecord)list.stream().findFirst().get();
            this.lastAttendance = list.get(list.size() - 1);
        }
        this.setHR_Employee_ID(this.employee.getHR_Employee_ID());
        String string = null;
        if (this.employee.getHR_Payroll_ID() != 0) {
            serializable = MHRPayroll.getById(this.getCtx(), this.employee.getHR_Payroll_ID(), this.get_TrxName());
            string = ((X_HR_Payroll)serializable).getValue();
        }
        this.workShift = MHRWorkShift.getById(this.getCtx(), this.getHR_WorkShift_ID());
        this.scriptCtx.put("_HR_FirstAttendanceRecord", this.firstAttendance);
        this.scriptCtx.put("_HR_LastAttendanceRecord", this.lastAttendance);
        if (this.firstAttendance != null) {
            this.scriptCtx.put("_FirstAttendanceTime", this.firstAttendance.getAttendanceTime());
        }
        if (this.lastAttendance != null) {
            this.scriptCtx.put("_LastAttendanceTime", this.lastAttendance.getAttendanceTime());
        }
        this.scriptCtx.put("_DateStart", this.employee.getStartDate());
        this.scriptCtx.put("_DateEnd", this.employee.getEndDate());
        this.scriptCtx.put("_C_BPartner_ID", mBPartner.getC_BPartner_ID());
        this.scriptCtx.put("_HR_Employee_ID", this.employee.getHR_Employee_ID());
        this.scriptCtx.put("_C_BPartner", mBPartner);
        this.scriptCtx.put("_HR_Employee", this.employee);
        this.scriptCtx.put("_HR_Employee_Payroll_Value", string);
        this.scriptCtx.put("_DateDoc", this.getDateDoc());
        this.scriptCtx.put("_HR_AttendanceBatch_ID", this.getHR_AttendanceBatch_ID());
        this.scriptCtx.put("_HR_WorkShift_ID", this.getHR_WorkShift_ID());
        this.scriptCtx.put("_HR_ShiftSchedule_ID", this.getHR_ShiftSchedule_ID());
        this.scriptCtx.put("process", this);
        this.scriptCtx.put("_HR_WorkShift", this.workShift);
        this.scriptCtx.put("_ShiftFromTime", this.workShift.getShiftFromTime());
        this.scriptCtx.put("_ShiftToTime", this.workShift.getShiftToTime());
        this.scriptCtx.put("_BreakStartTime", this.workShift.getBreakStartTime());
        this.scriptCtx.put("_BreakEndTime", this.workShift.getBreakEndTime());
        serializable = this.workShift.getBreakHoursNo();
        BigDecimal bigDecimal = this.workShift.getNoOfHours();
        if (serializable == null) {
            serializable = Env.ZERO;
        }
        if (bigDecimal == null) {
            bigDecimal = Env.ZERO;
        }
        this.scriptCtx.put("_BreakHoursNo", ((BigDecimal)serializable).doubleValue());
        this.scriptCtx.put("_NoOfHours", bigDecimal.doubleValue());
        this.scriptCtx.put("_ExpectedShiftFromTime", TimeUtil.getDayTime(this.getDateDoc(), this.workShift.getShiftFromTime()));
        this.scriptCtx.put("_ExpectedShiftToTime", TimeUtil.getDayTime(this.getDateDoc(), this.workShift.getShiftToTime()));
    }

    private void processIncidence(BigDecimal bigDecimal) {
        MHRWorkShift mHRWorkShift = MHRWorkShift.getById(this.getCtx(), this.getHR_WorkShift_ID());
        if (mHRWorkShift.isVariableEntrance()) {
            if (bigDecimal != null && bigDecimal.doubleValue() >= mHRWorkShift.getNoOfHours().doubleValue()) {
                int n = (int)TimeUtil.getHoursBetween(TimeUtil.getDay(this.firstAttendance.getAttendanceTime()), this.firstAttendance.getAttendanceTime());
                Timestamp timestamp = TimeUtil.addDuration(this.firstAttendance.getAttendanceTime(), "h", mHRWorkShift.getNoOfHours().add(mHRWorkShift.getBreakHoursNo()).add(new BigDecimal(n)));
                MHRShiftIncidence.getShiftIncidenceList(this.getCtx(), mHRWorkShift.getHR_WorkShift_ID(), "O", this.getDateDoc()).stream().filter(mHRShiftIncidence -> mHRShiftIncidence.evaluateTime(this.lastAttendance.getAttendanceTime())).forEach(mHRShiftIncidence -> {
                    mHRShiftIncidence.setBeginningTime(timestamp);
                    long l = mHRShiftIncidence.getDurationInMillis(this.lastAttendance.getAttendanceTime());
                    if (l > 0L || l == 0L && mHRShiftIncidence.isFixedValue()) {
                        MHRIncidence mHRIncidence = new MHRIncidence(this, (MHRShiftIncidence)mHRShiftIncidence, l);
                        if (this.get_ValueAsInt("S_Contract_ID") > 0) {
                            mHRIncidence.set_ValueOfColumn("S_Contract_ID", (Object)this.get_ValueAsInt("S_Contract_ID"));
                        }
                        if (this.get_ValueAsInt("S_ContractLine_ID") > 0) {
                            mHRIncidence.set_ValueOfColumn("S_ContractLine_ID", (Object)this.get_ValueAsInt("S_ContractLine_ID"));
                        }
                        this.shiftIncidence = mHRShiftIncidence;
                        this.incidence = mHRIncidence;
                        if (mHRShiftIncidence.getAD_Rule_ID() > 0) {
                            this.processRule(mHRIncidence);
                        }
                        mHRIncidence.saveEx();
                    }
                });
            }
        } else {
            boolean bl = true;
            for (MHRAttendanceRecord mHRAttendanceRecord : this.getLines(false)) {
                List<MHRShiftIncidence> list = MHRShiftIncidence.getShiftIncidenceList(this.getCtx(), mHRWorkShift.getHR_WorkShift_ID(), bl ? "I" : "O", this.getDateDoc());
                list.stream().filter(mHRShiftIncidence -> mHRShiftIncidence.evaluateTime(mHRAttendanceRecord.getAttendanceTime())).forEach(mHRShiftIncidence -> {
                    long l = mHRShiftIncidence.getDurationInMillis(mHRAttendanceRecord.getAttendanceTime());
                    if (l > 0L || l == 0L && mHRShiftIncidence.isFixedValue() || mHRShiftIncidence.isVariableCalculation()) {
                        MHRIncidence mHRIncidence = new MHRIncidence(this, (MHRShiftIncidence)mHRShiftIncidence, l);
                        if (this.get_ValueAsInt("S_Contract_ID") > 0) {
                            mHRIncidence.set_ValueOfColumn("S_Contract_ID", (Object)this.get_ValueAsInt("S_Contract_ID"));
                        }
                        if (this.get_ValueAsInt("S_ContractLine_ID") > 0) {
                            mHRIncidence.set_ValueOfColumn("S_ContractLine_ID", (Object)this.get_ValueAsInt("S_ContractLine_ID"));
                        }
                        this.shiftIncidence = mHRShiftIncidence;
                        this.attendance = mHRAttendanceRecord;
                        this.incidence = mHRIncidence;
                        if (mHRShiftIncidence.getAD_Rule_ID() > 0) {
                            this.processRule(mHRIncidence);
                        }
                        mHRIncidence.saveEx();
                    }
                });
                bl = !bl;
            }
        }
    }

    private void processRule(MHRIncidence mHRIncidence) {
        this.scriptCtx.remove("_AttendanceTime");
        this.scriptCtx.remove("_HR_AttendanceRecord_ID");
        this.scriptCtx.remove("_HR_AttendanceRecord");
        this.scriptCtx.put("_HR_Concept_ID", this.shiftIncidence.getHR_Concept_ID());
        this.scriptCtx.put("_HR_ShiftIncidence_ID", this.shiftIncidence.getHR_ShiftIncidence_ID());
        this.scriptCtx.put("_HR_ShiftIncidence", this.shiftIncidence);
        this.scriptCtx.put("_HR_Concept", MHRConcept.getById(this.getCtx(), this.shiftIncidence.getHR_Concept_ID(), this.get_TrxName()));
        this.scriptCtx.put("_EventType", this.shiftIncidence.getEventType());
        this.scriptCtx.put("_TimeFrom", this.shiftIncidence.getTimeFrom());
        this.scriptCtx.put("_TimeTo", this.shiftIncidence.getTimeTo());
        this.scriptCtx.put("_BeginningTime", this.shiftIncidence.getBeginningTime());
        this.scriptCtx.put("_TimeUnit", this.shiftIncidence.getTimeUnit());
        this.scriptCtx.put("_DefaultAmt", this.shiftIncidence.getDefaultAmt());
        this.scriptCtx.put("_DefaultQty", this.shiftIncidence.getDefaultQty());
        this.scriptCtx.put("_FixedAmt", this.shiftIncidence.getFixedAmt());
        this.scriptCtx.put("_FixedQty", this.shiftIncidence.getFixedQty());
        if (this.attendance != null) {
            this.scriptCtx.put("_AttendanceTime", this.attendance.getAttendanceTime());
            this.scriptCtx.put("_HR_AttendanceRecord_ID", this.attendance.getHR_AttendanceRecord_ID());
            this.scriptCtx.put("_HR_AttendanceRecord", this.attendance);
        }
        MRule mRule = MRule.get(this.getCtx(), this.shiftIncidence.getAD_Rule_ID());
        try {
            String string;
            Scriptlet scriptlet;
            Exception exception;
            if (mRule == null) {
                this.log.log(Level.WARNING, " @AD_Rule_ID@ @NotFound@");
            }
            if (!mRule.getEventType().equals("H") || !mRule.getRuleType().equals("S")) {
                this.log.log(Level.WARNING, " must be of type JSR 223 and event human resource");
            }
            String string2 = "";
            String string3 = null;
            double d = 0.0;
            if (mRule.getScript() != null) {
                string2 = mRule.getScript().trim().replaceAll("\\bget", "process.get").replaceAll("\\bset", "process.set").replace(".process.get", ".get").replace(".process.set", ".set");
            }
            if ((exception = (scriptlet = new Scriptlet("result", string = scriptImport.toString() + Env.NL + "double result = 0;" + Env.NL + "String description = null;" + Env.NL + string2, this.scriptCtx)).execute()) != null) {
                throw exception;
            }
            d = (Double)scriptlet.getResult(false);
            string3 = (String)scriptlet.getDescription();
            if (!Util.isEmpty(string3)) {
                mHRIncidence.setDescription(string3);
            }
            if (d != 0.0) {
                mHRIncidence.setQty(new BigDecimal(d));
            }
        }
        catch (Exception exception) {
            throw new AdempiereException("@HR_Employee_ID@ : " + this.employee.getC_BPartner().getValue() + " " + this.employee.getC_BPartner().getName() + " \n @HR_WorkShift_ID@ " + this.workShift.getValue() + " -> " + this.workShift.getName() + " \n @AD_Rule_ID@=" + mRule.getValue() + "\n  @Script@: " + mRule.getScript() + " \n @Error@" + Env.NL + exception.getLocalizedMessage());
        }
    }

    public Timestamp getAttendanceTime() {
        return this.attendance.getAttendanceTime();
    }

    public double getIncidenceAmt() {
        if (this.incidence.getAmt() == null) {
            return 0.0;
        }
        return this.incidence.getAmt().doubleValue();
    }

    public double getIncidenceQty() {
        if (this.incidence.getQty() == null) {
            return 0.0;
        }
        return this.incidence.getQty().doubleValue();
    }

    public double getShiftIncidenceFixedQty() {
        if (this.shiftIncidence.getFixedQty() == null) {
            return 0.0;
        }
        return this.shiftIncidence.getFixedQty().doubleValue();
    }

    public double getShiftIncidenceFixedAmt() {
        if (this.shiftIncidence.getFixedAmt() == null) {
            return 0.0;
        }
        return this.shiftIncidence.getFixedAmt().doubleValue();
    }

    public long getAttendanceDurationInMillis() {
        return this.shiftIncidence.getDurationInMillis(this.attendance.getAttendanceTime());
    }

    public double getAttendanceTimeQty() {
        return MHRIncidence.getTime(this.shiftIncidence.getTimeUnit(), this.getAttendanceDurationInMillis());
    }

    public void setIncidenceQty(double d) {
        this.incidence.setQty(new BigDecimal(d));
    }

    public void setIncidenceAmt(double d) {
        this.incidence.setAmt(new BigDecimal(d));
    }

    public double getIncidenceSum(String string, String string2, Timestamp timestamp, Timestamp timestamp2) {
        return TNAUtil.getIncidenceSum(this.getCtx(), string, string2, this.getC_BPartner_ID(), timestamp, timestamp2, this.get_TrxName());
    }

    public double getIncidenceSum(String string, Timestamp timestamp, Timestamp timestamp2) {
        return TNAUtil.getIncidenceSum(this.getCtx(), string, null, this.getC_BPartner_ID(), timestamp, timestamp2, this.get_TrxName());
    }

    public double getLeaveHoursBetween(String string, Timestamp timestamp, Timestamp timestamp2, boolean bl) {
        return TNAUtil.getLeaveHoursBetween(this.getCtx(), this.getC_BPartner_ID(), string, timestamp, timestamp2, bl, this.get_TrxName());
    }

    public int getLeaveMinutesBetween(String string, Timestamp timestamp, Timestamp timestamp2, boolean bl) {
        return TNAUtil.getLeaveMinutesBetween(this.getCtx(), this.getC_BPartner_ID(), string, timestamp, timestamp2, bl, this.get_TrxName());
    }

    public int getLeaveDaysBetween(String string, Timestamp timestamp, Timestamp timestamp2, boolean bl) {
        return TNAUtil.getLeaveDaysBetween(this.getCtx(), this.getC_BPartner_ID(), string, timestamp, timestamp2, bl, this.get_TrxName());
    }

    private String processShiftIncidence() {
        Serializable serializable;
        this.validateEmployee();
        this.validateWorkShift();
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getLines(false).size();
        if (n % 2 != 0) {
            stringBuffer.append("@TNA.AttendanceNotPair@");
        }
        this.setIsLeave(n == 0);
        this.saveEx();
        if (!this.isLeave() && ((X_HR_WorkShift)(serializable = MHRWorkShift.getById(this.getCtx(), this.getHR_WorkShift_ID()))).getMinAttendanceRequire() > 0 && n < ((X_HR_WorkShift)serializable).getMinAttendanceRequire()) {
            stringBuffer.append("@MinAttendanceRequire@");
        }
        this.deleteMovements();
        this.loadBatchVariables();
        if (this.isLeave()) {
            this.processLeave(Env.ZERO);
        } else {
            serializable = this.processAttendance();
            this.processLeave((BigDecimal)serializable);
            this.processIncidence((BigDecimal)serializable);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    private void validateWorkShift() {
        MHRWorkShift mHRWorkShift;
        if (this.getHR_WorkShift_ID() > 0) {
            return;
        }
        MHREmployee mHREmployee = MHREmployee.getById(this.getCtx(), this.getHR_Employee_ID());
        int n = 0;
        int n2 = 0;
        if (mHREmployee.getHR_WorkGroup_ID() > 0) {
            MHRWorkGroup mHRWorkGroup = MHRWorkGroup.getById(this.getCtx(), mHREmployee.getHR_WorkGroup_ID(), this.get_TrxName());
            if (mHRWorkGroup.isShiftAllocation()) {
                MHRWorkShift mHRWorkShift2;
                n = mHRWorkGroup.getHR_WorkShift_ID();
                if (n == 0 && mHRWorkGroup.getHR_ShiftGroup_ID() > 0 && (mHRWorkShift2 = MHRWorkShift.getDefaultFromGroup(this.getCtx(), mHRWorkGroup.getHR_ShiftGroup_ID(), this.get_TrxName())) != null) {
                    n = mHRWorkShift2.getHR_WorkShift_ID();
                }
            } else {
                MHRShiftSchedule mHRShiftSchedule = MHRShiftSchedule.getScheduleFromWorkGroup(this.getCtx(), mHRWorkGroup.getHR_WorkGroup_ID(), this.getDateDoc(), this.get_TableName());
                if (mHRShiftSchedule != null) {
                    n = mHRShiftSchedule.getHR_WorkShift_ID();
                    n2 = mHRShiftSchedule.getHR_ShiftSchedule_ID();
                }
            }
        } else if (mHREmployee.getHR_ShiftGroup_ID() > 0 && (mHRWorkShift = MHRWorkShift.getDefaultFromGroup(this.getCtx(), mHREmployee.getHR_ShiftGroup_ID(), this.get_TrxName())) != null) {
            n = mHRWorkShift.getHR_WorkShift_ID();
        }
        if (n == 0) {
            throw new AdempiereException("@HR_WorkShift_ID@ @NotFound@");
        }
        this.setHR_WorkShift_ID(n);
        if (n2 > 0) {
            this.setHR_ShiftSchedule_ID(n2);
        }
    }

    private void validateEmployee() {
        MBPartner mBPartner = (MBPartner)this.getC_BPartner();
        this.employee = this.getHR_Employee_ID() > 0 ? MHREmployee.getById(this.getCtx(), this.getHR_Employee_ID()) : MHREmployee.getActiveEmployee(this.getCtx(), mBPartner.getC_BPartner_ID(), this.get_TrxName());
        if (this.employee == null) {
            throw new AdempiereException("@HR_Employee_ID@ @NotFound@: " + mBPartner.getValue() + " - " + mBPartner.getName());
        }
        this.setHR_Employee_ID(this.employee.getHR_Employee_ID());
        this.saveEx();
    }

    private void deleteMovements() {
        int n = DB.executeUpdateEx("DELETE FROM HR_Incidence WHERE IsManual = 'N' AND HR_AttendanceBatch_ID = " + this.getHR_AttendanceBatch_ID(), this.get_TrxName());
        this.log.info("Incidences Deleted = " + n);
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String string;
        if (!this.m_justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (mDocType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (mDocType.isOverwriteSeqOnComplete()) {
            String string = null;
            int n = this.p_info.getColumnIndex("C_DocType_ID");
            if (n == -1) {
                n = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (n != -1) {
                string = DB.getDocumentNo(this.get_ValueAsInt(n), this.get_TrxName(), true);
            }
            if (string != null) {
                this.setDocumentNo(string);
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public void setProcessed(boolean bl) {
        super.setProcessed(bl);
        for (MHRAttendanceRecord mHRAttendanceRecord : this.getLines(true)) {
            mHRAttendanceRecord.setProcessed(bl);
            mHRAttendanceRecord.saveEx();
        }
    }

    public List<MHRAttendanceRecord> getLines(boolean bl) {
        if (this.attendanceRecordList != null && !bl) {
            this.attendanceRecordList.stream().filter(mHRAttendanceRecord -> mHRAttendanceRecord != null).forEach(mHRAttendanceRecord -> mHRAttendanceRecord.set_TrxName(this.get_TrxName()));
            return this.attendanceRecordList;
        }
        return this.getLines(null, null);
    }

    public List<MHRAttendanceRecord> getLines(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("HR_AttendanceBatch_ID = ? ");
        if (!Util.isEmpty(string, true)) {
            stringBuffer.append(string);
        }
        if (Util.isEmpty(string2, true)) {
            string2 = "SeqNo";
        }
        this.attendanceRecordList = new Query(this.getCtx(), "HR_AttendanceRecord", stringBuffer.toString(), this.get_TrxName()).setParameters(this.getHR_AttendanceBatch_ID()).setOrderBy(string2).list();
        return this.attendanceRecordList;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int customizeValidActions(String string, Object object, String string2, String string3, int n, String[] stringArray, String[] stringArray2, int n2) {
        if (n == Table_ID) {
            if (string.equals("DR") || string.equals("IP") || string.equals("IN")) {
                stringArray2[n2++] = "PR";
            } else if (string.equals("CO")) {
                stringArray2[n2++] = "RE";
                stringArray2[n2++] = "VO";
            }
        }
        return n2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MHRAttendanceBatch[").append(this.getSummary()).append("]");
        return stringBuffer.toString();
    }
}

