/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.spin.model.MFMAccount;
import org.spin.model.X_FM_AmortizationSummary;

public class MFMAmortizationSummary
extends X_FM_AmortizationSummary {
    private static final long serialVersionUID = 1L;

    public MFMAmortizationSummary(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MFMAmortizationSummary(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MFMAmortizationSummary setCurrentInterest(Properties properties, int n, int n2, Timestamp timestamp, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, String string) {
        MFMAmortizationSummary mFMAmortizationSummary = MFMAmortizationSummary.getAmortizationSummaryFromAccountAndDate(properties, n, n2, timestamp, string);
        MFMAccount mFMAccount = MFMAccount.getById(properties, n);
        int n3 = MCurrency.getStdPrecision(properties, mFMAccount.getC_Currency_ID());
        mFMAmortizationSummary.setCurrentCapitalAmt(bigDecimal.setScale(n3, 4));
        mFMAmortizationSummary.setCurrentInterestAmt(bigDecimal2.setScale(n3, 4));
        mFMAmortizationSummary.setCurrentTaxAmt(bigDecimal3.setScale(n3, 4));
        mFMAmortizationSummary.saveEx();
        return mFMAmortizationSummary;
    }

    public static MFMAmortizationSummary setCurrentDunning(Properties properties, int n, int n2, Timestamp timestamp, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, String string) {
        MFMAmortizationSummary mFMAmortizationSummary = MFMAmortizationSummary.getAmortizationSummaryFromAccountAndDate(properties, n, n2, timestamp, string);
        MFMAccount mFMAccount = MFMAccount.getById(properties, n);
        int n3 = MCurrency.getStdPrecision(properties, mFMAccount.getC_Currency_ID());
        mFMAmortizationSummary.setCurrentCapitalAmt(bigDecimal.setScale(n3, 4));
        mFMAmortizationSummary.setCurrentDunningAmt(bigDecimal2.setScale(n3, 4));
        mFMAmortizationSummary.setCurrentDunningTaxAmt(bigDecimal3.setScale(n3, 4));
        mFMAmortizationSummary.saveEx();
        return mFMAmortizationSummary;
    }

    private static MFMAmortizationSummary getAmortizationSummaryFromAccountAndDate(Properties properties, int n, int n2, Timestamp timestamp, String string) {
        timestamp = TimeUtil.getDay(timestamp);
        MFMAmortizationSummary mFMAmortizationSummary = (MFMAmortizationSummary)new Query(properties, "FM_AmortizationSummary", "FM_Account_ID = ? AND FM_Amortization_ID = ? AND DateDoc = ?", string).setParameters(n, n2, timestamp).setOnlyActiveRecords(true).setClient_ID().first();
        if (mFMAmortizationSummary == null || mFMAmortizationSummary.getFM_AmortizationSummary_ID() == 0) {
            mFMAmortizationSummary = new MFMAmortizationSummary(properties, 0, string);
            mFMAmortizationSummary.setDateDoc(timestamp);
            mFMAmortizationSummary.setFM_Account_ID(n);
            mFMAmortizationSummary.setFM_Amortization_ID(n2);
        }
        return mFMAmortizationSummary;
    }

    @Override
    public BigDecimal getCurrentCapitalAmt() {
        if (super.getCurrentCapitalAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentCapitalAmt();
    }

    @Override
    public BigDecimal getCurrentInterestAmt() {
        if (super.getCurrentInterestAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentInterestAmt();
    }

    @Override
    public BigDecimal getCurrentDunningAmt() {
        if (super.getCurrentDunningAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentDunningAmt();
    }

    @Override
    public BigDecimal getCurrentDunningTaxAmt() {
        if (super.getCurrentDunningTaxAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentDunningTaxAmt();
    }

    @Override
    public BigDecimal getCurrentTaxAmt() {
        if (super.getCurrentTaxAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentTaxAmt();
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        this.setCurrentFeeAmt(this.getCurrentCapitalAmt().add(this.getCurrentInterestAmt()).add(this.getCurrentTaxAmt()).add(this.getCurrentDunningAmt()).add(this.getCurrentDunningTaxAmt()));
        return super.beforeSave(bl);
    }

    @Override
    public String toString() {
        return "MFMAmortizationSummary [getCurrentDunningAmt()=" + this.getCurrentDunningAmt() + ", getCurrentDunningTaxAmt()=" + this.getCurrentDunningTaxAmt() + ", getCurrentFeeAmt()=" + this.getCurrentFeeAmt() + ", getCurrentInterestAmt()=" + this.getCurrentInterestAmt() + ", getCurrentTaxAmt()=" + this.getCurrentTaxAmt() + ", getDateDoc()=" + this.getDateDoc() + ", getFM_Account_ID()=" + this.getFM_Account_ID() + "]";
    }
}

