/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MFMAccount;
import org.spin.model.X_FM_Amortization;
import org.spin.model.X_I_FM_Agreement;

public class MFMAmortization
extends X_FM_Amortization {
    private static final long serialVersionUID = 1L;

    public MFMAmortization(Properties ctx, int FM_Amortization_ID, String trxName) {
        super(ctx, FM_Amortization_ID, trxName);
    }

    public MFMAmortization(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MFMAmortization(X_I_FM_Agreement agreementImport) {
        super(agreementImport.getCtx(), agreementImport.get_ValueAsInt("FM_Amortization_ID"), agreementImport.get_TrxName());
        this.setPeriodNo(agreementImport.get_ValueAsInt("PeriodNo"));
        if (agreementImport.get_Value("DueDate") != null) {
            this.setDueDate((Timestamp)agreementImport.get_Value("DueDate"));
        }
        if (agreementImport.get_Value("ValidFrom") != null) {
            this.setStartDate((Timestamp)agreementImport.get_Value("ValidFrom"));
        } else {
            this.setStartDate((Timestamp)agreementImport.get_Value("DateDoc"));
        }
        if (agreementImport.get_Value("EndDate") != null) {
            this.setEndDate((Timestamp)agreementImport.get_Value("EndDate"));
        } else {
            this.setEndDate((Timestamp)agreementImport.get_Value("DateDoc"));
        }
        if (agreementImport.get_Value("CapitalAmt") != null) {
            this.setCapitalAmt((BigDecimal)agreementImport.get_Value("CapitalAmt"));
        }
        if (agreementImport.get_Value("InterestAmt") != null) {
            this.setInterestAmt((BigDecimal)agreementImport.get_Value("InterestAmt"));
        }
        if (agreementImport.get_Value("TaxAmt") != null) {
            this.setTaxAmt((BigDecimal)agreementImport.get_Value("TaxAmt"));
        }
        this.setFM_Account_ID(agreementImport.getFM_Account_ID());
        if (agreementImport.get_Value("IsPaid") != null) {
            this.setIsPaid(agreementImport.get_ValueAsBoolean("IsPaid"));
        }
    }

    public static int deleteForAccount(MFMAccount account) {
        return DB.executeUpdate("DELETE FROM FM_Amortization WHERE FM_Account_ID = ? AND IsPaid = 'N'", account.getFM_Account_ID(), account.get_TrxName());
    }

    public static boolean createAmortization(Properties ctx, BigDecimal CapitalAmt, String Description, Timestamp DueDate, Timestamp EndDate, int FM_Account_ID, BigDecimal InterestAmt, int PeriodNo, Timestamp StartDate, BigDecimal TaxAmt, String trxName) {
        MFMAmortization amortization = new MFMAmortization(ctx, 0, trxName);
        amortization.setCapitalAmt(CapitalAmt);
        amortization.setDescription(Description);
        amortization.setDueDate(DueDate);
        amortization.setEndDate(EndDate);
        amortization.setFM_Account_ID(FM_Account_ID);
        amortization.setInterestAmt(InterestAmt);
        amortization.setPeriodNo(PeriodNo);
        amortization.setStartDate(StartDate);
        amortization.setTaxAmt(TaxAmt);
        return amortization.save(trxName);
    }

    public static boolean checkAccount(MFMAccount account) {
        return new Query(account.getCtx(), "FM_Amortization", "FM_Account_ID = ? AND IsPaid = 'Y'", account.get_TrxName()).setParameters(account.getFM_Account_ID()).match();
    }

    public static List<MFMAmortization> getFromAccount(int financialAccountId, String trxName) {
        return new Query(Env.getCtx(), "FM_Amortization", "FM_Account_ID = ?", trxName).setParameters(financialAccountId).list();
    }

    public static List<MFMAmortization> getOpenFromAccount(int financialAccountId, String trxName) {
        return new Query(Env.getCtx(), "FM_Amortization", "FM_Account_ID = ? AND IsInvoiced = 'N' AND IsPaid = 'N'", trxName).setParameters(financialAccountId).list();
    }

    public static MFMAmortization getLastAmortizationFromAccount(int financialAccountId, String trxName) {
        return (MFMAmortization)new Query(Env.getCtx(), "FM_Amortization", "FM_Account_ID = ?", trxName).setParameters(financialAccountId).setOrderBy("PeriodNo DESC").first();
    }

    public static List<MFMAmortization> getAmortizationList(int financialAccountId, String whereClause, String trxName) {
        StringBuffer internalWhereClause = new StringBuffer("FM_Account_ID = ?");
        if (!Util.isEmpty(whereClause)) {
            internalWhereClause.append(" AND ").append(whereClause);
        }
        return new Query(Env.getCtx(), "FM_Amortization", internalWhereClause.toString(), trxName).setParameters(financialAccountId).setOrderBy("PeriodNo").list();
    }

    public static List<MFMAmortization> getToInvoiceList(int financialAccountId, String trxName) {
        return MFMAmortization.getAmortizationList(financialAccountId, "IsInvoiced = 'N'", trxName);
    }

    public static List<MFMAmortization> getToPayList(int financialAccountId, String trxName) {
        return MFMAmortization.getAmortizationList(financialAccountId, "IsPaid = 'N'", trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("CurrentCapitalAmt") || this.is_ValueChanged("CurrentInterestAmt") || this.is_ValueChanged("CurrentTaxAmt") || this.is_ValueChanged("CurrentDunningAmt") || this.is_ValueChanged("CurrentDunningTaxAmt")) {
            MFMAccount account = MFMAccount.getById(this.getCtx(), this.getFM_Account_ID(), this.get_TrxName());
            int currencyPrecision = MCurrency.getStdPrecision(this.getCtx(), account.getC_Currency_ID());
            Optional.ofNullable(this.getCurrentCapitalAmt()).ifPresent(amount -> this.setCurrentCapitalAmt(amount.setScale(currencyPrecision, 4)));
            Optional.ofNullable(this.getCurrentInterestAmt()).ifPresent(amount -> this.setCurrentInterestAmt(amount.setScale(currencyPrecision, 4)));
            Optional.ofNullable(this.getCurrentTaxAmt()).ifPresent(amount -> this.setCurrentTaxAmt(amount.setScale(currencyPrecision, 4)));
            Optional.ofNullable(this.getCurrentDunningAmt()).ifPresent(amount -> this.setCurrentDunningAmt(amount.setScale(currencyPrecision, 4)));
            Optional.ofNullable(this.getCurrentDunningTaxAmt()).ifPresent(amount -> this.setCurrentDunningTaxAmt(amount.setScale(currencyPrecision, 4)));
        }
        return super.beforeSave(newRecord);
    }

    @Override
    public String toString() {
        return "MFMAmortization [getCapitalAmt()=" + this.getCapitalAmt() + ", getDescription()=" + this.getDescription() + ", getDueDate()=" + this.getDueDate() + ", getEndDate()=" + this.getEndDate() + ", getFM_Account_ID()=" + this.getFM_Account_ID() + ", getFM_Amortization_ID()=" + this.getFM_Amortization_ID() + ", isInvoiced()=" + this.isInvoiced() + ", isPaid()=" + this.isPaid() + ", getPeriodNo()=" + this.getPeriodNo() + ", getTaxAmt()=" + this.getTaxAmt() + "]";
    }
}

