/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.model.X_AD_TokenDefinition;

public class MADTokenDefinition
extends X_AD_TokenDefinition {
    private static final long serialVersionUID = -1171525387615789574L;
    private static CCache<Integer, MADTokenDefinition> definitionCacheIds = new CCache("AD_TokenDefinition", 30);
    private static CCache<String, MADTokenDefinition> definitionCacheValues = new CCache("AD_TokenDefinition", 30);

    public MADTokenDefinition(Properties ctx, int AD_TokenDefinition_ID, String trxName) {
        super(ctx, AD_TokenDefinition_ID, trxName);
    }

    public MADTokenDefinition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MADTokenDefinition getById(Properties ctx, int definitionId, String trxName) {
        if (definitionId <= 0) {
            return null;
        }
        MADTokenDefinition definition = definitionCacheIds.get(definitionId);
        if (definition != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADTokenDefinition)new Query(ctx, "AD_TokenDefinition", "AD_TokenDefinition_ID=?", trxName).setClient_ID().setParameters(definitionId).first();
        if (definition != null && definition.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID(ctx);
            String key = clientId + "#" + definition.getValue();
            definitionCacheValues.put(key, definition);
            definitionCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static MADTokenDefinition getByTokenType(Properties ctx, String tokenType, String trxName) {
        int clientId;
        String key;
        MADTokenDefinition definition;
        if (tokenType == null) {
            return null;
        }
        if (definitionCacheValues.size() == 0) {
            MADTokenDefinition.getAll(ctx, true, trxName);
        }
        if ((definition = definitionCacheValues.get(key = (clientId = Env.getAD_Client_ID(ctx)) + "#" + tokenType)) != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADTokenDefinition)new Query(ctx, "AD_TokenDefinition", "TokenType=? AND AD_Client_ID IN(0, ?)", trxName).setParameters(tokenType, clientId).setOrderBy("AD_Client_ID DESC").first();
        if (definition != null && definition.get_ID() > 0) {
            definitionCacheValues.put(key, definition);
            definitionCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static List<MADTokenDefinition> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || definitionCacheIds.size() > 0) {
            List<MADTokenDefinition> definitionList = new Query(Env.getCtx(), "AD_TokenDefinition", null, trxName).setClient_ID().setOrderBy("Name").list();
            definitionList.stream().forEach(definition -> {
                int clientId = Env.getAD_Client_ID(ctx);
                String key = clientId + "#" + definition.getValue();
                definitionCacheIds.put(definition.getAD_TokenDefinition_ID(), (MADTokenDefinition)definition);
                definitionCacheValues.put(key, (MADTokenDefinition)definition);
            });
            return definitionList;
        }
        List<MADTokenDefinition> definitionList = definitionCacheIds.entrySet().stream().map(activity -> (MADTokenDefinition)activity.getValue()).collect(Collectors.toList());
        return definitionList;
    }

    @Override
    public String toString() {
        return "MADTokenDefinition [getAD_TokenDefinition_ID()=" + this.getAD_TokenDefinition_ID() + ", getClassname()=" + this.getClassname() + ", getName()=" + this.getName() + ", getTokenType()=" + this.getTokenType() + ", getValue()=" + this.getValue() + "]";
    }
}

