/*
 * Decompiled with CFR 0.152.
 */
package org.spin.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import org.spin.apps.form.BankStatementMatchController;

public class VBankStatementMatch
extends BankStatementMatchController
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener {
    public static CLogger log = CLogger.getCLogger(VBankStatementMatch.class);
    private FormFrame frame;
    private MiniTable currentPaymentTable = new MiniTable();
    private CPanel currentPaymentPanel = new CPanel();
    private JLabel currentPaymentLabel = new JLabel();
    private BorderLayout currentPaymentLayout = new BorderLayout();
    private JScrollPane currentPaymentScrollPane = new JScrollPane();
    private MiniTable importedPaymentTable = new MiniTable();
    private CPanel importedPaymentPanel = new CPanel();
    private JLabel importedPaymentLabel = new JLabel();
    private BorderLayout importedPaymentLayout = new BorderLayout();
    private JScrollPane importedPaymentScrollPane = new JScrollPane();
    private MiniTable matchedPaymentTable = new MiniTable();
    private CPanel matchedPaymentPanel = new CPanel();
    private JLabel matchedPaymentLabel = new JLabel();
    private BorderLayout matchedPaymentLayout = new BorderLayout();
    private JScrollPane matchedPaymentScrollPane = new JScrollPane();
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout();
    private JSplitPane comparePanel = new JSplitPane(1);
    private StatusBar statusBar = new StatusBar();
    private GridLayout allocationLayout = new GridLayout(0, 2);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CPanel leftProcessPanel = new CPanel(new FlowLayout(0));
    private ConfirmPanel rightProcessPanel = new ConfirmPanel();
    private CPanel matchPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel matchTypeLabel = new JLabel();
    private CComboBox matchMode = new CComboBox(this.m_matchMode);
    private JLabel bankAccountLabel = new JLabel();
    private VLookup bankAccountField;
    private CLabel amtFromLabel = new CLabel(Msg.translate(Env.getCtx(), "PayAmt"));
    private VNumber amtFromField = new VNumber("AmtFrom", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtFrom"));
    private CLabel amtToLabel = new CLabel("-");
    private VNumber amtToField = new VNumber("AmtTo", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtTo"));
    private CLabel bpartnerLabel = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup bPartnerLookup;
    private CLabel dateFromLabel = new CLabel(Msg.translate(Env.getCtx(), "DateTrx"));
    private VDate dateFromField = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel dateToLabel = new CLabel("-");
    private VDate dateToField = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private CButton searchButton;
    private CButton simulateMatchButton;

    @Override
    public void init(int windowNo, FormFrame frame) {
        super.init(windowNo, frame.getProcessInfo());
        this.frame = frame;
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
            frame.setMaximize(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this.mainPanel);
        this.searchButton = ConfirmPanel.createRefreshButton(true);
        this.simulateMatchButton = ConfirmPanel.createProcessButton(true);
        this.simulateMatchButton.setText(this.getButtonMatchMessage());
        this.simulateMatchButton.setToolTipText(this.getButtonMatchMessage());
        this.rightProcessPanel.setOKVisible(true);
        this.rightProcessPanel.setCancelVisible(true);
        this.matchedPaymentTable.setMultiSelection(true);
        this.mainPanel.setLayout(this.mainLayout);
        this.centerPanel.setLayout(this.centerLayout);
        this.bankAccountLabel.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.importedPaymentLabel.setText(Msg.translate(Env.getCtx(), "BankStatementMatch.Imported"));
        this.currentPaymentLabel.setText(Msg.translate(Env.getCtx(), "BankStatementMatch.Current"));
        this.matchedPaymentLabel.setText(Msg.translate(Env.getCtx(), "BankStatementMatch.Matched"));
        this.dateFromLabel.setLabelFor(this.dateFromField);
        this.dateFromField.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.dateToLabel.setLabelFor(this.dateToField);
        this.dateToField.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.amtFromLabel.setLabelFor(this.amtFromField);
        this.amtFromField.setToolTipText(Msg.translate(Env.getCtx(), "AmtFrom"));
        this.amtToLabel.setLabelFor(this.amtToField);
        this.amtToField.setToolTipText(Msg.translate(Env.getCtx(), "AmtTo"));
        this.matchTypeLabel.setText(Msg.translate(Env.getCtx(), "MatchMode"));
        this.searchButton.addActionListener(this);
        this.simulateMatchButton.addActionListener(this);
        this.rightProcessPanel.addActionListener(this);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.importedPaymentPanel.setLayout(this.importedPaymentLayout);
        this.currentPaymentPanel.setLayout(this.currentPaymentLayout);
        this.matchedPaymentPanel.setLayout(this.matchedPaymentLayout);
        this.matchPanel.setLayout(this.allocationLayout);
        this.importedPaymentPanel.setPreferredSize(new Dimension(300, 600));
        this.currentPaymentPanel.setPreferredSize(new Dimension(300, 600));
        this.matchedPaymentPanel.setPreferredSize(new Dimension(400, 300));
        this.bankAccountField.setSize(this.bankAccountField.getWidth() + 10, this.bankAccountField.getHeight() + 10);
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.bankAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bankAccountField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bPartnerLookup, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.amtFromLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.amtFromField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.amtToLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.amtToField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateFromLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateFromField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateToLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateToField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.matchTypeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.matchMode, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.searchButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.matchPanel, "South");
        this.matchPanel.add(this.leftProcessPanel);
        this.leftProcessPanel.add(this.simulateMatchButton);
        this.matchPanel.add(this.rightProcessPanel);
        this.importedPaymentPanel.add((Component)this.importedPaymentLabel, "North");
        this.importedPaymentPanel.add((Component)this.importedPaymentScrollPane, "Center");
        this.importedPaymentScrollPane.getViewport().add((Component)this.importedPaymentTable, null);
        this.currentPaymentPanel.add((Component)this.currentPaymentLabel, "North");
        this.currentPaymentPanel.add((Component)this.currentPaymentScrollPane, "Center");
        this.currentPaymentScrollPane.getViewport().add((Component)this.currentPaymentTable, null);
        this.matchedPaymentPanel.add((Component)this.matchedPaymentLabel, "North");
        this.matchedPaymentPanel.add((Component)this.matchedPaymentScrollPane, "Center");
        this.matchedPaymentScrollPane.getViewport().add((Component)this.matchedPaymentTable, null);
        this.comparePanel.setLeftComponent(this.importedPaymentPanel);
        this.comparePanel.setRightComponent(this.currentPaymentPanel);
        this.comparePanel.add((Component)this.importedPaymentPanel, "left");
        this.comparePanel.add((Component)this.currentPaymentPanel, "right");
        this.comparePanel.setBorder(BorderFactory.createEtchedBorder());
        this.comparePanel.setContinuousLayout(true);
        this.comparePanel.setPreferredSize(new Dimension(2048, 1536));
        this.centerPanel.add((Component)this.comparePanel, "Center");
        this.centerPanel.add((Component)this.matchedPaymentPanel, "South");
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.chageLayout();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VBankStatementMatch.this.comparePanel.setDividerLocation(((VBankStatementMatch)VBankStatementMatch.this).frame.getContainer().getPreferredSize().height / 2);
            }
        });
    }

    @Override
    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = null;
    }

    @Override
    public void dynInit() throws Exception {
        int columnId = 4917;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), this.getWindowNo(), 0, columnId, 19);
        this.bankAccountField = new VLookup("C_BankAccount_ID", true, false, true, lookup);
        this.bankAccountField.addActionListener(this);
        this.bankAccountField.setSize(this.bankAccountField.getWidth() + 10, this.bankAccountField.getHeight() + 10);
        if (this.getBankAccountId() > 0) {
            this.bankAccountField.setValue(this.getBankAccountId());
        }
        this.bPartnerLookup = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.getWindowNo(), 0, 3499, 30));
        this.bpartnerLabel.setLabelFor(this.bPartnerLookup);
        this.matchMode.setMandatory(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config("");
        if (e.getSource().equals(this.searchButton)) {
            log.config("search");
            this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
            this.refresh();
            this.mainPanel.setCursor(Cursor.getDefaultCursor());
        } else if (e.getSource().equals(this.simulateMatchButton)) {
            this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
            if (!this.isHasSelection()) {
                this.statusBar.setStatusLine(Msg.translate(Env.getCtx(), "BankStatementMatch.Matched") + ": " + this.actionMatchUnMatch());
            } else {
                this.statusBar.setStatusLine(Msg.translate(Env.getCtx(), "BankStatementMatch.UnMatched") + ": " + this.actionUnMatchSelected(this.matchedPaymentTable));
            }
            this.loadMatchedPaymentsFromMatch();
            this.changeMessageButton();
            this.mainPanel.setCursor(Cursor.getDefaultCursor());
        } else if (e.getActionCommand().equals("Ok")) {
            if (!this.isAvailableForSave()) {
                return;
            }
            if (ADialog.ask(this.getWindowNo(), this.frame.getContainer(), "SaveChanges?", this.getAskMatchMessage())) {
                this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                this.saveData();
                this.mainPanel.setCursor(Cursor.getDefaultCursor());
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private void refresh() {
        this.clear();
        this.setIsAvailableForSave(false);
        this.getParameters();
        String message = this.validateParameters();
        if (Util.isEmpty(message)) {
            this.loadPayments();
            this.loadImportedPayments();
            this.loadMatchedPayments();
        } else {
            ADialog.error(this.getWindowNo(), this.frame.getContainer(), "ValidationError", Msg.parseTranslation(Env.getCtx(), message));
        }
    }

    private void getParameters() {
        this.setBankAccountId((Integer)(this.bankAccountField.getValue() != null ? this.bankAccountField.getValue() : Integer.valueOf(0)));
        this.setAmtFrom(this.amtFromField.getValue() != null ? (BigDecimal)this.amtFromField.getValue() : null);
        this.setAmtTo(this.amtToField.getValue() != null ? (BigDecimal)this.amtToField.getValue() : null);
        this.setDateFrom(this.dateFromField.getValue() != null ? (Timestamp)this.dateFromField.getValue() : null);
        this.setDateTo(this.dateToField.getValue() != null ? (Timestamp)this.dateToField.getValue() : null);
        this.setMatchMode(this.matchMode.getSelectedIndex());
        this.chageLayout();
        this.setHasSelection(false);
        this.statusBar.setStatusLine("");
    }

    private void chageLayout() {
        if (this.isFromStatement()) {
            this.bankAccountField.setEnabled(false);
            this.bankAccountField.setReadWrite(false);
            if (this.dateToField.getValue() == null) {
                this.dateToField.setValue(this.getStatementDate());
            }
        } else {
            this.bankAccountField.setEnabled(true);
            this.bankAccountField.setReadWrite(true);
        }
        this.simulateMatchButton.setText(this.getButtonMatchMessage());
        this.simulateMatchButton.setToolTipText(this.getButtonMatchMessage());
    }

    private void loadPayments() {
        this.fillPayments(this.getPaymentData());
    }

    private void fillPayments(Vector<Vector<Object>> data) {
        this.currentPaymentTable.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(data, this.getCurrentPaymentColumnNames());
        model.addTableModelListener(this);
        this.currentPaymentTable.setModel(model);
        this.configureCurrentPaymentTable(this.currentPaymentTable);
    }

    private void loadImportedPayments() {
        this.fillImportedPayments(this.getImportedPaymentData());
    }

    private void fillImportedPayments(Vector<Vector<Object>> data) {
        this.importedPaymentTable.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(data, this.getImportedPaymentColumnNames());
        model.addTableModelListener(this);
        this.importedPaymentTable.setModel(model);
        this.configureImportedPaymentTable(this.importedPaymentTable);
    }

    private void loadMatchedPayments() {
        this.fillMatchedPayments(new Vector<Vector<Object>>());
    }

    private void loadMatchedPaymentsFromMatch() {
        Vector<Vector<Object>> matchedPayments = this.getMatchedPayments();
        this.setIsAvailableForSave(matchedPayments != null && !matchedPayments.isEmpty());
        this.fillMatchedPayments(matchedPayments);
    }

    private void fillMatchedPayments(Vector<Vector<Object>> data) {
        this.matchedPaymentTable.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(data, this.getMatchedPaymentColumnNames());
        model.addTableModelListener(this);
        this.matchedPaymentTable.setModel(model);
        this.configureMatchedPaymentTable(this.matchedPaymentTable);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() != 0) {
            return;
        }
        log.config("Row=" + e.getFirstRow() + "-" + e.getLastRow() + ", Col=" + e.getColumn() + ", Type=" + e.getType());
        boolean isUpdate = e.getType() == 0;
        int row = e.getFirstRow();
        if (!isUpdate) {
            return;
        }
        boolean isMatched = false;
        if (e.getSource().equals(this.currentPaymentTable.getModel())) {
            int matchedRow = this.currentPaymentTable.getSelectedRow();
            if (matchedRow != row) {
                return;
            }
            if (matchedRow >= 0) {
                IDColumn paymentIdColumn = (IDColumn)this.currentPaymentTable.getValueAt(matchedRow, 0);
                isMatched = this.paymentApplyForMatch(paymentIdColumn.getRecord_ID());
            }
        } else if (e.getSource().equals(this.importedPaymentTable.getModel())) {
            int matchedRow = this.importedPaymentTable.getSelectedRow();
            if (matchedRow != row) {
                return;
            }
            if (matchedRow >= 0) {
                IDColumn importedPaymentIdColumn = (IDColumn)this.importedPaymentTable.getValueAt(matchedRow, 0);
                isMatched = this.importedPaymentApplyForMatch(importedPaymentIdColumn.getRecord_ID());
            }
        } else if (e.getSource().equals(this.matchedPaymentTable.getModel())) {
            int matchedRow = this.matchedPaymentTable.getSelectedRow();
            if (matchedRow != row) {
                return;
            }
            if (matchedRow >= 0) {
                IDColumn matchedPaymentIdColumn = (IDColumn)this.matchedPaymentTable.getValueAt(matchedRow, 0);
                this.selectFromMatch(matchedPaymentIdColumn.getRecord_ID());
                this.changeMessageButton();
            }
        }
        if (isMatched) {
            this.loadMatchedPaymentsFromMatch();
        }
    }

    private void selectFromMatch(int paymentId) {
        for (int row = 0; row < this.currentPaymentTable.getRowCount(); ++row) {
            IDColumn record = (IDColumn)this.currentPaymentTable.getValueAt(row, 0);
            if (record == null || record.getRecord_ID() != paymentId) continue;
            this.currentPaymentTable.setRowSelectionInterval(row, row);
        }
        int importedPaymentId = this.getImportedPaymentId(paymentId);
        if (importedPaymentId > 0) {
            for (int row = 0; row < this.importedPaymentTable.getRowCount(); ++row) {
                IDColumn record = (IDColumn)this.importedPaymentTable.getValueAt(row, 0);
                if (record == null || record.getRecord_ID() != importedPaymentId) continue;
                this.importedPaymentTable.setRowSelectionInterval(row, row);
            }
        }
    }

    private void changeMessageButton() {
        boolean deleteAllocation = false;
        for (int row = 0; row < this.matchedPaymentTable.getRowCount(); ++row) {
            IDColumn record = (IDColumn)this.matchedPaymentTable.getValueAt(row, 0);
            if (record == null || !record.isSelected()) continue;
            deleteAllocation = true;
            break;
        }
        this.setHasSelection(deleteAllocation);
        this.simulateMatchButton.setText(this.getButtonMatchMessage(deleteAllocation));
        this.simulateMatchButton.setToolTipText(this.getButtonMatchMessage(deleteAllocation));
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(name + "=" + value);
        if (value == null) {
            return;
        }
    }

    public void saveData() {
        if (!this.isAvailableForSave()) {
            return;
        }
        try {
            Trx.run(new TrxRunnable(){

                @Override
                public void run(String trxName) {
                    VBankStatementMatch.this.statusBar.setStatusLine(VBankStatementMatch.this.saveData(VBankStatementMatch.this.getWindowNo(), trxName));
                }
            });
            this.refresh();
        }
        catch (Exception e) {
            ADialog.error(this.getWindowNo(), this.mainPanel, "Error", e.getLocalizedMessage());
        }
        finally {
            if (this.isFromStatement()) {
                this.dispose();
            }
        }
    }
}

