/*
 * Decompiled with CFR 0.152.
 */
package org.openup.purchase.model;

import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelection;
import org.compiere.model.MSequence;
import org.compiere.model.MSequenceCtl;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceipt;

public class InvoiceTerValidator
implements ModelValidator {
    public static final String CTX_IsLiberoEnabled = "#IsInvoiceTercero";
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;
    private int m_AD_Org_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        } else {
            this.log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        Env.setContext(Env.getCtx(), CTX_IsLiberoEnabled, true);
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        this.m_AD_User_ID = AD_User_ID;
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInvoice invoice;
        this.log.info(po.get_TableName() + " Timing: " + type);
        if (po instanceof MInvoice && (type == 1 || type == 2) && (invoice = (MInvoice)po).getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DPI") && (invoice.getDocumentNo() == null || invoice.getDocumentNo().trim().equalsIgnoreCase(""))) {
            return "Seleccione numero del documento";
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String docValidate(PO po, int timing) {
        this.log.info(po.get_TableName() + " Timing: " + timing);
        String retorno = "";
        if (po instanceof MInvoice && timing == 9) {
            MInvoice invoice = (MInvoice)po;
            if (!invoice.isSOTrx()) {
                MSequence seq;
                if (!invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DPI") || invoice.getReversal_ID() > 0 || (seq = (MSequence)invoice.getC_DocTypeTarget().getDocNoSequence()) == null || seq.get_ID() <= 0 || !seq.get_ValueAsBoolean("IsDocNoControlled")) return null;
                MSequenceCtl ctl = this.verifyCheckNumber(invoice);
                if (null == ctl) return "Verifique nro. de cheque seleccionado";
                ctl.setIsApply(true);
                ctl.setDateTrx(invoice.getDateInvoiced());
                ctl.setAD_Table_ID(invoice.get_Table_ID());
                ctl.setRecord_ID(invoice.get_ID());
                ctl.saveEx();
                int docTypeID = MDocType.getDocType("DPC");
                MInvoice nc = this.createCreditNoteDeferred(invoice, docTypeID, invoice.isSOTrx(), true, false);
                if (!nc.processIt("CO")) {
                    retorno = nc.getProcessMsg();
                    nc.deleteEx(true);
                    return retorno;
                }
                nc.saveEx();
                return null;
            } else {
                MUYPayReceipt pay;
                if (!invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DRI") || invoice.getGrandTotal().compareTo(Env.ZERO) <= 0 || invoice.get_ValueAsInt("UY_PayReceipt_ID") <= 0 || (pay = new MUYPayReceipt(invoice.getCtx(), invoice.get_ValueAsInt("UY_PayReceipt_ID"), invoice.get_TrxName())).get_ValueAsBoolean("IsRepresentation")) return null;
                int docTypeID = MDocType.getDocType("DRC");
                MInvoice nc = this.createCreditNoteDeferred(invoice, docTypeID, invoice.isSOTrx(), true, false);
                if (!nc.processIt("CO")) {
                    retorno = nc.getProcessMsg();
                    nc.deleteEx(true);
                    return retorno;
                }
                nc.saveEx();
            }
            return null;
        } else {
            if (po instanceof MInvoice && timing == 7) {
                MSequence seq;
                MInvoice invoice = (MInvoice)po;
                if (invoice.isSOTrx() || invoice.getReversal_ID() > 0 || !invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DPI") || (seq = (MSequence)invoice.getC_DocTypeTarget().getDocNoSequence()) == null || seq.get_ID() <= 0 || !seq.get_ValueAsBoolean("IsDocNoControlled") || !seq.get_ValueAsBoolean("IsSkipSeq") || null != this.verifyCheckNumber(invoice)) return null;
                return "Verifique nro. de cheque seleccionado";
            }
            if (po instanceof MInvoice && timing == 2) {
                MUYPayReceipt pay;
                MInvoice invoice = (MInvoice)po;
                if (!invoice.isSOTrx()) {
                    if (!invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DPI")) return null;
                    retorno = this.verifyVoidDeferredDoc(invoice);
                    if (retorno != null) {
                        return retorno;
                    }
                    retorno = this.voidCreditNoteDeferred(invoice);
                    if (retorno != null) {
                        return retorno;
                    }
                    String sql = "select l.ad_sequencectl_id from c_doctype doc inner join ad_sequence sec on doc.docnosequence_id = sec.ad_sequence_id inner join ad_sequencectl l on sec.ad_sequence_id = l.ad_sequence_id where doc.c_doctype_id = " + invoice.getC_DocTypeTarget_ID() + " and l.documentno = '" + invoice.getDocumentNo() + "'";
                    int ctlLineID = DB.getSQLValueEx(invoice.get_TrxName(), sql, new Object[0]);
                    if (ctlLineID <= 0) return "";
                    DB.executeUpdateEx("update ad_sequencectl set isapply = 'N' where ad_sequencectl_id = " + ctlLineID, invoice.get_TrxName());
                    return "";
                }
                if (!invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DRI") || invoice.get_ValueAsInt("UY_PayReceipt_ID") <= 0 || (pay = new MUYPayReceipt(invoice.getCtx(), invoice.get_ValueAsInt("UY_PayReceipt_ID"), invoice.get_TrxName())) == null || pay.get_ID() <= 0 || pay.get_ValueAsBoolean("IsRepresentation") || (retorno = this.voidCreditNoteTerDeferred(invoice)) == null) return null;
                return retorno;
            }
            if (!(po instanceof MOrder) || timing != 9) return null;
            MOrder order = (MOrder)po;
            MDocType doc = (MDocType)order.getC_DocTypeTarget();
            MDocTypeCounter docCount = MDocTypeCounter.getCounterDocType(order.getCtx(), doc.get_ID());
            if (docCount == null || docCount.get_ID() <= 0 || !docCount.isActive() || docCount.getCounter_C_DocType_ID() <= 0) return null;
            MDocType docTarget = (MDocType)docCount.getCounter_C_DocType();
            this.createSOfromPO(order, docTarget.get_ID(), docTarget.isSOTrx(), true, docCount.getDocAction());
        }
        return null;
    }

    private String verifyVoidDeferredDoc(MInvoice invoice) {
        String sql = "";
        String retorno = "";
        sql = "select p.c_payselection_id from c_payselection p join c_doctype d on p.c_doctype_id = d.c_doctype_id join uy_payselectionlinedif l on p.c_payselection_id = l.c_payselection_id where d.docbasetype = 'APS' and p.docstatus <> 'VO' and l.c_invoice_id = " + invoice.get_ID();
        int receiptID = DB.getSQLValueEx(invoice.get_TrxName(), sql, new Object[0]);
        if (receiptID > 0) {
            MPaySelection pay = new MPaySelection(invoice.getCtx(), receiptID, invoice.get_TrxName());
            retorno = "Imposible anular documento: el cheque ha sido utilizado en el recibo de pago Nro. " + pay.getDocumentNo() + ", en estado diferente a anulado";
            return retorno;
        }
        return null;
    }

    private String voidCreditNoteDeferred(MInvoice invoice) {
        String sql = "";
        String retorno = "";
        sql = "select i.c_invoice_id from c_invoice i join c_doctype d on i.c_doctypetarget_id = d.c_doctype_id where i.ref_invoice_id = " + invoice.get_ID() + " and d.docbasetype = 'DPC' and i.docstatus = 'CO'";
        int ncID = DB.getSQLValueEx(invoice.get_TrxName(), sql, new Object[0]);
        if (ncID > 0) {
            MInvoice invNC = new MInvoice(invoice.getCtx(), ncID, invoice.get_TrxName());
            sql = "select p.c_payselection_id from c_payselection p join c_doctype d on p.c_doctype_id = d.c_doctype_id join c_payselectionline l on p.c_payselection_id = l.c_payselection_id where d.docbasetype = 'APS' and p.docstatus <> 'VO' and l.c_invoice_id = " + invNC.get_ID();
            int receiptID = DB.getSQLValueEx(invoice.get_TrxName(), sql, new Object[0]);
            if (receiptID > 0) {
                MPaySelection pay = new MPaySelection(invoice.getCtx(), receiptID, invoice.get_TrxName());
                retorno = "Imposible anular documento: la nota de credito Nro. " + invNC.getDocumentNo() + " asociada a este cheque se encuentra en el recibo de pago Nro. " + pay.getDocumentNo() + ", en estado diferente a anulado";
                return retorno;
            }
            DB.executeUpdateEx("update c_invoice set docstatus = 'VO', docaction = '--' where c_invoice_id = " + invNC.get_ID(), invoice.get_TrxName());
        }
        return null;
    }

    private String voidCreditNoteTerDeferred(MInvoice invoice) {
        MInvoice nc;
        String sql = "";
        String retorno = "";
        String message = "";
        MUYPayReceipt pay = null;
        if (invoice.get_ValueAsInt("UY_PayReceipt_ID") <= 0) {
            throw new AdempiereException("No se encontro recibo asociado a la Nota de Credito Diferida Nro. " + invoice.getDocumentNo());
        }
        pay = new MUYPayReceipt(invoice.getCtx(), invoice.get_ValueAsInt("UY_PayReceipt_ID"), invoice.get_TrxName());
        sql = "select i.c_invoice_id from c_invoice i join c_doctype d on i.c_doctypetarget_id = d.c_doctype_id where i.uy_payreceipt_id = " + pay.get_ID() + " and ref_invoice_id = " + invoice.get_ID() + " and d.docbasetype = 'DRC' and i.docstatus = 'CO'";
        int ncID = DB.getSQLValueEx(invoice.get_TrxName(), sql, new Object[0]);
        if (ncID > 0 && (nc = new MInvoice(invoice.getCtx(), ncID, invoice.get_TrxName())) != null && nc.get_ID() > 0) {
            if (!nc.processIt("VO")) {
                message = nc.getProcessMsg();
                throw new AdempiereException(message);
            }
            nc.saveEx();
            if (!pay.getDocStatus().equalsIgnoreCase("CO")) {
                DB.executeUpdateEx("delete from uy_payreceiptdoc where c_invoice_id = " + nc.get_ID(), invoice.get_TrxName());
                sql = " DELETE FROM Fact_Acct WHERE AD_Table_ID = " + X_C_Invoice.Table_ID + " AND " + "Record_ID" + " = " + nc.get_ID();
                DB.executeUpdateEx(sql, invoice.get_TrxName());
                nc.deleteEx(true);
            }
        }
        return null;
    }

    private MSequenceCtl verifyCheckNumber(MInvoice invoice) {
        MSequence seq = (MSequence)invoice.getC_DocTypeTarget().getDocNoSequence();
        if (seq != null && seq.get_ID() > 0 && !invoice.getDocumentNo().isEmpty()) {
            List<MSequenceCtl> ctlList = seq.getControlLines(" AND IsApply = 'N' ");
            for (MSequenceCtl ctl : ctlList) {
                if (!invoice.getDocumentNo().equalsIgnoreCase(ctl.getDocumentNo())) continue;
                return ctl;
            }
        }
        return null;
    }

    private MInvoice createCreditNoteDeferred(MInvoice origin, int DocTypeTargetTo, boolean isSoTrx, boolean counter, boolean setOrder) {
        MInvoice newInv = MInvoice.copyFrom(origin, origin.getDateInvoiced(), origin.getDateAcct(), DocTypeTargetTo, isSoTrx, counter, false, origin.get_TrxName(), setOrder);
        if (newInv == null || newInv.get_ID() <= 0) {
            throw new AdempiereException("No se puede crear factura al cliente del proyecto");
        }
        newInv.setC_Project_ID(origin.getC_Project_ID());
        newInv.setC_BPartner_ID(origin.getC_BPartner_ID());
        newInv.setC_BPartner_Location_ID(origin.getC_BPartner_Location_ID());
        newInv.setDescription("Creada desde: " + origin.getC_DocType().getPrintName() + ", Nro:" + origin.getDocumentNo());
        newInv.set_ValueOfColumn("UY_PayReceipt_ID", (Object)origin.get_ValueAsInt("UY_PayReceipt_ID"));
        newInv.saveEx(origin.get_TrxName());
        return newInv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createInvoiceToClientProject(MInvoice origin, int DocTypeTargetTo, boolean isSoTrx, boolean counter, boolean setOrder) {
        MInvoice newInv = MInvoice.copyFrom(origin, origin.getDateInvoiced(), origin.getDateAcct(), DocTypeTargetTo, isSoTrx, counter, false, origin.get_TrxName(), setOrder);
        if (newInv == null || newInv.get_ID() <= 0) throw new AdempiereException("No se puede crear factura al cliente del proyecto");
        if (origin.getC_Project_ID() <= 0) throw new AdempiereException("El documento: " + origin.getC_DocType().getPrintName() + ",necesita tener un proyecto asociado");
        newInv.setC_Project_ID(origin.getC_Project_ID());
        MBPartner cbp = (MBPartner)origin.getC_Project().getC_BPartner();
        if (cbp == null || cbp.get_ID() <= 0) throw new AdempiereException("El proyecto asociado al documento, no tiene cliente asociado");
        newInv.setC_BPartner_ID(cbp.get_ID());
        MBPartnerLocation locBp = cbp.getPrimaryC_BPartner_Location();
        if (locBp == null || locBp.get_ID() <= 0) {
            throw new AdempiereException("El cliente asociado al proyecto, no tiene localizacion definida");
        }
        newInv.setC_BPartner_Location_ID(locBp.get_ID());
        newInv.setDescription("Creada desde: " + origin.getC_DocType().getPrintName() + ", Nro:" + origin.getDocumentNo());
        newInv.saveEx(origin.get_TrxName());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createSOfromPO(MOrder origin, int DocTypeTargetTo, boolean isSoTrx, boolean counter, String docAction) {
        MOrder newOrd = MOrder.copyFrom(origin, origin.getDateOrdered(), DocTypeTargetTo, isSoTrx, counter, false, origin.get_TrxName());
        if (newOrd == null || newOrd.get_ID() <= 0) throw new AdempiereException("No se puede crear orden de venta al cliente del proyecto");
        if (origin.getC_Project_ID() <= 0) throw new AdempiereException("El documento: " + origin.getC_DocType().getPrintName() + " necesita tener un proyecto asociado");
        newOrd.setC_Project_ID(origin.getC_Project_ID());
        MBPartner cbp = (MBPartner)origin.getC_Project().getC_BPartner();
        if (cbp == null || cbp.get_ID() <= 0) throw new AdempiereException("El proyecto asociado al documento no tiene cliente asociado");
        newOrd.setC_BPartner_ID(cbp.get_ID());
        MBPartnerLocation locBp = cbp.getPrimaryC_BPartner_Location();
        if (locBp == null || locBp.get_ID() <= 0) {
            throw new AdempiereException("El cliente asociado al proyecto no tiene localizacion definida");
        }
        newOrd.setC_BPartner_Location_ID(locBp.get_ID());
        newOrd.setDescription("Creada desde: " + origin.getC_DocType().getPrintName() + " Nro " + origin.getDocumentNo());
        newOrd.saveEx(origin.get_TrxName());
        if (docAction == null || docAction.equalsIgnoreCase("")) return null;
        if (docAction.equalsIgnoreCase("CO")) {
            if (!newOrd.processIt("CO")) {
                this.log.warning("Error al completar Orden Nro. : " + newOrd.getDocumentNo());
            }
        } else if (docAction.equalsIgnoreCase("PR") && !newOrd.processIt("PR")) {
            this.log.warning("Error al preparar Orden Nro. : " + newOrd.getDocumentNo());
        }
        newOrd.saveEx();
        return null;
    }
}

