/*
 * Decompiled with CFR 0.152.
 */
package org.openup.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.openup.core.model.MUYLoadRate;
import org.openup.core.model.MUYLoadRateLine;
import org.openup.webservice.Cotiza.DatoscotizacionesDato;
import org.openup.webservice.Cotiza.WsbcucotizacionesExecute;
import org.openup.webservice.Cotiza.WsbcucotizacionesExecuteResponse;
import org.openup.webservice.Cotiza.WsbcucotizacionesSoapPortProxy;
import org.openup.webservice.Cotiza.Wsbcucotizacionesin;
import org.openup.webservice.Cotiza.Wsbcucotizacionesout;

public class PQueryBCUCurrencyArbitration
extends SvrProcess {
    private int cCurrencyIDto;
    private MClient mClient;
    private Date currentDate;
    private MUYLoadRate mLoadRate;
    private List<MUYLoadRateLine> mLoadRateLines;
    private boolean catchExceptions;
    private int ad_client_id;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    protected void prepare() {
        this.log("Prepare - Entrando");
        ProcessInfoParameter[] parameters = this.getParameter();
        for (int i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("DateExecuted")) {
                this.log("Prepare - Seteando DateExecuted");
                this.currentDate = (Date)parameters[i].getParameter();
                this.log("Prepare - Seteado DateExecuted");
                continue;
            }
            if (name.equalsIgnoreCase("catchExceptions")) {
                this.log("Prepare - Seteando catchExceptions");
                this.catchExceptions = parameters[i].getParameterAsBoolean();
                this.log("Prepare - Seteando catchExceptions");
                continue;
            }
            if (!name.equalsIgnoreCase("AD_Client_ID")) continue;
            this.log("Prepare - Seteando AD_Client_ID");
            this.ad_client_id = parameters[i].getParameterAsInt();
            this.log("Prepare - Seteando AD_Client_ID");
        }
        this.log("Prepare - Saliendo");
    }

    @Override
    protected String doIt() throws Exception {
        String msgRet = "OK";
        try {
            this.log("doIt - INICIO");
            try {
                this.mLoadRate = new MUYLoadRate(this.getCtx(), DB.getSQLValue(this.get_TrxName(), "SELECT UY_LoadRate_ID FROM UY_LoadRate"), this.get_TrxName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.mLoadRate == null) {
                this.log("doIt - Parametrizaci\ufffdn Carga TC no establecida");
                throw new AdempiereException("Parametrizaci\ufffdn Carga TC no establecida");
            }
            this.mLoadRateLines = new Query(this.getCtx(), "UY_LoadRateLine", "UY_LoadRate_ID=? AND IsActive=?", this.get_TrxName()).setParameters(this.mLoadRate.get_ID(), "Y").list();
            this.log("doIt - Lineas de Parametrizaci\ufffdn TC obtenidas");
            this.cCurrencyIDto = 142;
            this.mClient = this.getRateClient();
            MAcctSchema schema = null;
            if (this.mClient != null && (schema = this.mClient.getAcctSchema()) != null) {
                this.cCurrencyIDto = schema.getC_Currency_ID();
            }
            this.log("doIt - Moneda de destino obtenida");
            this.getFromWebserviceCotizaCotizacion();
            this.log("doIt - Fin try catch doIt");
        }
        catch (Exception e) {
            this.log("doIt - Exception - " + e.getMessage());
            if (this.catchExceptions) {
                msgRet = e.getMessage();
                this.log("doIt - Exception - Capturo exception");
            }
            this.log("doIt - Exception - Lanzo exception");
            throw new AdempiereException(e);
        }
        this.log("doIt - FIN");
        return msgRet;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getFromWebserviceCotizaCotizacion() throws RemoteException, ParseException {
        this.log("getFromWebserviceCotizaCotizacion - INICIO");
        short[] currencies = new short[this.mLoadRateLines.size()];
        this.log("getFromWebserviceCotizaCotizacion - Cantidad de monedas -" + this.mLoadRateLines.size() + "-");
        for (int i = 0; i < this.mLoadRateLines.size(); ++i) {
            currencies[i] = Short.valueOf(this.mLoadRateLines.get(i).getCode());
        }
        this.log("getFromWebserviceCotizaCotizacion - Monedas cargadas en DTO");
        Wsbcucotizacionesin cotizaWsbcucotizacionesin = new Wsbcucotizacionesin();
        WsbcucotizacionesExecute cotizaWsbcucotizacionesExecute = new WsbcucotizacionesExecute();
        WsbcucotizacionesSoapPortProxy wsbcucotizacionesSoapPortProxy = new WsbcucotizacionesSoapPortProxy();
        cotizaWsbcucotizacionesin.setMoneda(currencies);
        cotizaWsbcucotizacionesin.setFechaHasta(this.currentDate);
        cotizaWsbcucotizacionesin.setFechaDesde(this.currentDate);
        cotizaWsbcucotizacionesin.setGrupo((byte)0);
        this.log("getFromWebserviceCotizaCotizacion - Parametros del WS cargados");
        cotizaWsbcucotizacionesExecute.setEntrada(cotizaWsbcucotizacionesin);
        WsbcucotizacionesExecuteResponse executeResponse = wsbcucotizacionesSoapPortProxy.execute(cotizaWsbcucotizacionesExecute);
        this.log("getFromWebserviceCotizaCotizacion - CONSULTA WS REALIZADA");
        if (executeResponse != null) {
            Iterator<Serializable> iterator;
            this.log("getFromWebserviceCotizaCotizacion - Obtenida: respuesta WS");
            Wsbcucotizacionesout wsbcucotizacionesout = executeResponse.getSalida();
            if (wsbcucotizacionesout != null && wsbcucotizacionesout.getRespuestastatus() != null) {
                this.log("getFromWebserviceCotizaCotizacion - Obtenida: Status respuesta");
                if (wsbcucotizacionesout.getRespuestastatus().getStatus() != 1) {
                    this.log("getFromWebserviceCotizaCotizacion - Obtenida: Status respuesta 2 = MAL");
                    this.onErrorWebservice();
                    throw new AdempiereException("Error al consultar cotizaci\ufffdn, respuesta del Webservice: " + wsbcucotizacionesout.getRespuestastatus().getMensaje());
                }
                this.log("getFromWebserviceCotizaCotizacion - Obtenida: Status respuesta 1 = OK");
                DatoscotizacionesDato[] datos = wsbcucotizacionesout.getDatoscotizaciones();
                if (datos == null) {
                    this.log("getFromWebserviceCotizaCotizacion - Obtenida: Datos de respuesta nulos");
                    this.onErrorWebservice();
                    throw new AdempiereException("Error al consultar cotizaci\ufffdn, respuesta sin datos de cotizaci\ufffdn");
                }
                this.log("getFromWebserviceCotizaCotizacion - Obtenida: Datos de Respuesta");
                List<DatoscotizacionesDato> listdatoscotizaciones = Arrays.asList(datos);
                iterator = listdatoscotizaciones.iterator();
            } else {
                this.log("getFromWebserviceCotizaCotizacion - Obtenida: Status respuesta Vacia");
                this.onErrorWebservice();
                throw new AdempiereException("Error al consultar cotizaci\ufffdn, mensaje vacio");
            }
            while (iterator.hasNext()) {
                DatoscotizacionesDato dato = iterator.next();
                MUYLoadRateLine mLoadRateLine = this.getMLoadRateLineByCurrencyCode(dato.getMoneda());
                this.log("getFromWebserviceCotizaCotizacion - Obtenida: Respuesta: Creado MLoadRateLine - " + dato.getMoneda());
                if (MSysConfig.getBooleanValue("UY_WS_Cotiza_monedaCompra", true, this.getAD_Client_ID())) {
                    this.log("getFromWebserviceCotizaCotizacion - Obtenida: Respuesta: monedaCompra: -" + dato.getTCC() + "-");
                    this.setMConversionRate((MCurrency)mLoadRateLine.getC_Currency(), BigDecimal.valueOf(dato.getTCC()));
                } else {
                    this.log("getFromWebserviceCotizaCotizacion - Obtenida: Respuesta: monedaVenta: -" + dato.getTCV() + "-");
                    this.setMConversionRate((MCurrency)mLoadRateLine.getC_Currency(), BigDecimal.valueOf(dato.getTCV()));
                }
                this.mLoadRateLines.remove(mLoadRateLine);
                this.log("getFromWebserviceCotizaCotizacion - Obtenida: Respuesta: Moneda WS " + dato.getMoneda() + " creada completamente");
            }
            for (MUYLoadRateLine line : this.mLoadRateLines) {
                this.log("getFromWebserviceCotizaCotizacion - Moneda no obtenida del WS: " + line.getC_Currency_ID());
                this.setMConversionRate((MCurrency)line.getC_Currency(), null);
                this.log("getFromWebserviceCotizaCotizacion - FIN Moneda no obtenida del WS: " + line.getC_Currency_ID());
            }
        }
    }

    private MUYLoadRateLine getMLoadRateLineByCurrencyCode(short code) {
        MUYLoadRateLine ret = null;
        for (int i = 0; ret == null && i < this.mLoadRateLines.size(); ++i) {
            MUYLoadRateLine mLoadRateLine = this.mLoadRateLines.get(i);
            String strCode = StringUtils.leftPad(String.valueOf(code), 4, "0");
            if (!mLoadRateLine.getCode().equalsIgnoreCase(strCode)) continue;
            ret = mLoadRateLine;
        }
        return ret;
    }

    private void onErrorWebservice() throws ParseException, RuntimeException {
        this.log("setMConversionRate - onErrorWebservice");
        for (MUYLoadRateLine mLoadRateLine : this.mLoadRateLines) {
            this.setMConversionRate((MCurrency)mLoadRateLine.getC_Currency(), null);
        }
    }

    private void setMConversionRate(MCurrency mCurrency, BigDecimal conversionRate) throws ParseException {
        MConversionRate mLastSavedConversionRate = PQueryBCUCurrencyArbitration.getLastRate(this.getCtx(), mCurrency.get_ID(), this.cCurrencyIDto, this.ad_client_id, 0, 114, new Timestamp(this.currentDate.getTime()), this.get_TrxName());
        if (mLastSavedConversionRate != null) {
            this.log("setMConversionRate - Obtenida ultima conversion: " + mLastSavedConversionRate.getC_Currency_ID() + "-" + mLastSavedConversionRate.getC_Currency_ID_To());
        } else {
            this.log("setMConversionRate - Obtenida ultima conversion: No se encontr\ufffd cotizacion previa");
        }
        Timestamp dateTomorrow = TimeUtil.addDays(new Timestamp(this.currentDate.getTime()), 1);
        this.log("setMConversionRate - Fecha dia siguiente: " + dateTomorrow.toString());
        System.out.println(mCurrency.getCurSymbol());
        System.out.println(conversionRate);
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        Date mcrDate = sdf.parse(sdf.format(mLastSavedConversionRate != null ? mLastSavedConversionRate.getValidTo() : new Timestamp(0L)));
        if (mLastSavedConversionRate == null || mcrDate.compareTo(dateTomorrow) < 0) {
            this.log("setMConversionRate - La cotizaci\ufffdn no es de hoy, la instancio");
            System.out.println("INSTANCIANDO COTIZACI\ufffdN");
            MConversionRate newRate = new MConversionRate(this.getCtx(), 0, this.get_TrxName());
            newRate.setC_Currency_ID(mCurrency.get_ID());
            newRate.setC_Currency_ID_To(this.cCurrencyIDto);
            newRate.setC_ConversionType_ID(114);
            newRate.setValidFrom(dateTomorrow);
            newRate.setValidTo(dateTomorrow);
            newRate.setAD_Org_ID(0);
            newRate.set_ValueOfColumn("AD_Client_ID", (Object)this.ad_client_id);
            MConversionRate newRateInv = new MConversionRate(this.getCtx(), 0, this.get_TrxName());
            newRateInv.setC_Currency_ID(this.cCurrencyIDto);
            newRateInv.setC_Currency_ID_To(mCurrency.get_ID());
            newRateInv.setC_ConversionType_ID(114);
            newRateInv.setValidFrom(dateTomorrow);
            newRateInv.setValidTo(dateTomorrow);
            newRateInv.setAD_Org_ID(0);
            newRateInv.set_ValueOfColumn("AD_Client_ID", (Object)this.ad_client_id);
            BigDecimal multiplyRate = Env.ZERO;
            if (conversionRate != null) {
                multiplyRate = conversionRate;
            } else if (mLastSavedConversionRate != null) {
                multiplyRate = mLastSavedConversionRate.getMultiplyRate();
            } else {
                this.log("setMConversionRate - Carga BCU TC: No se ha encontrado cotizaci\ufffdn de moneda " + mCurrency.getISO_Code() + " del BCU y tampoco se tienen registros previos para replicar");
                throw new AdempiereException("Carga BCU TC: No se ha encontrado cotizaci\ufffdn de moneda " + mCurrency.getISO_Code() + " del BCU y tampoco se tienen registros previos para replicar");
            }
            newRate.setMultiplyRate(conversionRate != null ? conversionRate : mLastSavedConversionRate.getMultiplyRate());
            newRate.setDivideRate(conversionRate != null ? Env.ONE.divide(conversionRate, 12, RoundingMode.HALF_UP) : mLastSavedConversionRate.getDivideRate());
            newRate.saveEx();
            newRateInv.setMultiplyRate(newRate.getDivideRate());
            newRateInv.setDivideRate(newRate.getMultiplyRate());
            newRateInv.saveEx();
            this.log("setMConversionRate - La cotizaci\ufffdn no es de hoy, Instanciada");
        }
    }

    private MClient getRateClient() {
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        MClient client = null;
        try {
            pstmt = DB.prepareStatement("SELECT MIN(AD_Client_ID_Aux) FROM UY_LoadRateClient ", this.get_TrxName());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                client = new MClient(this.getCtx(), rs.getInt(1), this.get_TrxName());
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return client;
    }

    private void log(String msg) {
        this.log.log(Level.SEVERE, "PQueryBCU " + new Timestamp(System.currentTimeMillis()).toString() + ": " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MConversionRate getLastRate(Properties ctx, int cCurrencyFromID, int cCurrencyIDTo, int adClientID, int adOrgID, int cConversionType, Timestamp dateRate, String trxName) {
        MConversionRate rate;
        CPreparedStatement pstmt;
        ResultSet rs;
        block4: {
            String sql = "";
            rs = null;
            pstmt = null;
            rate = null;
            try {
                sql = " SELECT c_conversion_rate_id  FROM c_conversion_rate  WHERE C_Currency_ID=?  AND C_Currency_ID_To=?  AND\tC_ConversionType_ID=?  AND\tValidTo <=?  AND AD_Client_ID IN (0,?)  AND AD_Org_ID IN (0,?)  ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidTo DESC ";
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, cCurrencyFromID);
                pstmt.setInt(2, cCurrencyIDTo);
                pstmt.setInt(3, cConversionType);
                pstmt.setTimestamp(4, dateRate);
                pstmt.setInt(5, adClientID);
                pstmt.setInt(6, adOrgID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                rate = new MConversionRate(ctx, rs.getInt(1), trxName);
            }
            catch (Exception e) {
                try {
                    CLogger.getCLogger(PQueryBCUCurrencyArbitration.class).log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return rate;
    }
}

