/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Optional;
import org.compiere.util.CLogger;
import org.openup.core.utils.Evaluation2FunctionalInterface;
import org.openup.core.utils.GenericActionFunctionalInterface;

public class Utils {
    private static CLogger log = CLogger.getCLogger(Utils.class);

    public static <Val> Val when(Val o1, Val o2, Evaluation2FunctionalInterface<Val> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Condition mandatory");
        }
        return condition.evaluate(o1, o2) ? o1 : o2;
    }

    public static <Val> Val whenNull(Val value, Val elseValue) {
        return Optional.ofNullable(value).orElse(elseValue);
    }

    public static <Val> void setWhenNotNull(Val val, GenericActionFunctionalInterface<Val> theFunction) {
        Utils.doWhenNotNull(val, theFunction, false);
    }

    public static <Val> void setWhenNotNullNoEx(Val val, GenericActionFunctionalInterface<Val> theFunction) {
        Utils.doWhenNotNull(val, theFunction, true);
    }

    public static <Val> void doWhenNotNull(Val val, GenericActionFunctionalInterface<Val> theFunction, boolean catchException) {
        if (val != null && theFunction != null) {
            if (catchException) {
                try {
                    theFunction.doTheWork(val);
                }
                catch (Exception e) {
                    log.fine("@Error@ " + e.getMessage());
                }
            } else {
                theFunction.doTheWork(val);
            }
        }
    }

    public static SimpleDateFormat getSQLSDF() {
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    public static Timestamp getTimestampPrev3112(Timestamp tstm) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(tstm.getTime());
            cal.add(1, -1);
            String prevYear = new SimpleDateFormat("yyyy").format(new Timestamp(cal.getTimeInMillis()));
            return new Timestamp(new SimpleDateFormat("ddMMyyyy").parse("3112" + prevYear).getTime());
        }
        catch (Exception e) {
            return null;
        }
    }
}

