/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.util.ArrayList;
import org.compiere.impexp.BankStatementMatchInfo;
import org.compiere.impexp.BankStatementMatcherInterface;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.X_I_BankStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ReferenceNo_BankMatcher
implements BankStatementMatcherInterface {
    @Override
    public BankStatementMatchInfo findMatch(MBankStatementLine bsl) {
        return null;
    }

    @Override
    public BankStatementMatchInfo findMatch(X_I_BankStatement ibs) {
        BankStatementMatchInfo info = new BankStatementMatchInfo();
        if (ibs.getC_Payment_ID() != 0) {
            return info;
        }
        String ORDERVALUE = " DESC NULLS LAST";
        StringBuffer sql = new StringBuffer("SELECT p.C_Payment_ID FROM C_Payment p WHERE p.AD_Client_ID = ? ");
        StringBuffer where = new StringBuffer();
        StringBuffer orderByClause = new StringBuffer(" ORDER BY ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(ibs.getAD_Client_ID());
        if (!Util.isEmpty(ibs.getISO_Code())) {
            where.append(" AND EXISTS(SELECT 1 FROM C_Currency c WHERE c.C_Currency_ID = p.C_Currency_ID AND c.ISO_Code = ?) ");
            params.add(ibs.getISO_Code());
        } else if (ibs.getC_Currency_ID() != 0) {
            where.append(" AND p.C_Currency_ID = ? ");
            params.add(ibs.getC_Currency_ID());
        }
        if (where.length() > 0) {
            where.append(" AND ");
        }
        boolean isReceipt = ibs.getTrxAmt().compareTo(Env.ZERO) > 0;
        where.append("(p.PayAmt = ? ");
        params.add(isReceipt ? ibs.getTrxAmt() : ibs.getTrxAmt().negate());
        where.append("AND p.IsReceipt = ? )");
        params.add(isReceipt);
        if (where.length() > 0) {
            where.append(" AND ");
        }
        where.append("(p.C_BankAccount_ID = ?)");
        params.add(ibs.getC_BankAccount_ID());
        where.append(" AND p.DocStatus IN('CO', 'CL')");
        where.append(" AND p.IsReconciled = 'N'");
        where.append(" AND NOT EXISTS(SELECT 1 FROM I_BankStatement i WHERE i.C_Payment_ID = p.C_Payment_ID) ");
        orderByClause.append("p.DocumentNo").append(ORDERVALUE);
        orderByClause.append(", p.CheckNo").append(ORDERVALUE);
        orderByClause.append(", p.DateTrx ASC");
        orderByClause.append(", p.Description").append(ORDERVALUE);
        sql.append(where);
        sql.append(orderByClause);
        int paymentId = DB.getSQLValue(ibs.get_TrxName(), sql.toString(), params);
        if (paymentId > 0) {
            info.setC_Payment_ID(paymentId);
        }
        return info;
    }
}

