/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;

public class POGroupingProcessor<POGeneric extends PO> {
    private List<POGeneric> poLines = new ArrayList<POGeneric>();
    private List<KeyNewCriteria<NewCriteria<POGeneric>>> newCriteriaList = new ArrayList<KeyNewCriteria<NewCriteria<POGeneric>>>();
    private Group root = new Group(0);

    public POGroupingProcessor<POGeneric> addCriteria(String key, NewCriteria<POGeneric> newCriteria) {
        this.newCriteriaList.add(new KeyNewCriteria<NewCriteria<POGeneric>>(key, newCriteria));
        return this;
    }

    public POGroupingProcessor<POGeneric> addPO(List<POGeneric> poGenerics) {
        if (poGenerics != null) {
            this.poLines.addAll(poGenerics);
        }
        return this;
    }

    public POGroupingProcessor<POGeneric> addPO(POGeneric poGeneric) {
        if (poGeneric != null) {
            this.poLines.add(poGeneric);
        }
        return this;
    }

    private void grouppingLines() {
        this.poLines.forEach(poLine -> {
            Group theGroup = this.getGroup(poLine, 0, this.root);
            theGroup.add(poLine);
        });
    }

    private Group getGroup(POGeneric poGeneric, Integer levelGrouping, Group currentGroup) {
        if (levelGrouping < this.newCriteriaList.size()) {
            KeyNewCriteria<NewCriteria<POGeneric>> currentCriteria = this.newCriteriaList.get(levelGrouping);
            return this.getGroup(poGeneric, levelGrouping + 1, currentGroup.getChildrenGroup(currentCriteria.getNewCriteria().add(poGeneric), currentCriteria.getKey()));
        }
        return currentGroup;
    }

    public void processGrupedObjects(GroupsToProcess<POGeneric> groupsToProcess) {
        this.grouppingLines();
        HashMap params = new HashMap();
        this.root.doProcess(params, groupsToProcess);
    }

    public <Ret> Ret getListValue(List<POGeneric> poObjects, DifferentFilter<POGeneric, Ret> differentFilter) {
        return this.getListValue(poObjects, differentFilter, null);
    }

    public <Ret> Ret getListValue(List<POGeneric> poObjects, DifferentFilter<POGeneric, Ret> differentFilter, String exceptionMessage) {
        List<Ret> items = this.getDifferents(poObjects, differentFilter);
        if (items.size() != 1) {
            if (exceptionMessage != null) {
                throw new AdempiereException(exceptionMessage + ": " + items);
            }
            return null;
        }
        return items.get(0);
    }

    private <T, Ret> List<Ret> getDifferents(List<T> poList, DifferentFilter<T, Ret> differentFilter) {
        ArrayList ret = new ArrayList();
        poList.forEach(po -> {
            Object t = differentFilter.fieldToCompare(po);
            if (!ret.contains(t)) {
                ret.add(t);
            }
        });
        return ret;
    }

    @FunctionalInterface
    public static interface DifferentFilter<T, Ret> {
        public Ret fieldToCompare(T var1);
    }

    @FunctionalInterface
    public static interface GroupsToProcess<POGeneric extends PO> {
        public void processGroup(HashMap<String, Integer> var1, List<POGeneric> var2);
    }

    private class Group {
        private Integer group_id;
        private String group_key;
        private HashMap<Integer, Group> childrenGroups;
        private List<POGeneric> poList;

        private Group(Integer group_id) {
            this.group_id = group_id;
            this.childrenGroups = new HashMap();
            this.poList = new ArrayList();
        }

        String getGroup_key() {
            return this.group_key;
        }

        void setGroup_key(String group_key) {
            this.group_key = group_key;
        }

        private Group getChildrenGroup(Integer group_id, String group_key) {
            Group group = this.childrenGroups.computeIfAbsent(group_id, x$0 -> new Group((Integer)x$0));
            if (group.getGroup_key() == null) {
                group.setGroup_key(group_key);
            }
            return group;
        }

        private void add(POGeneric poGeneric) {
            this.poList.add(poGeneric);
        }

        private void doProcess(HashMap<String, Integer> params, GroupsToProcess<POGeneric> groupsToProcess) {
            HashMap<String, Integer> clonedParams = new HashMap<String, Integer>(params);
            if (this.group_key != null && !this.group_key.isEmpty()) {
                clonedParams.put(this.group_key, this.group_id);
            }
            if (this.poList.size() > 0) {
                groupsToProcess.processGroup(clonedParams, this.poList);
            } else {
                this.childrenGroups.forEach((integer, group) -> group.doProcess(clonedParams, groupsToProcess));
            }
        }
    }

    private class KeyNewCriteria<NewCriteriaImpl> {
        private String key;
        private NewCriteriaImpl newCriteria;

        KeyNewCriteria(String key, NewCriteriaImpl newCriteria) {
            this.key = key;
            this.newCriteria = newCriteria;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        NewCriteriaImpl getNewCriteria() {
            return this.newCriteria;
        }
    }

    @FunctionalInterface
    public static interface NewCriteria<POGeneric extends PO> {
        public Integer add(POGeneric var1);
    }
}

