/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.Query;
import org.compiere.model.X_GL_Journal;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.openup.core.process.YearEndCloseIntegralAbstract;

public class YearEndCloseIntegral
extends YearEndCloseIntegralAbstract {
    @Override
    protected String doIt() throws Exception {
        MJournalBatch journalBClose = this.executeCloseIntegral();
        if (journalBClose != null && !journalBClose.processIt("CO")) {
            throw new AdempiereException(journalBClose.getProcessMsg());
        }
        MJournalBatch journalBOpen = this.executeOpenIntegral(journalBClose);
        if (journalBOpen != null && !journalBOpen.processIt("CO")) {
            throw new AdempiereException(journalBOpen.getProcessMsg());
        }
        return Msg.getMsg(Env.getAD_Language(this.getCtx()), "DocumentNo") + ": " + journalBClose.getDocumentNo() + " - " + journalBOpen.getDocumentNo();
    }

    private MJournalBatch executeCloseIntegral() {
        MAcctSchema as = new MAcctSchema(this.getCtx(), this.getAcctSchemaId(), this.get_TrxName());
        MJournalBatch journalBatch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
        journalBatch.setAD_Org_ID(this.getOrgId());
        journalBatch.setDateAcct(this.getDateAcct());
        journalBatch.setDateDoc(this.getDateAcct());
        journalBatch.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Year-end Closing Integral ") + TimeUtil.trunc(this.getDateAcct(), "D"));
        journalBatch.setC_DocType_ID(this.getDocTypeId());
        journalBatch.setGL_Category_ID(this.getCategoryId());
        journalBatch.setControlAmt(Env.ZERO);
        journalBatch.setC_Currency_ID(as.getC_Currency_ID());
        journalBatch.set_ValueOfColumn("IsYearEndClosing", (Object)true);
        journalBatch.saveEx();
        String whereClause = "accounttype in ('A', 'L', 'M', 'O')  and ISSUMMARY = 'N' ";
        List sourceAccounts = new Query(this.getCtx(), "C_ElementValue", whereClause, this.get_TrxName()).setOrderBy("value").list();
        if (this.isDetailed()) {
            for (MElementValue sourceAccount : sourceAccounts) {
                BigDecimal balance = this.searchBalance(sourceAccount.getC_ElementValue_ID());
                if (balance.signum() == 0) continue;
                this.createJournalDetailed(as, journalBatch, sourceAccount);
            }
        } else {
            for (MElementValue sourceAccount : sourceAccounts) {
                BigDecimal balance = this.searchBalance(sourceAccount.getC_ElementValue_ID());
                if (balance.signum() == 0) continue;
                this.createJournal(as, journalBatch, sourceAccount, balance);
            }
        }
        return journalBatch;
    }

    private MJournalBatch executeOpenIntegral(MJournalBatch journalBClose) {
        String sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        boolean createJournalHdr = true;
        MJournal journal = null;
        MJournalBatch journalBatch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
        try {
            MJournal[] journals;
            MAcctSchema as = new MAcctSchema(this.getCtx(), this.getAcctSchemaId(), this.get_TrxName());
            journalBatch.setAD_Org_ID(this.getOrgId());
            journalBatch.setDateAcct(TimeUtil.addDays(this.getDateAcct(), 1));
            journalBatch.setDateDoc(this.getDateAcct());
            journalBatch.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Year-end Opening Integral ") + TimeUtil.trunc(this.getDateAcct(), "D"));
            journalBatch.setC_DocType_ID(this.getDocTypeId());
            journalBatch.setGL_Category_ID(this.getCategoryId());
            journalBatch.setControlAmt(Env.ZERO);
            journalBatch.setC_Currency_ID(as.getC_Currency_ID());
            journalBatch.set_ValueOfColumn("IsYearEndClosing", (Object)true);
            journalBatch.saveEx();
            for (MJournal j : journals = journalBClose.getJournals(true)) {
                sql = "SELECT account_id,amtacctdr,amtacctcr, c_currency_id, c_bpartner_id FROM fact_acct WHERE ad_table_id = " + X_GL_Journal.Table_ID + " and record_id = " + j.get_ID();
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (createJournalHdr) {
                        journal = new MJournal(journalBatch);
                        journal.setC_Currency_ID(as.getC_Currency_ID());
                        journal.setC_AcctSchema_ID(as.get_ID());
                        journal.setC_ConversionType_ID(114);
                        journal.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Year-end Opening Integral"));
                        journal.setDocumentNo(DB.getDocumentNo(this.getAD_Client_ID(), "GL_Journal", this.get_TrxName()));
                        journal.setGL_Category_ID(this.getCategoryId());
                        journal.saveEx();
                        createJournalHdr = false;
                    }
                    int acountID = rs.getInt("account_id");
                    BigDecimal acctDR = rs.getBigDecimal("amtacctdr");
                    BigDecimal acctCR = rs.getBigDecimal("amtacctcr");
                    int currencyID = rs.getInt("c_currency_id");
                    int partnerID = rs.getInt("c_bpartner_id");
                    MElementValue value = new MElementValue(this.getCtx(), acountID, this.get_TrxName());
                    this.createLineFromAcct(journal, value, acctDR, acctCR, currencyID, partnerID);
                }
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return journalBatch;
    }

    private Boolean createJournal(MAcctSchema as, MJournalBatch journalBatch, MElementValue sourceAccount, BigDecimal balance) {
        MJournal journal = new MJournal(journalBatch);
        if (journal == null) {
            return false;
        }
        journal.setC_Currency_ID(as.getC_Currency_ID());
        journal.setC_AcctSchema_ID(as.get_ID());
        journal.setC_ConversionType_ID(114);
        journal.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Year-end Closing Integral - ") + sourceAccount.getValue() + " " + sourceAccount.getName());
        journal.setDocumentNo(DB.getDocumentNo(this.getAD_Client_ID(), "GL_Journal", this.get_TrxName()));
        journal.setGL_Category_ID(this.getCategoryId());
        journal.saveEx();
        if (!this.createLines(journal, sourceAccount, balance).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean createJournalDetailed(MAcctSchema as, MJournalBatch journalBatch, MElementValue sourceAccount) {
        MJournal journal = new MJournal(journalBatch);
        if (journal == null) {
            return false;
        }
        journal.setC_Currency_ID(as.getC_Currency_ID());
        journal.setC_AcctSchema_ID(as.get_ID());
        journal.setC_ConversionType_ID(114);
        journal.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Year-end Closing Integral - ") + sourceAccount.getValue() + " " + sourceAccount.getName());
        journal.setDocumentNo(DB.getDocumentNo(this.getAD_Client_ID(), "GL_Journal", this.get_TrxName()));
        journal.setGL_Category_ID(this.getCategoryId());
        journal.saveEx();
        if (!this.createLinesDetailed(journal, sourceAccount).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean createLines(MJournal journal, MElementValue sourceAccount, BigDecimal balance) {
        if (balance.signum() == 0) {
            return true;
        }
        MJournalLine debit = new MJournalLine(journal);
        MJournalLine credit = new MJournalLine(journal);
        if (sourceAccount.getAccountType().equals("R")) {
            debit.setAccount_ID(sourceAccount.getC_ElementValue_ID());
            debit.setAmtSourceDr(balance.negate());
            debit.setDescription(sourceAccount.getName());
            debit.saveEx();
            credit.setAccount_ID(this.getTargetAccountId());
            credit.setAmtSourceCr(balance.negate());
            credit.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Target"));
            credit.saveEx();
        } else {
            credit.setAccount_ID(sourceAccount.getC_ElementValue_ID());
            credit.setAmtSourceCr(balance);
            credit.setDescription(sourceAccount.getName());
            credit.saveEx();
            debit.setAccount_ID(this.getTargetAccountId());
            debit.setAmtSourceDr(balance);
            debit.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Target"));
            debit.saveEx();
        }
        return true;
    }

    private Boolean createLinesDetailed(MJournal journal, MElementValue sourceAccount) {
        String sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            sql = "select c_bpartner_id, c_currency_id, sum(amtacctdr - amtacctcr) as balance from fact_acct where dateacct between Firstof('" + this.getDateAcct() + "',  'YY') and '" + this.getDateAcct() + "' and ad_client_id = " + Env.getAD_Client_ID(this.getCtx()) + " and ad_org_id = " + this.getOrgId() + " and account_id  = " + sourceAccount.getC_ElementValue_ID() + " and postingtype = 'A' group by c_bpartner_id, c_currency_id order by c_bpartner_id, c_currency_id";
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal balance = rs.getBigDecimal("balance");
                int partnerID = rs.getInt("c_bpartner_id");
                int currencyID = rs.getInt("c_currency_id");
                MJournalLine debit = new MJournalLine(journal);
                MJournalLine credit = new MJournalLine(journal);
                credit.setAccount_ID(sourceAccount.getC_ElementValue_ID());
                credit.setAmtSourceCr(balance);
                credit.setDescription(sourceAccount.getName());
                credit.setC_BPartner_ID(partnerID);
                credit.setC_Currency_ID(currencyID);
                credit.saveEx();
                debit.setAccount_ID(this.getTargetAccountId());
                debit.setAmtSourceDr(balance);
                debit.setC_Currency_ID(currencyID);
                debit.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Target"));
                debit.saveEx();
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return true;
    }

    private Boolean createLineFromAcct(MJournal journal, MElementValue sourceAccount, BigDecimal amtDR, BigDecimal amtCR, int currencyID, int partnerID) {
        MJournalLine line = new MJournalLine(journal);
        line.setAccount_ID(sourceAccount.getC_ElementValue_ID());
        line.setDescription(sourceAccount.getName());
        line.setAmtSourceDr(amtCR);
        line.setAmtSourceCr(amtDR);
        line.setC_Currency_ID(currencyID);
        line.setC_BPartner_ID(partnerID);
        line.saveEx();
        return true;
    }

    private BigDecimal searchBalance(int cElementvalueID) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(this.getDateAcct());
        parameters.add(this.getDateAcct());
        parameters.add(Env.getAD_Client_ID(this.getCtx()));
        parameters.add(cElementvalueID);
        String whereClause = " DATEACCT between Firstof(?,  'YY') AND ?  AND AD_CLIENT_ID = ? AND ACCOUNT_ID = ? AND PostingType = 'A' AND AD_Org_ID = " + this.getOrgId();
        BigDecimal balance = new Query(this.getCtx(), "Fact_Acct", whereClause, this.get_TrxName()).setParameters(parameters).aggregate("amtacctdr - amtacctcr", "SUM");
        return balance;
    }
}

