/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MElementValue;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.utils.DataUtilities;

public class RCtbMayorContableRV
extends SvrProcess {
    private Timestamp fechaDesde = null;
    private Timestamp fechaHasta = null;
    private int periodID = 0;
    private int idCuenta = 0;
    private String cuentaDesde = "";
    private String cuentaHasta = "";
    private String conSaldoInicial = "Y";
    private int adUserID = 0;
    private int adClientID = 0;
    private int adOrgID = 0;
    private int partnerID = 0;
    private int productID = 0;
    private int cAcctSchemaID = 0;
    private int budgetID = 0;
    private String postingType = "";
    private String idReporte = "";
    private static final String TABLA_MOLDE = "UY_Molde_RCtbMayorContableRV";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("DateTrx")) {
                this.fechaDesde = (Timestamp)para[i].getParameter();
                this.fechaHasta = (Timestamp)para[i].getParameter_To();
            }
            if (name.equalsIgnoreCase("C_ElementValue_ID") && para[i].getParameter() != null) {
                this.idCuenta = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("valorcuenta")) {
                this.cuentaDesde = (String)para[i].getParameter();
                this.cuentaHasta = (String)para[i].getParameter_To();
            }
            if (name.equalsIgnoreCase("IsSaldoInicial")) {
                this.conSaldoInicial = (String)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("AD_User_ID")) {
                this.adUserID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_Client_ID")) {
                this.adClientID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_Org_ID")) {
                this.adOrgID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("M_Product_ID") && para[i].getParameter() != null) {
                this.productID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_AcctSchema_ID") && para[i].getParameter() != null) {
                this.cAcctSchemaID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_Period_ID") && para[i].getParameter() != null) {
                this.periodID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_BPartner_ID") && para[i].getParameter() != null) {
                this.partnerID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("GL_Budget_ID") && para[i].getParameter() != null) {
                this.budgetID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (!name.equalsIgnoreCase("PostingType") || para[i].getParameter() == null) continue;
            this.postingType = (String)para[i].getParameter();
        }
        this.idReporte = DataUtilities.getReportID(new Long(this.adUserID));
    }

    @Override
    protected String doIt() throws Exception {
        this.deleteInstanciasViejasReporte();
        this.loadMovimientos();
        this.calculoSaldos();
        this.deleteBasuraTemporal();
        return "ok";
    }

    private void deleteInstanciasViejasReporte() {
        String sql = "";
        try {
            sql = "DELETE FROM UY_Molde_RCtbMayorContableRV WHERE ad_user_id =" + this.adUserID;
            DB.executeUpdateEx(sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private void deleteBasuraTemporal() {
        String sql = "";
        try {
            sql = "DELETE FROM UY_Molde_RCtbMayorContableRV WHERE idreporte ='" + this.idReporte + "' AND debe=0  AND haber=0 ";
            DB.executeUpdateEx(sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private void loadMovimientos() {
        String insert = "";
        String sql = "";
        String whereFiltros = "";
        try {
            insert = "INSERT INTO UY_Molde_RCtbMayorContableRV (ad_client_id, ad_org_id, idreporte, ad_user_id, c_elementvalue_id, valorcuenta, nombrecuenta, fecreporte, datetrx,  c_doctype_id, docname, documentno, idasiento, record_id, descasiento, observaciones, idmonedaasiento, idmonedacuenta,  imporigen, saldoinicial, debe, haber, amtsourcedr, amtsourcecr, saldoperiodo, saldoacumulado, gl_budget_id, postingtype, c_project_id, c_bpartner_id, nombresocionegocio, ad_table_id,  nomtabla, fact_acct_id, m_product_id, c_period_id, issaldoinicial, c_acctschema_id, line_id) ";
            if (this.adOrgID > 0) {
                whereFiltros = " AND f.ad_org_id=" + this.adOrgID;
            }
            if (this.idCuenta > 0) {
                MElementValue ev = new MElementValue(this.getCtx(), this.idCuenta, null);
                whereFiltros = whereFiltros + " AND cta.value='" + ev.getValue() + "' ";
            }
            if (this.cuentaDesde != null && !this.cuentaDesde.equalsIgnoreCase("")) {
                whereFiltros = whereFiltros + " AND cta.value >='" + this.cuentaDesde + "' ";
            }
            if (this.cuentaHasta != null && !this.cuentaHasta.equalsIgnoreCase("")) {
                whereFiltros = whereFiltros + " AND cta.value <='" + this.cuentaHasta + "' ";
            }
            if (this.fechaDesde != null) {
                whereFiltros = whereFiltros + " AND f.dateacct >= '" + this.fechaDesde + "'";
            }
            if (this.fechaHasta != null) {
                whereFiltros = whereFiltros + " AND f.dateacct <= '" + this.fechaHasta + "'";
            }
            if (this.periodID > 0) {
                whereFiltros = whereFiltros + " AND f.c_period_id=" + this.periodID;
            }
            if (this.partnerID > 0) {
                whereFiltros = whereFiltros + " AND f.c_bpartner_id =" + this.partnerID;
            }
            if (this.productID > 0) {
                whereFiltros = whereFiltros + " AND f.m_product_id =" + this.productID;
            }
            if (this.budgetID > 0) {
                whereFiltros = whereFiltros + " AND f.gl_budget_id =" + this.budgetID;
            }
            if (this.postingType != null && !this.postingType.equalsIgnoreCase("")) {
                whereFiltros = whereFiltros + " AND f.postingtype = '" + this.postingType + "'";
            }
            sql = "SELECT f.ad_client_id, f.ad_org_id, '" + this.idReporte + "'," + this.adUserID + ", f.account_id, cta.value, cta.name, current_date, f.dateacct, 0, '', '0', f.record_id, f.record_id, f.description, '', f.c_currency_id, f.c_currency_id, 0, 0, f.amtacctdr, f.amtacctcr, f.amtsourcedr, f.amtsourcecr, 0, 0, f.gl_budget_id, f.postingtype, f.c_project_id, f.c_bpartner_id, coalesce(bp.name,'') as bpname, f.ad_table_id, tab.tablename, f.fact_acct_id, coalesce(f.m_product_id,0) as m_product_id, f.c_period_id, '" + this.conSaldoInicial + "', " + this.cAcctSchemaID + ", coalesce(f.line_id,0) as line_id FROM rv_fact_acct f INNER JOIN ad_table tab ON f.ad_table_id = tab.ad_table_id  INNER JOIN c_elementvalue cta ON f.account_id = cta.c_elementvalue_id  LEFT OUTER JOIN c_bpartner bp ON f.c_bpartner_id = bp.c_bpartner_id  WHERE f.ad_client_id =" + this.adClientID + " AND f.c_acctschema_id = " + this.cAcctSchemaID + whereFiltros;
            this.log.log(Level.INFO, insert + sql);
            DB.executeUpdateEx(insert + sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private void calculoSaldos() {
        String sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            BigDecimal saldoPeriodo = new BigDecimal(0);
            BigDecimal saldoAcumulado = new BigDecimal(0);
            BigDecimal saldoInicial = new BigDecimal(0);
            String valorcuenta = "";
            sql = "SELECT *  FROM UY_Molde_RCtbMayorContableRV WHERE idreporte=? ORDER BY valorcuenta, datetrx, idasiento, ad_table_id, fact_acct_id, c_bpartner_id ASC ";
            pstmt = DB.prepareStatement(sql, 1004, 1007, null);
            pstmt.setString(1, this.idReporte);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String valorCuentaAux = rs.getString("valorcuenta");
                if (!valorCuentaAux.equalsIgnoreCase(valorcuenta)) {
                    if (this.conSaldoInicial.equalsIgnoreCase("Y")) {
                        saldoInicial = this.getSaldoInicial(rs.getInt("c_elementvalue_id"));
                        this.updateSaldoInicial(saldoInicial, rs.getInt("c_elementvalue_id"));
                        saldoAcumulado = saldoAcumulado.add(saldoInicial);
                    } else {
                        saldoInicial = Env.ZERO;
                    }
                    saldoAcumulado = saldoInicial;
                    saldoPeriodo = Env.ZERO;
                    valorcuenta = valorCuentaAux;
                }
                if (rs.getBigDecimal("debe").doubleValue() != 0.0) {
                    saldoPeriodo = saldoPeriodo.add(rs.getBigDecimal("debe"));
                    saldoAcumulado = saldoAcumulado.add(rs.getBigDecimal("debe"));
                }
                if (rs.getBigDecimal("haber").doubleValue() != 0.0) {
                    saldoPeriodo = saldoPeriodo.subtract(rs.getBigDecimal("haber"));
                    saldoAcumulado = saldoAcumulado.subtract(rs.getBigDecimal("haber"));
                }
                this.updateDatosRegistro(rs.getInt("c_elementvalue_id"), rs.getTimestamp("datetrx"), rs.getInt("idasiento"), rs.getInt("ad_table_id"), saldoPeriodo, saldoAcumulado, rs.getString("nombresocionegocio"), rs.getInt("fact_acct_id"));
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void updateSaldoInicial(BigDecimal valor, int idCuenta) {
        String sql = "";
        try {
            sql = "UPDATE UY_Molde_RCtbMayorContableRV SET saldoinicial = " + valor + " WHERE idreporte='" + this.idReporte + "' AND c_elementvalue_id =" + idCuenta;
            DB.executeUpdate(sql, null);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
    }

    private void updateDatosRegistro(int idCuenta, Timestamp fechaDoc, int idAsiento, int idTabla, BigDecimal saldoPeriodo, BigDecimal saldoAcumulado, String nomSocioNeg, int factAcctID) {
        String sql = "";
        try {
            sql = "UPDATE UY_Molde_RCtbMayorContableRV SET saldoperiodo = " + saldoPeriodo + ",  saldoacumulado =" + saldoAcumulado + " WHERE idreporte='" + this.idReporte + "' AND c_elementvalue_id =" + idCuenta + " AND datetrx = '" + fechaDoc + "' AND idasiento =" + idAsiento + " AND ad_table_id =" + idTabla + " AND fact_acct_id =" + factAcctID;
            System.out.println(sql);
            DB.executeUpdateEx(sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private BigDecimal getSaldoInicial(int idCuenta) {
        String sql = "";
        String where = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        BigDecimal value = new BigDecimal(0);
        MPeriod period = null;
        try {
            if (this.fechaDesde == null && this.periodID == 0) {
                BigDecimal bigDecimal = Env.ZERO;
                return bigDecimal;
            }
            if (this.fechaDesde != null) {
                where = where + " AND a.dateacct < '" + this.fechaDesde + "'";
            }
            if (this.periodID > 0) {
                period = new MPeriod(this.getCtx(), this.periodID, null);
                where = where + " AND a.dateacct < '" + period.getStartDate() + "'";
            }
            if (this.partnerID > 0) {
                where = where + " AND a.c_bpartner_id = " + this.partnerID;
            }
            if (this.productID > 0) {
                where = where + " AND a.m_product_id = " + this.productID;
            }
            if (this.budgetID > 0) {
                where = where + " AND a.gl_budget_id = " + this.budgetID;
            }
            if (!this.postingType.equalsIgnoreCase("")) {
                where = where + " AND a.postingtype = '" + this.postingType + "'";
            }
            if ((rs = (pstmt = DB.prepareStatement(sql = "SELECT COALESCE(SUM(a.amtacctdr - a.amtacctcr),0) as saldo  FROM fact_acct a  WHERE a.ad_client_id = " + this.adClientID + " AND a.ad_org_id = " + this.adOrgID + " AND a.account_id = " + idCuenta + " AND a.c_acctschema_id = " + this.cAcctSchemaID + where, null)).executeQuery()).next()) {
                value = rs.getBigDecimal("saldo");
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return value;
    }
}

