/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.utils.DataUtilities;

public class RBankAccountStatus
extends SvrProcess {
    private Timestamp fechaDesde = null;
    private Timestamp fechaHasta = null;
    private int accountID = 0;
    private boolean isreconciled = false;
    private int userID = 0;
    private int clientID = 0;
    private int orgID = 0;
    private String idReporte = "";
    private static final String TABLA_MOLDE = "UY_Molde_BankAccountStatus";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("DateTrx")) {
                this.fechaDesde = (Timestamp)para[i].getParameter();
                this.fechaHasta = (Timestamp)para[i].getParameter_To();
            }
            if (name.equalsIgnoreCase("C_BankAccount_ID") && para[i].getParameter() != null) {
                this.accountID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("IsReconciled")) {
                boolean bl = this.isreconciled = ((String)para[i].getParameter()).equalsIgnoreCase("Y");
            }
            if (name.equalsIgnoreCase("AD_User_ID")) {
                this.userID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_Client_ID")) {
                this.clientID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (!name.equalsIgnoreCase("AD_Org_ID")) continue;
            this.orgID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
        this.idReporte = DataUtilities.getReportID(new Long(this.userID));
    }

    @Override
    protected String doIt() throws Exception {
        this.deleteInstanciasViejasReporte();
        this.getData();
        this.updateData();
        return "OK";
    }

    private void deleteInstanciasViejasReporte() {
        String sql = "";
        try {
            sql = "DELETE FROM UY_Molde_BankAccountStatus WHERE ad_user_id = " + this.userID;
            DB.executeUpdateEx(sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private void getData() throws Exception {
        String insert = "";
        String sql = "";
        String whereFiltros = "";
        try {
            if (this.orgID > 0) {
                whereFiltros = " AND ad_org_id=" + this.orgID;
            }
            if (this.accountID > 0) {
                whereFiltros = whereFiltros + " AND c_bankaccount_id = " + this.accountID;
            }
            if (this.fechaDesde != null) {
                whereFiltros = whereFiltros + " AND datetrx >= '" + this.fechaDesde + "'";
            }
            if (this.fechaHasta != null) {
                whereFiltros = whereFiltros + " AND datetrx <= '" + this.fechaHasta + "'";
            }
            insert = "INSERT INTO UY_Molde_BankAccountStatus (ad_client_id, ad_org_id, ad_user_id, idreporte, fecreporte, datetrx, saldoinicial, saldoacumulado, c_payment_id, dateacct, isreceipt, c_doctype_id, c_bankaccount_id, c_bpartner_id, c_invoice_id, c_currency_id, description, c_project_id, c_campaign_id, isapproved, isreconciled, isoverunderpayment, isallocated, isprepayment, c_order_id, payamt, discountamt, writeoffamt, taxamt, overunderamt, multiplierap, created)";
            sql = " SELECT " + this.clientID + "," + this.orgID + "," + this.userID + ",'" + this.idReporte + "',current_date, datetrx,0,0,c_payment_id,dateacct,isreceipt,c_doctype_id,c_bankaccount_id,c_bpartner_id, c_invoice_id,c_currency_id,description,c_project_id,c_campaign_id,isapproved,isreconciled, isoverunderpayment,isallocated,isprepayment,c_order_id, CASE isreceipt WHEN 'Y' THEN payamt ELSE payamt * (-1) END AS payamt, CASE isreceipt WHEN 'Y' THEN discountamt ELSE discountamt * (-1) END AS discountamt, CASE isreceipt WHEN 'Y' THEN writeoffamt ELSE writeoffamt * (-1) END AS writeoffamt, CASE isreceipt WHEN 'Y' THEN taxamt ELSE taxamt * (-1) END AS taxamt, CASE isreceipt WHEN 'Y' THEN overunderamt ELSE overunderamt * (-1) END AS overunderamt, CASE isreceipt WHEN 'Y' THEN 1 ELSE (-1) END AS multiplierap, created FROM c_payment where docstatus = 'CO' AND payamt <> 0 AND isreconciled = '" + (this.isreconciled ? "Y" : "N") + "'" + whereFiltros + " Order by c_bankaccount_id, datetrx, created, c_payment_id";
            DB.executeUpdateEx(insert + sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    private void updateData() throws Exception {
        CPreparedStatement pstmt;
        ResultSet rs;
        block8: {
            String sql = "";
            rs = null;
            pstmt = null;
            sql = " SELECT *  FROM UY_Molde_BankAccountStatus WHERE idreporte='" + this.idReporte + "' ORDER BY c_bankaccount_id, datetrx, created, c_payment_id";
            pstmt = DB.prepareStatement(sql, 1004, 1007, null);
            rs = pstmt.executeQuery();
            rs.last();
            int totalRowCount = rs.getRow();
            boolean rowCount = false;
            rs.beforeFirst();
            if (totalRowCount > 0) break block8;
            this.updateSoloConSaldoInicial();
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return;
        }
        try {
            String action = "";
            BigDecimal saldoAcumulado = Env.ZERO;
            BigDecimal saldoInicial = Env.ZERO;
            BigDecimal payAmt = Env.ZERO;
            int cBankAccountID = 0;
            int cBankAccountIDAux = 0;
            int paymentID = 0;
            while (rs.next()) {
                paymentID = rs.getInt("c_payment_id");
                cBankAccountIDAux = rs.getInt("c_bankaccount_id");
                payAmt = rs.getBigDecimal("payamt");
                if (cBankAccountIDAux != cBankAccountID) {
                    cBankAccountID = cBankAccountIDAux;
                    saldoAcumulado = saldoInicial = this.getSaldoInicial(cBankAccountID);
                }
                if (payAmt.compareTo(Env.ZERO) != 0) {
                    saldoAcumulado = saldoAcumulado.add(payAmt);
                }
                action = " UPDATE UY_Molde_BankAccountStatus SET saldoacumulado =" + saldoAcumulado + ", saldoinicial = " + saldoInicial + " WHERE idreporte ='" + this.idReporte + "' AND c_payment_id =" + paymentID;
                DB.executeUpdateEx(action, null);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private BigDecimal getSaldoInicial(int idCuenta) {
        String sql = "";
        BigDecimal value = Env.ZERO;
        sql = "select coalesce(sum(payamt),0) from c_payment where docstatus = 'CO' and isreceipt = 'Y' and isreconciled = '" + (this.isreconciled ? "Y" : "N") + "' and datetrx < '" + this.fechaDesde + "' and c_bankaccount_id = " + idCuenta;
        BigDecimal amtReceipt = DB.getSQLValueBDEx(this.get_TrxName(), sql, new Object[0]);
        sql = "select coalesce(sum(payamt),0) from c_payment where docstatus = 'CO' and isreceipt = 'N' and isreconciled = '" + (this.isreconciled ? "Y" : "N") + "' and datetrx < '" + this.fechaDesde + "' and c_bankaccount_id = " + idCuenta;
        BigDecimal amtPayment = DB.getSQLValueBDEx(this.get_TrxName(), sql, new Object[0]);
        value = amtReceipt.subtract(amtPayment);
        return value;
    }

    private void updateSoloConSaldoInicial() throws Exception {
        String sql = "";
        String insert = "";
        String select = "";
        String whereFiltros = "";
        String isReconciled = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        int accountID = 0;
        BigDecimal saldoInicial = Env.ZERO;
        try {
            if (this.accountID > 0) {
                whereFiltros = whereFiltros + " AND c_bankaccount_id = " + this.accountID;
            }
            isReconciled = this.isreconciled ? "Y" : "N";
            sql = "select c_bankaccount_id from c_bankaccount where isactive = 'Y'" + whereFiltros + " order by c_bank_id, c_currency_id, description";
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                accountID = rs.getInt("C_BankAccount_ID");
                saldoInicial = this.getSaldoInicial(accountID);
                insert = "INSERT INTO UY_Molde_BankAccountStatus (ad_client_id, ad_org_id, ad_user_id, idreporte, fecreporte, saldoinicial, saldoacumulado, c_bankaccount_id,datetrx,isreconciled)";
                select = " SELECT " + this.clientID + "," + this.orgID + "," + this.userID + ",'" + this.idReporte + "',current_date," + saldoInicial + "," + saldoInicial + "," + accountID + ",'" + this.fechaDesde + "','" + isReconciled + "'";
                DB.executeUpdateEx(insert + select, null);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }
}

