/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class ProcessDeferredCheck
extends SvrProcess {
    private int docTargetID = 0;
    private Timestamp dateTrx = null;
    private int bankAccountID = 0;
    private int docID = 0;
    private boolean isFirst = true;
    private boolean isSOTrx = true;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_DocType_ID")) {
                    this.docTargetID = para[i].getParameterAsInt();
                    continue;
                }
                if (name.equals("DateTrx")) {
                    this.dateTrx = para[i].getParameterAsTimestamp();
                    continue;
                }
                if (!name.equals("C_BankAccount_ID")) continue;
                this.bankAccountID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        List<Integer> recordIds = this.getSelectionKeys();
        Timestamp date = TimeUtil.trunc(this.dateTrx, "D");
        recordIds.stream().forEach(key -> {
            String message = null;
            MInvoice inv = new MInvoice(this.getCtx(), (int)key, this.get_TrxName());
            if (this.isFirst) {
                this.isSOTrx = this.getSelectionAsBoolean((int)key, "DEF_IsSOTrx");
                this.isFirst = false;
            }
            MPayment payHdr = new MPayment(this.getCtx(), 0, this.get_TrxName());
            payHdr.setC_DocType_ID(this.docTargetID);
            payHdr.setDateTrx(date);
            payHdr.setDateAcct(date);
            payHdr.setC_BPartner_ID(inv.getC_BPartner_ID());
            payHdr.setC_Invoice_ID(inv.get_ID());
            payHdr.setPayAmt(inv.getGrandTotal());
            payHdr.setC_Currency_ID(inv.getC_Currency_ID());
            payHdr.setTenderType("A");
            if (this.isSOTrx) {
                if (this.bankAccountID <= 0) throw new AdempiereException("Debe indicar cuenta bancaria destino");
                MBankAccount ba = new MBankAccount(this.getCtx(), this.bankAccountID, this.get_TrxName());
                if (ba.getC_Currency_ID() != inv.getC_Currency_ID()) throw new AdempiereException("Moneda del cheque y moneda de la cuenta bancaria destino deben ser iguales");
                payHdr.setC_BankAccount_ID(this.bankAccountID);
            } else {
                String sql = "select c_bankaccount_id from c_doctype where c_doctype_id = " + inv.getC_DocTypeTarget_ID();
                int accountID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
                payHdr.setC_BankAccount_ID(accountID);
            }
            payHdr.setDocStatus("DR");
            payHdr.setDocAction("CO");
            payHdr.saveEx();
            if (!payHdr.processIt("CO")) {
                message = payHdr.getProcessMsg();
                throw new AdempiereException(message);
            }
            payHdr.saveEx();
        });
        return "OK";
    }
}

