/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.process.PRCreateFromInvoiceAbstract;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceipt;
import org.openup.core.model.MUYPayReceiptDoc;

public class PRCreateFromInvoice
extends PRCreateFromInvoiceAbstract {
    private MUYPayReceipt pay = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() == 0) {
            return "";
        }
        this.pay = new MUYPayReceipt(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        return this.loadInvoice();
    }

    private String loadInvoice() {
        List<Integer> recordIds = this.getSelectionKeys();
        recordIds.stream().forEach(key -> {
            MInvoice inv = new MInvoice(this.getCtx(), (int)key, this.get_TrxName());
            MDocType doc = new MDocType(this.getCtx(), inv.getC_DocTypeTarget_ID(), this.get_TrxName());
            BigDecimal multiplier = Env.ONE;
            if (this.pay.isSOTrx() && !inv.isSOTrx() || !this.pay.isSOTrx() && inv.isSOTrx()) {
                multiplier = multiplier.negate();
            }
            if (this.pay.isSOTrx() && doc.getDocBaseType().equalsIgnoreCase("APC") || !this.pay.isSOTrx() && doc.getDocBaseType().equalsIgnoreCase("ARC")) {
                throw new AdempiereException("Tipo de documento no permitido");
            }
            MUYPayReceiptDoc lineDoc = new MUYPayReceiptDoc(this.getCtx(), 0, this.get_TrxName());
            lineDoc.setUY_PayReceipt_ID(this.pay.get_ID());
            lineDoc.setC_BPartner_ID(inv.getC_BPartner_ID());
            lineDoc.setC_Invoice_ID(inv.get_ID());
            lineDoc.setInvoiceAmt(inv.getGrandTotal().multiply(multiplier));
            lineDoc.setAmtSource(inv.getGrandTotal().multiply(multiplier));
            lineDoc.setPayAmt(this.getSelectionAsBigDecimal((int)key, "INV_PayAmt").multiply(multiplier));
            lineDoc.setOpenAmt(this.getSelectionAsBigDecimal((int)key, "INV_OpenAmt").multiply(multiplier));
            lineDoc.setC_InvoicePaySchedule_ID(this.getSelectionAsInt((int)key, "INV_C_InvoicePaySchedule_ID"));
            lineDoc.setDiscountAmt(this.getSelectionAsBigDecimal((int)key, "INV_DiscountAmt"));
            lineDoc.setPaymentRule(this.getSelectionAsString((int)key, "INV_PaymentRule"));
            String sql = "select ad_table_id from ad_table where lower(tablename) like 'luy_document'";
            int tableID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
            if (tableID > 0) {
                sql = "select coalesce(cferepimpressa,'') from luy_document where ad_table_id = " + MInvoice.Table_ID + " and record_id = " + inv.get_ID() + " and cfestatus = 2";
                String value = DB.getSQLValueStringEx(this.get_TrxName(), sql, new Object[0]);
                if (value != null && !value.equalsIgnoreCase("")) {
                    lineDoc.set_ValueOfColumn("CFERepImpressa", (Object)value);
                }
            }
            lineDoc.saveEx();
        });
        return "OK";
    }
}

