/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MDocType;
import org.compiere.model.MPayment;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceipt;
import org.openup.core.model.MUYPayReceiptLine;

public class GeneratePayment
extends SvrProcess {
    private MUYPayReceipt hdr = null;
    private int currencyID = 0;
    private int accountID = 0;
    private int chargeID = 0;
    String payRule = null;
    String checkNo = null;
    BigDecimal payAmt = Env.ZERO;
    BigDecimal difAmt = Env.ZERO;
    private boolean IsRepresentation = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("C_Currency_ID") && para[i].getParameter() != null) {
                this.currencyID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_BankAccount_ID") && para[i].getParameter() != null) {
                this.accountID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_Charge_ID") && para[i].getParameter() != null) {
                this.chargeID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("PaymentRule") && para[i].getParameter() != null) {
                this.payRule = para[i].getParameter().toString();
            }
            if (name.equalsIgnoreCase("CheckNo") && para[i].getParameter() != null) {
                this.checkNo = para[i].getParameter().toString();
            }
            if (name.equalsIgnoreCase("PayAmt") && para[i].getParameter() != null) {
                this.payAmt = (BigDecimal)para[i].getParameter();
            }
            if (!name.equalsIgnoreCase("DifferenceAmt") || para[i].getParameter() == null) continue;
            this.difAmt = (BigDecimal)para[i].getParameter();
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.payAmt.compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("Importe debe ser mayor a cero");
        }
        if (this.payRule.equalsIgnoreCase("S") && (this.checkNo == null || this.checkNo.equalsIgnoreCase(""))) {
            throw new AdempiereException("Debe ingresar numero de documento para regla de pago Cheque");
        }
        if (this.getRecord_ID() == 0) {
            return "";
        }
        this.hdr = new MUYPayReceipt(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.hdr.get_ValueAsBoolean("IsRepresentation")) {
            this.IsRepresentation = true;
        }
        if (this.hdr.isSOTrx() && this.IsRepresentation) {
            if (this.hdr.getLinesGen("").size() > 0) {
                throw new AdempiereException("Ya hay cobros generados para este documento");
            }
            if (this.hdr.getLinesDef().size() > 0) {
                throw new AdempiereException("Ya hay cheques diferidos generados para este documento, no se permiten diferentes medios de pago");
            }
            if (this.payAmt.compareTo(this.hdr.getAmtToAllocate()) != 0) {
                throw new AdempiereException("Importe cobrado debe ser igual al monto total a afectar");
            }
        }
        if (this.hdr.isSOTrx() && this.IsRepresentation) {
            this.generatePaymentRep();
        } else {
            this.generatePayment(this.hdr.getC_BPartner_ID(), this.payAmt);
        }
        return "OK";
    }

    private String generatePaymentRep() {
        String sql = "";
        Object message = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            sql = "select c_bpartner_id, sum(invoiceamt) as amount from uy_payreceiptdoc where uy_payreceipt_id = " + this.hdr.get_ID() + " group by c_bpartner_id, invoiceamt";
            pstmt = DB.prepareStatement(sql, this.hdr.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.generatePayment(rs.getInt("c_bpartner_id"), rs.getBigDecimal("amount"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "OK";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generatePayment(int partnerID, BigDecimal amount) {
        if (this.payRule.equalsIgnoreCase("B")) {
            if (MSysConfig.getBooleanValue("RECEIPT_GENERATE_CASH", true, this.getAD_Client_ID())) {
                int docID = 0;
                Object doc = null;
                MPayment cash = new MPayment(this.getCtx(), 0, this.get_TrxName());
                if (this.hdr.isSOTrx()) {
                    docID = MDocType.getDocType("ARR", " AND IsDocNoControlled = 'N'");
                    cash.setDescription("Generado desde recibo de cobro Nro. '" + this.hdr.getDocumentNo() + "'");
                    cash.setIsReceipt(true);
                } else {
                    docID = MDocType.getDocType("APP", " AND IsDocNoControlled = 'N'");
                    cash.setDescription("Generado desde recibo de pago Nro. '" + this.hdr.getDocumentNo() + "'");
                    cash.setIsReceipt(false);
                }
                if (docID > 0) {
                    cash.setC_DocType_ID(docID);
                }
                cash.setC_BankAccount_ID(this.accountID);
                cash.setDateTrx(this.hdr.getDateDoc());
                cash.setDateAcct(this.hdr.getDateDoc());
                cash.setC_BPartner_ID(partnerID);
                cash.setPayAmt(amount);
                cash.setC_Currency_ID(this.currencyID);
                cash.setTenderType("X");
                if (this.chargeID > 0) {
                    cash.setC_Charge_ID(this.chargeID);
                }
                if (this.hdr.get_ValueAsBoolean("IsPrepayment")) {
                    cash.setIsPrepayment(true);
                }
                if (this.hdr.get_ValueAsInt("C_Project_ID") > 0) {
                    cash.setC_Project_ID(this.hdr.get_ValueAsInt("C_Project_ID"));
                }
                cash.setDocStatus("DR");
                cash.setDocAction("CO");
                cash.set_ValueOfColumn("UY_PayReceipt_ID", (Object)this.hdr.get_ID());
                cash.saveEx();
                MUYPayReceiptLine line = new MUYPayReceiptLine(this.getCtx(), 0, this.get_TrxName());
                line.setUY_PayReceipt_ID(this.hdr.get_ID());
                line.setC_BPartner_ID(partnerID);
                line.setC_Payment_ID(cash.get_ID());
                line.setPaymentRule(this.payRule);
                line.setC_BankAccount_ID(this.accountID);
                line.setPayAmt(amount);
                line.setC_Currency_ID(this.currencyID);
                line.saveEx();
                return "OK";
            } else {
                MCash cash = MCash.get(this.getCtx(), this.hdr.getAD_Org_ID(), this.hdr.getDateDoc(), this.currencyID, this.get_TrxName());
                if (cash == null || cash.get_ID() <= 0) throw new AdempiereException("No se pudo obtener Diario de Caja Chica para la fecha y moneda del documento");
                if (!cash.getDocStatus().equalsIgnoreCase("DR")) throw new AdempiereException("El Diario de Caja actual no esta en estado borrador");
                MCashLine cl = new MCashLine(cash);
                if (this.hdr.isSOTrx()) {
                    cl.setCashType("R");
                    cl.setDescription("Generado desde recibo de cobro Nro. '" + this.hdr.getDocumentNo() + "'");
                } else {
                    cl.setCashType("E");
                    cl.setDescription("Generado desde recibo de pago Nro. '" + this.hdr.getDocumentNo() + "'");
                }
                cl.setC_Currency_ID(this.currencyID);
                cl.setAmount(amount);
                cl.setDiscountAmt(Env.ZERO);
                cl.setWriteOffAmt(Env.ZERO);
                cl.setIsGenerated(true);
                cl.saveEx();
                MUYPayReceiptLine line = new MUYPayReceiptLine(this.getCtx(), 0, this.get_TrxName());
                line.setUY_PayReceipt_ID(this.hdr.get_ID());
                line.setC_BPartner_ID(this.hdr.getC_BPartner_ID());
                line.setC_CashLine_ID(cl.get_ID());
                line.setPaymentRule(this.payRule);
                line.setC_BankAccount_ID(this.accountID);
                line.setPayAmt(amount);
                line.saveEx();
            }
            return "OK";
        } else {
            if (!this.payRule.equalsIgnoreCase("S") && !this.payRule.equalsIgnoreCase("T")) return "OK";
            int docID = 0;
            if (this.hdr.isSOTrx()) {
                docID = MDocType.getDocType("ARR");
            } else {
                String sql = "select c_doctype_id from c_doctype where docbasetype = 'APP' and isdocnocontrolled = 'N' and ad_client_id = " + this.hdr.getAD_Client_ID();
                docID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
            }
            MPayment pay = new MPayment(this.getCtx(), 0, this.get_TrxName());
            pay.setC_DocType_ID(docID);
            pay.setDateTrx(this.hdr.getDateDoc());
            pay.setDateAcct(this.hdr.getDateDoc());
            pay.setC_BankAccount_ID(this.accountID);
            pay.setC_BPartner_ID(partnerID);
            pay.setC_Currency_ID(this.currencyID);
            pay.setPayAmt(amount);
            if (this.chargeID > 0) {
                pay.setC_Charge_ID(this.chargeID);
            }
            if (this.payRule.equalsIgnoreCase("S")) {
                pay.setTenderType("K");
                if (this.checkNo != null) {
                    pay.setCheckNo(this.checkNo);
                }
            }
            if (this.payRule.equalsIgnoreCase("T")) {
                pay.setTenderType("A");
            }
            if (this.hdr.isSOTrx()) {
                pay.setDescription("Generado desde recibo de cobro Nro. '" + this.hdr.getDocumentNo() + "'");
                pay.setIsReceipt(true);
            } else {
                pay.setDescription("Generado desde recibo de pago Nro. '" + this.hdr.getDocumentNo() + "'");
                pay.setIsReceipt(false);
            }
            if (this.hdr.get_ValueAsBoolean("IsPrepayment")) {
                pay.setIsPrepayment(true);
            }
            if (this.hdr.get_ValueAsInt("C_Project_ID") > 0) {
                pay.setC_Project_ID(this.hdr.get_ValueAsInt("C_Project_ID"));
            }
            pay.setDocStatus("DR");
            pay.setDocAction("CO");
            pay.setC_ConversionType_ID(114);
            pay.setWriteOffAmt(this.difAmt);
            pay.set_ValueOfColumn("UY_PayReceipt_ID", (Object)this.hdr.get_ID());
            pay.saveEx();
            MUYPayReceiptLine line = new MUYPayReceiptLine(this.getCtx(), 0, this.get_TrxName());
            line.setUY_PayReceipt_ID(this.hdr.get_ID());
            line.setC_BPartner_ID(partnerID);
            line.setC_Payment_ID(pay.get_ID());
            line.setPaymentRule(this.payRule);
            line.setC_BankAccount_ID(this.accountID);
            line.setPayAmt(amount);
            line.setC_Currency_ID(this.currencyID);
            line.saveEx();
        }
        return "OK";
    }
}

