/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceipt;
import org.openup.core.model.MUYPayReceiptDef;
import org.openup.core.model.MUYPayReceiptDoc;

public class GenerateDeferredDoc
extends SvrProcess {
    private MUYPayReceipt pay = null;
    private Timestamp dateTrx = null;
    private Timestamp dueDate = null;
    private int docTypeID = 0;
    private int vendorID = 0;
    private int currencyID = 0;
    private int bankID = 0;
    private int chargeID = 0;
    private int chargeID2 = 0;
    String docNo = null;
    BigDecimal amount = Env.ZERO;
    private boolean IsRepresentation = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("DateTrx")) {
                this.dateTrx = (Timestamp)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("DueDate")) {
                this.dueDate = (Timestamp)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("C_Currency_ID") && para[i].getParameter() != null) {
                this.currencyID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_Bank_ID") && para[i].getParameter() != null) {
                this.bankID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_Charge_ID") && para[i].getParameter() != null) {
                this.chargeID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_Charge_ID_2") && para[i].getParameter() != null) {
                this.chargeID2 = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("DocumentNo") && para[i].getParameter() != null) {
                this.docNo = para[i].getParameter().toString();
            }
            if (name.equalsIgnoreCase("Amount") && para[i].getParameter() != null) {
                this.amount = (BigDecimal)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("C_DocTypeTarget_ID") && para[i].getParameter() != null) {
                this.docTypeID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (!name.equalsIgnoreCase("C_BPartner_ID") || para[i].getParameter() == null) continue;
            this.vendorID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
    }

    @Override
    protected String doIt() throws Exception {
        String message = null;
        if (this.amount.compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("Importe debe ser mayor a cero");
        }
        if (this.dueDate.compareTo(this.dateTrx) < 0) {
            throw new AdempiereException("Fecha de vencimiento no puede ser menor a fecha de emision");
        }
        if (this.getRecord_ID() > 0) {
            this.pay = new MUYPayReceipt(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            if (this.pay.get_ValueAsBoolean("IsRepresentation")) {
                this.IsRepresentation = true;
            }
            if (this.pay.isSOTrx() && this.IsRepresentation) {
                if (this.pay.getLinesDef().size() > 0) {
                    throw new AdempiereException("Ya hay cheque diferido generado para este documento");
                }
                if (this.pay.getLinesGen("").size() > 0) {
                    throw new AdempiereException("Ya hay cobros generados para este documento, no se permiten diferentes medios de pago");
                }
                if (this.amount.compareTo(this.pay.getAmtToAllocate()) != 0) {
                    throw new AdempiereException("Importe de cheque debe ser igual al monto total a afectar");
                }
            }
            message = this.generateDocCustomer();
        } else {
            message = this.generateDocVendor();
        }
        return message;
    }

    private String generateDocCustomer() {
        String message = null;
        MCurrency cur = new MCurrency(this.getCtx(), this.currencyID, this.get_TrxName());
        MInvoice hdr = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        int docID = MDocType.getDocType("DRI");
        if (docID == 0) {
            throw new AdempiereException("No se obtuvo tipo de documento 'Cheque Diferido Tercero'");
        }
        hdr.setC_DocTypeTarget_ID(docID);
        hdr.setC_DocType_ID(docID);
        hdr.setDocumentNo(this.docNo);
        hdr.setDateInvoiced(this.dateTrx);
        hdr.setDateAcct(this.dateTrx);
        hdr.setC_BPartner_ID(this.pay.getC_BPartner_ID());
        hdr.setC_Currency_ID(this.currencyID);
        hdr.setTotalLines(this.amount);
        hdr.setGrandTotal(this.amount);
        hdr.setInvoiceCollectionType("K");
        hdr.setC_PaymentTerm_ID(MPaymentTerm.getPaymentTermByDefault(this.getCtx(), this.get_TrxName()).get_ID());
        hdr.setPaymentRule("S");
        hdr.setDescription("Generado desde recibo de cobro Nro. '" + this.pay.getDocumentNo() + "'");
        hdr.setDocStatus("DR");
        hdr.setDocAction("CO");
        hdr.set_ValueOfColumn("UY_PayReceipt_ID", (Object)this.pay.get_ID());
        MPriceList list = MPriceList.getDefault(this.getCtx(), true, cur.getISO_Code());
        if (list == null) {
            throw new AdempiereException("No se obtuvo lista de precios de venta en " + cur.getISO_Code());
        }
        hdr.setM_PriceList_ID(list.get_ID());
        String sql = "select c_bpartner_location_id from c_bpartner_location where isbillto = 'Y' and c_bpartner_id = " + this.pay.getC_BPartner_ID();
        int locID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        if (locID <= 0) {
            throw new AdempiereException("No se obtuvo localizacion para el socio de negocio");
        }
        hdr.setC_BPartner_Location_ID(locID);
        hdr.saveEx();
        MInvoiceLine line = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
        line.setC_Invoice_ID(hdr.get_ID());
        line.setLine(0);
        line.setC_Charge_ID(this.chargeID);
        line.setQtyEntered(Env.ONE);
        line.setQtyInvoiced(Env.ONE);
        line.setPriceEntered(this.amount);
        line.setPriceActual(this.amount);
        line.setLineNetAmt(this.amount);
        line.setLineTotalAmt(this.amount);
        line.saveEx();
        MInvoicePaySchedule schedule = new MInvoicePaySchedule(this.getCtx(), 0, this.get_TrxName());
        schedule.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
        schedule.setC_Invoice_ID(hdr.get_ID());
        schedule.setDueAmt(this.amount);
        schedule.setDueDate(this.dueDate);
        schedule.setDiscountDate(this.dueDate);
        schedule.saveEx();
        hdr.validatePaySchedule();
        if (!hdr.processIt("CO")) {
            message = hdr.getProcessMsg();
            throw new AdempiereException(message);
        }
        MUYPayReceiptDef lineDef = new MUYPayReceiptDef(this.getCtx(), 0, this.get_TrxName());
        lineDef.setUY_PayReceipt_ID(this.pay.get_ID());
        line.setLine(0);
        lineDef.setC_Invoice_ID(hdr.get_ID());
        lineDef.setC_BPartner_ID(hdr.getC_BPartner_ID());
        lineDef.setDueDate(this.dueDate);
        lineDef.setPaymentRule(hdr.getPaymentRule());
        lineDef.setAmtSource(this.amount);
        lineDef.setC_Currency_ID(this.currencyID);
        if (this.chargeID2 > 0) {
            lineDef.setC_Charge_ID(this.chargeID2);
        }
        lineDef.saveEx();
        if (!this.pay.get_ValueAsBoolean("IsRepresentation")) {
            sql = "select i.c_invoice_id from c_invoice i join c_doctype d on i.c_doctypetarget_id = d.c_doctype_id where i.ref_invoice_id = " + hdr.get_ID() + " and d.docbasetype = 'DRC' and i.docstatus = 'CO'";
            int ncID = DB.getSQLValueEx(hdr.get_TrxName(), sql, new Object[0]);
            if (ncID > 0) {
                MInvoice nc = new MInvoice(this.getCtx(), ncID, this.get_TrxName());
                MUYPayReceiptDoc lineDoc = new MUYPayReceiptDoc(this.getCtx(), 0, this.get_TrxName());
                lineDoc.setUY_PayReceipt_ID(this.pay.get_ID());
                lineDoc.setC_BPartner_ID(nc.getC_BPartner_ID());
                lineDoc.setC_Invoice_ID(nc.get_ID());
                lineDoc.setC_Currency_ID(nc.getC_Currency_ID());
                lineDoc.setInvoiceAmt(nc.getGrandTotal());
                lineDoc.setAmtSource(nc.getGrandTotal());
                lineDoc.setPayAmt(nc.getGrandTotal());
                lineDoc.setOpenAmt(nc.getGrandTotal());
                lineDoc.setPaymentRule(nc.getPaymentRule());
                if (this.chargeID2 > 0) {
                    lineDoc.setC_Charge_ID(this.chargeID2);
                }
                lineDoc.setIsSelected(false);
                lineDoc.saveEx();
            } else {
                throw new AdempiereException("No se obtuvo Nota de Credito Diferida Tercero para el cheque diferido nro. '" + hdr.getDocumentNo() + "'");
            }
        }
        message = "Cheque generado: " + hdr.getDocumentNo() + " - " + cur.getISO_Code() + " " + hdr.getGrandTotal();
        return message;
    }

    private String generateDocVendor() {
        String message = null;
        MDocType doc = new MDocType(this.getCtx(), this.docTypeID, this.get_TrxName());
        MBankAccount account = new MBankAccount(this.getCtx(), doc.get_ValueAsInt("C_BankAccount_ID"), this.get_TrxName());
        MCurrency cur = (MCurrency)account.getC_Currency();
        MInvoice hdr = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        hdr.setC_DocTypeTarget_ID(this.docTypeID);
        hdr.setC_DocType_ID(this.docTypeID);
        hdr.setDocumentNo(this.docNo);
        hdr.setDateInvoiced(this.dateTrx);
        hdr.setDateAcct(this.dateTrx);
        hdr.setC_BPartner_ID(this.vendorID);
        if (this.currencyID != cur.getC_Currency_ID()) {
            this.currencyID = cur.getC_Currency_ID();
        }
        hdr.setC_Currency_ID(this.currencyID);
        hdr.setTotalLines(this.amount);
        hdr.setGrandTotal(this.amount);
        hdr.setIsSOTrx(false);
        hdr.setC_PaymentTerm_ID(MPaymentTerm.getPaymentTermByDefault(this.getCtx(), this.get_TrxName()).get_ID());
        hdr.setPaymentRule("S");
        MPriceList list = MPriceList.getDefault(this.getCtx(), false, cur.getISO_Code());
        if (list == null) {
            throw new AdempiereException("No se obtuvo lista de precios de compra en " + cur.getISO_Code());
        }
        hdr.setM_PriceList_ID(list.get_ID());
        String sql = "select c_bpartner_location_id from c_bpartner_location where isbillto = 'Y' and c_bpartner_id = " + this.vendorID;
        int locID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        if (locID <= 0) {
            throw new AdempiereException("No se obtuvo localizacion para el socio de negocio");
        }
        hdr.setC_BPartner_Location_ID(locID);
        hdr.setDocStatus("DR");
        hdr.setDocAction("CO");
        hdr.saveEx();
        MInvoiceLine line = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
        line.setC_Invoice_ID(hdr.get_ID());
        line.setLine(0);
        line.setC_Charge_ID(this.chargeID);
        line.setQtyEntered(Env.ONE);
        line.setQtyInvoiced(Env.ONE);
        line.setPriceEntered(this.amount);
        line.setPriceActual(this.amount);
        line.setLineNetAmt(this.amount);
        line.setLineTotalAmt(this.amount);
        line.saveEx();
        MInvoicePaySchedule schedule = new MInvoicePaySchedule(this.getCtx(), 0, this.get_TrxName());
        schedule.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
        schedule.setC_Invoice_ID(hdr.get_ID());
        schedule.setDueAmt(this.amount);
        schedule.setDueDate(this.dueDate);
        schedule.setDiscountDate(this.dueDate);
        schedule.saveEx();
        hdr.validatePaySchedule();
        if (!hdr.processIt("CO")) {
            message = hdr.getProcessMsg();
            throw new AdempiereException(message);
        }
        message = "Cheque generado: " + hdr.getDocumentNo() + " - " + cur.getISO_Code() + " " + hdr.getGrandTotal();
        return message;
    }
}

