/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProject;
import org.compiere.model.X_C_Order;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateCutOrderFromProject
extends SvrProcess {
    private boolean p_IsDropShip = false;
    private MProject project = null;
    private int partnerID = 0;
    private String style = "";
    private int cutOrderOk = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name.isEmpty()) continue;
            if (name.equalsIgnoreCase("C_BPartner_ID")) {
                if (para[i].getParameter() == null) continue;
                this.partnerID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (!name.equalsIgnoreCase("Style") || para[i].getParameter() == null) continue;
            this.style = para[i].getParameterAsString();
        }
        if (this.style != null && !this.style.equalsIgnoreCase("")) {
            this.style = this.style.toUpperCase().trim();
        }
        this.project = new MProject(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        this.checkProductPrice();
        this.updatePricesPO();
        this.createCuttingOrders();
        this.addLog(0, null, new BigDecimal(this.cutOrderOk), " Cutting Orders Generated");
        return "";
    }

    private void checkProductPrice() {
        String sql = "";
        String where = "";
        if (this.partnerID > 0) {
            where = where + " and ppo.c_bpartner_id = " + this.partnerID;
        }
        if (this.style != null && !this.style.equalsIgnoreCase("")) {
            where = where + " and trim(upper(p.group1)) like '" + this.style + "'";
        }
        sql = "select count(pl.c_projectline_id) from c_projectline pl inner join m_product p on pl.m_product_id = p.m_product_id left join m_product_po ppo on pl.m_product_id = ppo.m_product_id where (ppo.pricepo <= 0 or ppo.pricelist <= 0 or not exists (select m_product_id from m_product_po where m_product_id = pl.m_product_id)) and pl.c_project_id = " + this.project.get_ID() + where;
        int count = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        if (count > 0) {
            throw new AdempiereException("Error: There are products without a FOB Price");
        }
    }

    private void updatePricesPO() {
        String sql = "";
        String where = "";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        MCurrency currency = (MCurrency)this.project.getC_Currency();
        MPriceList list = MPriceList.getDefault(this.getCtx(), false, currency.getISO_Code());
        if (list == null) {
            throw new AdempiereException("Error: No default purchase price list was obtained for the currency " + currency.getISO_Code());
        }
        if (this.partnerID > 0) {
            where = where + " and ppo.c_bpartner_id = " + this.partnerID;
        }
        if (this.style != null && !this.style.equalsIgnoreCase("")) {
            where = where + " and trim(upper(p.group1)) like '" + this.style + "'";
        }
        sql = "select pl.m_product_id, ppo.pricepo, ppo.pricelist from c_projectline pl inner join m_product p on pl.m_product_id = p.m_product_id inner join m_product_po ppo on (pl.m_product_id = ppo.m_product_id and ppo.iscurrentvendor = 'Y') where pl.c_project_id = " + this.project.get_ID() + where;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MProduct prod = new MProduct(this.getCtx(), rs.getInt("M_Product_ID"), this.get_TrxName());
                this.checkPriceListVendor(list, prod, rs.getBigDecimal("PricePO"), rs.getBigDecimal("PriceList"));
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private void checkPriceListVendor(MPriceList list, MProduct prod, BigDecimal pricePO, BigDecimal priceList) {
        int[] plvIds;
        if (pricePO != null && priceList != null && (plvIds = MPriceListVersion.getAllIDs("M_PriceList_Version", " M_PriceList_ID = " + list.get_ID() + " AND IsActive='Y' ", prod.get_TrxName())).length > 0 && plvIds[0] > 0) {
            MProductPrice ppc = MProductPrice.get(this.getCtx(), plvIds[0], prod.get_ID(), this.get_TrxName());
            if (ppc != null && ppc.get_ID() > 0) {
                ppc.setPriceList(priceList);
                ppc.setPriceLimit(pricePO);
                ppc.setPriceStd(pricePO);
                ppc.saveEx();
            } else {
                ppc = new MProductPrice(this.getCtx(), plvIds[0], prod.get_ID(), priceList, pricePO, pricePO, this.get_TrxName());
                ppc.saveEx();
            }
        }
    }

    private void createPriceLVerPurchase(MProject pr, MProduct prod, int partner_id, BigDecimal pricePO, BigDecimal priceList) {
        MBPartner prov;
        if (pricePO != null && partner_id > 0 && partner_id > 0 && (prov = new MBPartner(this.getCtx(), partner_id, this.get_TrxName())) != null && prov.getPO_PriceList_ID() > 0) {
            int[] plvIds = null;
            if (prov.getPO_PriceList_ID() > 0) {
                plvIds = MPriceListVersion.getAllIDs("M_PriceList_Version", " M_PriceList_ID = " + prov.getPO_PriceList_ID() + " AND IsActive='Y' ", this.get_TrxName());
            } else if (prov.getC_BP_Group_ID() > 0 && prov.getBPGroup().getPO_PriceList_ID() > 0) {
                plvIds = MPriceListVersion.getAllIDs("M_PriceList_Version", " M_PriceList_ID = " + prov.getBPGroup().getPO_PriceList_ID() + " AND IsActive='Y' ", this.get_TrxName());
            }
            if (plvIds.length > 0 && plvIds[0] > 0) {
                MProductPrice ppc = MProductPrice.get(this.getCtx(), (int)plvIds[0], prod.get_ID(), this.get_TrxName());
                if (ppc != null && ppc.get_ID() > 0) {
                    ppc.setPriceList(priceList);
                    ppc.setPriceLimit(pricePO);
                    ppc.setPriceStd(pricePO);
                    ppc.saveEx();
                } else {
                    ppc = new MProductPrice(this.getCtx(), plvIds[0], prod.get_ID(), priceList, pricePO, pricePO, this.get_TrxName());
                    ppc.saveEx();
                }
            }
        }
    }

    private void createCuttingOrders() throws Exception {
        List<String> processList = this.getProcessList();
        for (int i = 0; i <= processList.size() - 1; ++i) {
            this.cutOrderOk += this.createPOFromSO(processList.get(i), this.get_TrxName());
        }
    }

    protected List<String> getProcessList() {
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        String prod_name = "";
        String lines = "";
        String where = "";
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (this.partnerID > 0) {
                where = where + " and ppo.c_bpartner_id = " + this.partnerID;
            }
            if (this.style != null && !this.style.equalsIgnoreCase("")) {
                where = where + " and trim(upper(p.group1)) like '" + this.style + "'";
            }
            String sql = "select l.c_orderline_id, p.group1 from c_order o join c_orderline l on o.c_order_id = l.c_order_id join m_product p on l.m_product_id = p.m_product_id join m_product_po ppo on p.m_product_id = ppo.m_product_id where o.isactive = 'Y' and o.docstatus NOT IN ('VO','RE') and o.issotrx = 'Y' and not exists (select ol.c_orderline_id from c_orderline ol inner join c_order h on ol.c_order_id = h.c_order_id where ol.link_orderline_id = l.c_orderline_id and h.issotrx = 'N' and h.docstatus not in ('VO', 'RE')) and o.c_project_id = " + this.project.get_ID() + where + " order by p.group1";
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int lineID = rs.getInt("C_OrderLine_ID");
                String prodName = rs.getString("group1");
                if (!prod_name.equalsIgnoreCase(prodName)) {
                    if (lines != null && !lines.isEmpty()) {
                        list.add(lines);
                    }
                    lines = "";
                    prod_name = prodName;
                    lines = lines + lineID;
                    continue;
                }
                lines = lines + "," + lineID;
            }
            if (lines != null && !lines.isEmpty()) {
                list.add(lines);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return list;
    }

    protected int createPOFromSO(String lines, String trx) throws Exception {
        int counter = 0;
        String sql = "SELECT MIN(po.C_BPartner_ID), po.M_Product_ID, ol.c_orderline_id, ol.c_order_id, po.pricepo, po.pricelist, po.ref_bpartner_id FROM M_Product_PO po INNER JOIN C_OrderLine ol ON (po.M_Product_ID=ol.M_Product_ID) WHERE po.IsCurrentVendor='Y' AND po.IsActive = 'Y' AND po.Discontinued = 'N'" + (this.partnerID > 0 ? " AND po.C_BPartner_ID=? " : "") + " AND ol.c_orderline_id IN (" + lines + ") GROUP BY po.M_Product_ID, ol.c_orderline_id, po.pricepo, po.pricelist, po.ref_bpartner_id  ORDER BY 1";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        X_C_Order po = null;
        MOrder so = null;
        try {
            pstmt = DB.prepareStatement(sql, trx);
            if (this.partnerID != 0) {
                pstmt.setInt(1, this.partnerID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal cmtPrice;
                BigDecimal pricePO;
                if (so == null) {
                    so = new MOrder(Env.getCtx(), rs.getInt("C_Order_ID"), trx);
                }
                int C_BPartner_ID = rs.getInt(1);
                if (po == null || po.getBill_BPartner_ID() != C_BPartner_ID) {
                    po = this.createPOForVendor(rs.getInt(1), so);
                    po.setSalesRep_ID(so.getSalesRep_ID());
                    po.saveEx();
                    this.addLog(0, null, null, po.getDocumentNo());
                    ++counter;
                }
                MOrderLine oLine = new MOrderLine(Env.getCtx(), rs.getInt("C_OrderLine_ID"), trx);
                int M_Product_ID = rs.getInt(2);
                if (oLine.getM_Product_ID() != M_Product_ID) continue;
                MOrderLine poLine = new MOrderLine((MOrder)po);
                poLine.setLink_OrderLine_ID(oLine.getC_OrderLine_ID());
                poLine.setM_Product_ID(oLine.getM_Product_ID());
                poLine.setC_Charge_ID(oLine.getC_Charge_ID());
                poLine.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
                poLine.setC_UOM_ID(oLine.getC_UOM_ID());
                poLine.setQtyEntered(oLine.getQtyEntered());
                poLine.setQtyOrdered(oLine.getQtyOrdered());
                poLine.setDescription(oLine.getDescription());
                poLine.set_ValueOfColumn("C_SubscriptionType_ID", oLine.get_Value("C_SubscriptionType_ID"));
                if (oLine.getDatePromised() != null) {
                    String sql2 = "SELECT '" + oLine.getDatePromised() + "'::timestamp - CAST('15 days' AS INTERVAL)";
                    Timestamp date = DB.getSQLValueTSEx(trx, sql2, new Object[0]);
                    poLine.setDatePromised(date);
                }
                if ((pricePO = rs.getBigDecimal("PricePO")).compareTo(Env.ZERO) <= 0) {
                    MProduct prod = new MProduct(this.getCtx(), oLine.getM_Product_ID(), this.get_TrxName());
                    throw new AdempiereException("No FOB Price was found for product " + prod.getName() + " in the current project");
                }
                poLine.setPriceEntered(pricePO);
                poLine.setPriceActual(pricePO);
                sql = "select coalesce(costamt, 0) from c_projectline where c_project_id = " + this.project.get_ID() + " and m_product_id = " + oLine.getM_Product_ID();
                BigDecimal fabricCost = DB.getSQLValueBDEx(this.get_TrxName(), sql, new Object[0]);
                if (fabricCost.compareTo(Env.ZERO) > 0) {
                    poLine.setPriceCost(fabricCost);
                }
                if ((cmtPrice = rs.getBigDecimal("PriceList")).compareTo(Env.ZERO) > 0) {
                    poLine.setPriceList(cmtPrice);
                }
                poLine.saveEx();
                oLine.setLink_OrderLine_ID(poLine.getC_OrderLine_ID());
                oLine.saveEx();
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (counter == 1 && po != null) {
            String update = "update c_order set link_order_id = " + po.get_ID() + " where c_order_id in (select distinct (c_order_id) from c_orderline where c_orderline_id in (" + lines + "))";
            DB.executeUpdateEx(update, trx);
            String sql2 = "select max (o.datepromised) from c_order o inner join c_orderline l on o.c_order_id = l.c_order_id where l.c_orderline_id in (" + lines + ")";
            Timestamp datePromised = DB.getSQLValueTSEx(trx, sql2, new Object[0]);
            String sql3 = "SELECT '" + datePromised + "'::timestamp - CAST('15 days' AS INTERVAL)";
            Timestamp date = DB.getSQLValueTSEx(trx, sql3, new Object[0]);
            update = "update c_order set datepromised = '" + date + "' where c_order_id = " + po.get_ID();
            DB.executeUpdateEx(update, trx);
        }
        return counter;
    }

    public MOrder createPOForVendor(int C_BPartner_ID, MOrder so) {
        MOrder po = new MOrder(this.getCtx(), 0, so.get_TrxName());
        po.setClientOrg(so.getAD_Client_ID(), so.getAD_Org_ID());
        po.setLink_Order_ID(so.getC_Order_ID());
        po.setIsSOTrx(false);
        po.setC_DocTypeTarget_ID();
        po.setDescription(so.getDescription());
        po.setPOReference(so.getDocumentNo());
        po.setPriorityRule(so.getPriorityRule());
        po.setSalesRep_ID(so.getSalesRep_ID());
        po.setM_Warehouse_ID(so.getM_Warehouse_ID());
        MBPartner vendor = new MBPartner(this.getCtx(), C_BPartner_ID, so.get_TrxName());
        po.setBPartner(vendor);
        if (po.getC_PaymentTerm_ID() <= 0) {
            MPaymentTerm pt = MPaymentTerm.getPaymentTermByDefault(this.getCtx(), this.get_TrxName());
            if (pt != null && pt.get_ID() > 0) {
                po.setC_PaymentTerm_ID(pt.get_ID());
            } else {
                throw new AdempiereException("No default payment term was obtained");
            }
        }
        if (this.p_IsDropShip) {
            po.setIsDropShip(this.p_IsDropShip);
            if (so.isDropShip() && so.getDropShip_BPartner_ID() != 0) {
                po.setDropShip_BPartner_ID(so.getDropShip_BPartner_ID());
                po.setDropShip_Location_ID(so.getDropShip_Location_ID());
                po.setDropShip_User_ID(so.getDropShip_User_ID());
            } else {
                po.setDropShip_BPartner_ID(so.getC_BPartner_ID());
                po.setDropShip_Location_ID(so.getC_BPartner_Location_ID());
                po.setDropShip_User_ID(so.getAD_User_ID());
            }
            MOrgInfo orginfo = MOrgInfo.get(this.getCtx(), po.getAD_Org_ID(), so.get_TrxName());
            if (orginfo.getDropShip_Warehouse_ID() != 0) {
                po.setM_Warehouse_ID(orginfo.getDropShip_Warehouse_ID());
            } else {
                this.log.log(Level.SEVERE, "Must specify drop ship warehouse in org info.");
            }
        }
        po.setC_Activity_ID(so.getC_Activity_ID());
        po.setC_Campaign_ID(so.getC_Campaign_ID());
        po.setC_Project_ID(so.getC_Project_ID());
        po.setUser1_ID(so.getUser1_ID());
        po.setUser2_ID(so.getUser2_ID());
        po.setUser3_ID(so.getUser3_ID());
        po.setUser4_ID(so.getUser4_ID());
        MCurrency currency = (MCurrency)so.getC_Currency();
        MPriceList list = MPriceList.getDefault(this.getCtx(), false, currency.getISO_Code());
        po.setM_PriceList_ID(list.get_ID());
        po.saveEx();
        return po;
    }
}

