/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class GenerateCheckDebit
extends SvrProcess {
    private MClient client = null;
    private MOrg org = null;
    private Timestamp date = null;
    private int userID = Env.getAD_User_ID(Env.getCtx());

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null || !name.equalsIgnoreCase("DateTrx")) continue;
            this.date = (Timestamp)para[i].getParameter();
        }
        this.date = this.date != null ? TimeUtil.trunc(this.date, "D") : TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        if (this.userID == 0) {
            this.userID = 100;
        }
        this.client = this.getDefaultClient();
        Env.setContext(this.getCtx(), "AD_Client_ID", this.client.get_ID());
    }

    @Override
    protected String doIt() throws Exception {
        String sql = "select c_doctype_id from c_doctype where docbasetype = 'DRP'";
        int docTypeID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        if (docTypeID <= 0) {
            throw new AdempiereException("No se obtuvo tipo de documento 'Debito Cheque Diferido'");
        }
        this.generateData(docTypeID);
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateData(int docID) {
        MPayment hdr = null;
        boolean isFirst = true;
        String sql = "";
        String message = null;
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        MAcctSchema schema = this.client.getAcctSchema();
        try {
            sql = "SELECT i.c_invoice_id, i.dateinvoiced, i.c_currency_id, date_trunc('day'::text, s.duedate) AS duedate, i.ad_client_id, i.ad_org_id FROM c_invoice i JOIN c_invoicepayschedule s ON s.c_invoice_id = i.c_invoice_id JOIN c_doctype d ON i.c_doctypetarget_id = d.c_doctype_id WHERE i.docstatus IN ('CO','CL') AND i.ispaid = 'N' AND s.isvalid = 'Y' AND d.docbasetype = 'DPI' AND i.invoicecollectiontype = 'E' AND duedate <= '" + this.date + "'";
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal rate;
                MInvoice invoice = new MInvoice(this.getCtx(), rs.getInt("C_Invoice_ID"), this.get_TrxName());
                Timestamp dateInvoiced = rs.getTimestamp("DateInvoiced");
                Timestamp dueDate = rs.getTimestamp("DueDate");
                int currencyID = rs.getInt("C_Currency_ID");
                int clientID = rs.getInt("AD_Client_ID");
                int orgID = rs.getInt("AD_Org_ID");
                boolean rateOK = true;
                if (currencyID != schema.getC_Currency_ID() && ((rate = MConversionRate.getRate(currencyID, schema.getC_Currency_ID(), dueDate, 114, clientID, orgID)) == null || rate.compareTo(Env.ZERO) <= 0)) {
                    rateOK = false;
                }
                if (dueDate.compareTo(dateInvoiced) < 0 || !MPeriod.isOpen(Env.getCtx(), dueDate, "DRP", orgID) || !rateOK) continue;
                hdr = new MPayment(this.getCtx(), 0, this.get_TrxName());
                hdr.set_ValueOfColumn("AD_Client_ID", (Object)clientID);
                hdr.setAD_Org_ID(orgID);
                hdr.setC_DocType_ID(docID);
                hdr.setDocumentNo(invoice.getDocumentNo());
                hdr.setC_Invoice_ID(invoice.get_ID());
                hdr.setDateTrx(dueDate);
                hdr.setDateAcct(dueDate);
                hdr.setPayAmt(invoice.getGrandTotal());
                hdr.setC_BPartner_ID(invoice.getC_BPartner_ID());
                hdr.setC_Currency_ID(invoice.getC_Currency_ID());
                hdr.setIsReceipt(false);
                hdr.setDescription("GENERADO AUTOMATICAMENTE");
                MDocType doc = (MDocType)invoice.getC_DocTypeTarget();
                hdr.setC_BankAccount_ID(doc.get_ValueAsInt("C_BankAccount_ID"));
                hdr.saveEx();
                if (!hdr.processIt("CO")) {
                    message = hdr.getProcessMsg();
                    throw new AdempiereException(message);
                }
                hdr.saveEx();
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private MClient getDefaultClient() {
        String whereClause = "AD_Client_ID >= 1000000";
        MClient value = (MClient)new Query(this.getCtx(), "AD_Client", whereClause, null).first();
        return value;
    }

    private MOrg getDefaultOrg() {
        String whereClause = "AD_Org_ID >= 1000000";
        MOrg value = (MOrg)new Query(this.getCtx(), "AD_Org", whereClause, null).first();
        return value;
    }
}

