/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProject;
import org.compiere.model.PO;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_M_AttributeSetInstance;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.openup.core.model.MProductAuxiliar;
import org.openup.core.process.CreateSalesOrderProjectAbstract;
import org.openup.core.process.OrderPOCreateForProject;

public class CreateSalesOrderProject
extends CreateSalesOrderProjectAbstract {
    private static String ERROR_MGE_OV = "FALTA INDICAR CANTIDAD EN ALGUNA MEDIDA";
    private static String ERROR_MGE_OC_PROV = "FALTA INDICAR PROVEEDOR";
    private static String ERROR_MGE_OC_PRICEPO = "FALTA INDICAR PRECIO DE FABRICACION";
    private static String COLNAME_POSITION = "size";
    private static String IMPORT_TABLE = "I_ProductAuxiliar";
    private static String TABLE_AUX = "aux_prodpos";
    private static String DATAOK = "DataOK";
    private int iAuxiliarProductID = 0;
    private MProductAuxiliar lineFrom = null;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private int m_SaleOrder_ID = 0;
    private int m_PurchaseOrder_ID = 0;
    private String m_Version = "";
    private int salesOrderOk = 0;
    private int salesOrderCompleteOk = 0;
    private int purhaseOrderOk = 0;
    private String mgeErrorOC = "";
    private String m_whereClause = " ";

    private void setM_whereClause(String aux) {
        this.m_whereClause = aux;
    }

    private String getM_whereClause() {
        if (this.m_whereClause.isEmpty()) {
            this.setM_whereClause("  WHERE IsActive = 'Y' AND IsValid = 'Y' AND I_IsImported = 'Y' ");
        }
        if (!this.m_whereClause.contains("version") && !this.m_Version.isEmpty()) {
            this.m_whereClause = this.m_whereClause + " AND trim(version)='" + this.m_Version.trim() + "' ";
        }
        if (!this.m_whereClause.contains("AD_Org_ID") && this.m_AD_Org_ID != 0) {
            this.m_whereClause = this.m_whereClause + " AND AD_Org_ID = " + this.m_AD_Org_ID;
        }
        if (!this.m_whereClause.contains("AD_Client_ID") && this.m_AD_Client_ID != 0) {
            this.m_whereClause = this.m_whereClause + " AND AD_Client_ID = " + this.m_AD_Client_ID;
        }
        return this.m_whereClause;
    }

    @Override
    protected void prepare() {
        super.prepare();
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name.isEmpty()) continue;
            if (name.equalsIgnoreCase("I_ProductAuxiliar_ID")) {
                this.iAuxiliarProductID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (name.equalsIgnoreCase("C_Order_ID")) {
                if (para[i].getParameter() == null) continue;
                this.m_SaleOrder_ID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (name.equalsIgnoreCase("C_OrderPO_ID")) {
                if (para[i].getParameter() == null) continue;
                this.m_PurchaseOrder_ID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (!name.equalsIgnoreCase("Version")) continue;
            this.m_Version = para[i].getParameterAsString();
        }
        if (this.m_Version.isEmpty()) {
            throw new AdempiereException("Registro no procesado en carga inicial");
        }
        if (Env.getAD_Client_ID(this.getCtx()) == 0) {
            throw new AdempiereException("No se permite correr con cliente 0");
        }
        this.m_AD_Client_ID = this.getAD_Client_ID();
        this.setM_whereClause("");
    }

    @Override
    protected String doIt() throws Exception {
        block7: {
            String retorno = "";
            try {
                this.lineFrom = new MProductAuxiliar(this.getCtx(), this.iAuxiliarProductID, this.get_TrxName());
                if (this.lineFrom.get_ID() == 0) {
                    throw new AdempiereException("No se puede obtener datos de la linea");
                }
                if (this.m_SaleOrder_ID == 0) {
                    System.out.println("Se comienza con la creaci\u00f3n de ordenes de venta");
                    this.reloadErrorsIProductAuxiliar(this.getM_whereClause() + " AND (C_Order_ID IS NULL OR C_Order_ID=0)");
                    this.loadDataToTableAuxiliar();
                    this.controllQtyPerSize();
                    this.controllDataTOProcess(TABLE_AUX, " WHERE " + DATAOK + " = 'Y' ", "No se procesaron Ordenes de Venta, verifique errores");
                    this.processSO(TABLE_AUX);
                    this.addLog(0, null, new BigDecimal(this.salesOrderOk), "-Orden de Ventas creadas");
                    break block7;
                }
                if (this.lineFrom.isCreatePO() & this.m_PurchaseOrder_ID == 0) {
                    this.verifyDataPO();
                    this.loadPrevDataPO();
                    this.createMasivePurchaseOrder();
                    if (this.purhaseOrderOk > 0) {
                        this.addLog(0, null, new BigDecimal(this.purhaseOrderOk), "-Orden de Compras creadas");
                    } else {
                        this.addLog(0, null, new BigDecimal(this.purhaseOrderOk), this.mgeErrorOC);
                    }
                    break block7;
                }
                return "Existe Ordende venta y compra para este registro";
            }
            catch (AdempiereException e) {
                this.dropTableAuxiliay(this.get_TrxName());
                throw new AdempiereException(e.getMessage());
            }
        }
        this.dropTableAuxiliay(this.get_TrxName());
        return "";
    }

    private void verifyDataPO() {
        if (this.iAuxiliarProductID > 0) {
            MProductAuxiliar aux = new MProductAuxiliar(this.getCtx(), this.iAuxiliarProductID, this.get_TrxName());
            String sql = "select count(i_productauxiliar_id) from i_productauxiliar where c_project_id = " + aux.getC_Project_ID() + " and isactive = 'Y' and i_isimported = 'Y' and (c_bpartner_2_id is null or pricepo <= 0 or pricelist <= 0)";
            int count = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
            if (count > 0) {
                throw new AdempiereException("Missing data to generate the cutting orders, check the fields 'Garment Supplier', 'FOB Price' and 'CMT Price'");
            }
        }
    }

    private void loadPrevDataPO() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int versionID = 0;
        MPriceList list = MPriceList.getDefault(this.getCtx(), false, "USD");
        if (list != null) {
            Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
            String sql = "SELECT max (M_PriceList_Version_ID) FROM M_PriceList_Version WHERE M_PriceList_Version.isActive = 'Y' AND M_PriceList_Version.M_PriceList_ID = " + list.get_ID() + " AND validFrom <= '" + today + "'";
            versionID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
            if (versionID <= 0) {
                throw new AdempiereException("No current list price version was obtained for the list " + list.getName());
            }
        } else {
            throw new AdempiereException("No predetermined purchase price list was obtained in USD");
        }
        String sql = "SELECT * FROM " + IMPORT_TABLE + this.getM_whereClause() + " ORDER BY C_Project_ID,C_BPartner_ID,DeliveryTime_Promised,M_Product_ID";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MProductAuxiliar aux = new MProductAuxiliar(this.getCtx(), rs.getInt("i_productauxiliar_id"), this.get_TrxName());
                MProject pr = (MProject)aux.getC_Project();
                MProduct prod = (MProduct)aux.getM_Product();
                if (aux.getM_Product_ID() > 0) {
                    this.createPriceLVerPurchase(pr, prod, aux.getC_BPartner_2_ID(), (BigDecimal)aux.get_Value("PricePO"), aux.getPriceList());
                    this.createMProductPO(aux.getC_BPartner_2_ID(), prod, (BigDecimal)aux.get_Value("PricePO"), pr.getC_Currency_ID(), aux.getPriceList());
                    continue;
                }
                throw new AdempiereException("The product could not be obtained");
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private void createPriceLVerPurchase(MProject pr, MProduct prod, int c_bPartner_2_id, BigDecimal pricePO, BigDecimal priceList) {
        MBPartner prov;
        if (pricePO != null && c_bPartner_2_id > 0 && c_bPartner_2_id > 0 && (prov = new MBPartner(this.getCtx(), c_bPartner_2_id, this.get_TrxName())) != null && prov.getPO_PriceList_ID() > 0) {
            int[] plvIds = null;
            if (prov.getPO_PriceList_ID() > 0) {
                plvIds = MPriceListVersion.getAllIDs("M_PriceList_Version", " M_PriceList_ID = " + prov.getPO_PriceList_ID() + " AND IsActive='Y' ", this.get_TrxName());
            } else if (prov.getC_BP_Group_ID() > 0 && prov.getBPGroup().getPO_PriceList_ID() > 0) {
                plvIds = MPriceListVersion.getAllIDs("M_PriceList_Version", " M_PriceList_ID = " + prov.getBPGroup().getPO_PriceList_ID() + " AND IsActive='Y' ", this.get_TrxName());
            }
            if (plvIds.length > 0 && plvIds[0] > 0) {
                MProductPrice ppc = MProductPrice.get(this.getCtx(), (int)plvIds[0], prod.get_ID(), this.get_TrxName());
                if (ppc != null && ppc.get_ID() > 0) {
                    ppc.setPriceList(priceList);
                    ppc.setPriceLimit(pricePO);
                    ppc.setPriceStd(pricePO);
                    ppc.saveEx();
                } else {
                    ppc = new MProductPrice(this.getCtx(), plvIds[0], prod.get_ID(), priceList, pricePO, pricePO, this.get_TrxName());
                    ppc.saveEx();
                }
            }
        }
    }

    private void createMProductPO(int partnerID, MProduct prod, BigDecimal pricePO, int C_Currency_ID, BigDecimal priceList) {
        MBPartner prov;
        if (partnerID > 0 && (prov = new MBPartner(this.getCtx(), partnerID, this.get_TrxName())) != null) {
            MProductPO pPO = MProductPO.forPartnerAndProduct(partnerID, prod.get_ID(), this.getCtx(), this.get_TrxName());
            if (pPO == null) {
                pPO = new MProductPO(this.getCtx(), 0, this.get_TrxName());
            }
            pPO.setM_Product_ID(prod.get_ID());
            pPO.setC_UOM_ID(prod.getC_UOM_ID());
            pPO.setC_BPartner_ID(partnerID);
            pPO.setIsCurrentVendor(true);
            pPO.setC_Currency_ID(C_Currency_ID);
            pPO.setPriceList(priceList);
            pPO.setPricePO(pricePO);
            pPO.setVendorProductNo(prod.getValue());
            pPO.saveEx();
        }
    }

    private void reloadErrorsIProductAuxiliar(String whereIn) {
        int no = DB.executeUpdateEx("UPDATE " + IMPORT_TABLE + " SET I_ErrorMsg = '' " + whereIn, this.get_TrxName());
    }

    private void loadDataToTableAuxiliar() {
        String sequenceName = "next_id_sprodaux";
        try {
            this.dropTableAuxiliay(TABLE_AUX);
            DB.executeUpdateEx("CREATE SEQUENCE " + sequenceName, this.get_TrxName());
            String selInsert = "SELECT  'Y'::char as " + DATAOK + ",nextval('" + sequenceName + "') as  position, regexp_split_to_table (trim(SizeRatio),'-') as size,* INTO " + TABLE_AUX + " FROM " + IMPORT_TABLE + this.getM_whereClause() + " ORDER BY C_Project_ID,C_BPartner_ID,DeliveryTime_Promised,M_Product_ID";
            DB.executeUpdateEx(selInsert, this.get_TrxName());
            int no2 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM " + TABLE_AUX);
            System.out.println("Insertados - " + no2);
            DB.executeUpdateEx("DROP SEQUENCE IF EXISTS " + sequenceName, this.get_TrxName());
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    private void controllQtyPerSize() {
        StringBuilder str = new StringBuilder("SELECT Count(*),I_ProductAuxiliar_ID from " + TABLE_AUX + " GROUP BY I_ProductAuxiliar_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(str.toString(), this.get_TrxName());
            int errorData = 0;
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int position = rs.getInt(1);
                String sqlQuery = this.getQueryForIProductAuxiliar(position, TABLE_AUX, rs.getInt(2));
                if (sqlQuery.isEmpty()) continue;
                int data = DB.getSQLValue(this.get_TrxName(), sqlQuery);
                if (data > 0) {
                    ++errorData;
                    int c = DB.executeUpdateEx("UPDATE " + IMPORT_TABLE + " SET I_ErrorMsg = '" + ERROR_MGE_OV + "' WHERE I_ProductAuxiliar_ID =" + rs.getInt(2), this.get_TrxName());
                    int n = DB.executeUpdateEx("UPDATE " + TABLE_AUX + " SET I_ErrorMsg = '" + ERROR_MGE_OV + "' , dataOK='N' WHERE I_ProductAuxiliar_ID =" + rs.getInt(2), this.get_TrxName());
                    continue;
                }
                System.out.println(sqlQuery);
            }
            this.addLog(0, null, new BigDecimal(errorData), "-Lineas con error en sus cantidades");
        }
        catch (Exception e) {
            try {
                throw new AdempiereException("Error en la consulta");
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private void createMasivePurchaseOrder() {
        this.reloadErrorsIProductAuxiliar(this.getM_whereClause() + " AND (C_Order_ID IS NOT NULL OR C_Order_ID !=0 ) AND (C_OrderPO_ID IS NULL OR C_OrderPO_ID=0)");
        try {
            this.controllDataForPO();
            this.createPurchaseOrders();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    private void controllDataForPO() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM " + IMPORT_TABLE + this.getM_whereClause() + " AND (C_Order_ID IS NOT NULL OR C_Order_ID !=0 ) AND (C_OrderPO_ID IS NULL OR C_OrderPO_ID=0) AND CreatePO = 'Y' ORDER BY C_Order_ID";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            int orderControled = 0;
            while (rs.next()) {
                if (orderControled != 0 && orderControled == rs.getInt("C_Order_ID")) continue;
                if (null == rs.getObject("pricePO") || rs.getBigDecimal("pricePO").compareTo(Env.ZERO) <= 0) {
                    DB.executeUpdateEx(" UPDATE " + IMPORT_TABLE + " SET I_ErrorMsg = '" + ERROR_MGE_OC_PRICEPO + "' " + this.getM_whereClause() + "AND  C_Order_ID = " + rs.getInt("C_Order_ID"), this.get_TrxName());
                    orderControled = rs.getInt("C_Order_ID");
                }
                if (null != rs.getObject("C_BPartner_2_ID") && rs.getInt("C_BPartner_2_ID") > 0) continue;
                DB.executeUpdateEx(" UPDATE " + IMPORT_TABLE + " SET I_ErrorMsg = I_ErrorMsg || ' - " + ERROR_MGE_OC_PROV + "' " + this.getM_whereClause() + " AND  C_Order_ID = " + rs.getInt("C_Order_ID"), this.get_TrxName());
                orderControled = rs.getInt("C_Order_ID");
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPurchaseOrders() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int lineas;
            String sql = "SELECT DISTINCT(C_Project_ID) FROM " + IMPORT_TABLE + this.getM_whereClause() + " AND (C_Order_ID IS NOT NULL OR C_Order_ID !=0 )  AND (C_OrderPO_ID IS NULL OR C_OrderPO_ID=0) AND CreatePO ='Y' ORDER BY C_Project_ID";
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                OrderPOCreateForProject orders = new OrderPOCreateForProject(null, null, rs.getInt(1), 0, 0, 0, true, this.getCtx(), this.get_TrxName());
                String validate = orders.verifyDataToProcess();
                if (validate.equalsIgnoreCase("OK")) {
                    this.purhaseOrderOk += orders.executeProcess(this.get_TrxName());
                    continue;
                }
                this.mgeErrorOC = this.mgeErrorOC + validate;
            }
            if (this.purhaseOrderOk == 0 & this.mgeErrorOC.isEmpty() && (lineas = DB.getSQLValue(this.get_TrxName(), "SELECT count(C_Project_ID) FROM " + IMPORT_TABLE + this.getM_whereClause() + " AND (C_Order_ID IS NOT NULL OR C_Order_ID !=0 )  AND (C_OrderPO_ID IS NULL OR C_OrderPO_ID=0) AND CreatePO ='Y' AND 0<(select count(a.c_orderline_id) from c_orderline a where a.c_order_id = I_ProductAuxiliar.c_order_id and link_orderline_id is null)")) == 0) {
                this.mgeErrorOC = Env.getLoginLanguage(this.getCtx()).toString().contains("es_MX") ? "Ya se crearon las OC correspondientes" : "Purchase Orders are already created";
                this.lineFrom.setCreatePO("N");
                this.lineFrom.saveEx();
            }
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            this.mgeErrorOC = this.mgeErrorOC + e.getMessage();
        }
        finally {
            DB.close(rs, pstmt);
        }
    }

    private void controllDataTOProcess(String tabla, String where, String mgeError) {
        int qtyInseted = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM " + tabla + where);
        if (qtyInseted <= 0) {
            throw new AdempiereException(mgeError);
        }
    }

    private void processSO(String tableAux) {
        String sql = "SELECT date_trunc('day',DeliveryTime_Promised) as dateDelOrder, * FROM " + tableAux + " WHERE dataok='Y' ORDER BY C_Project_ID,date_trunc('day',DeliveryTime_Promised),position,M_Product_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int m_cProjID = 0;
        boolean m_cBPartnerID = false;
        boolean m_mProductID = false;
        Timestamp deliveryDate = null;
        X_C_Order saleOrder = null;
        String nameProd = "";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            boolean m_IProductAuxiliar_ID = false;
            while (rs.next()) {
                Timestamp dateDelivered = new Timestamp(System.currentTimeMillis());
                if (rs.getTimestamp("dateDelOrder") != null) {
                    dateDelivered = rs.getTimestamp("dateDelOrder");
                }
                if (m_cProjID != rs.getInt("C_Project_ID") || 0 != deliveryDate.compareTo(dateDelivered) || !nameProd.equalsIgnoreCase(rs.getString("Style"))) {
                    this.completeSO((MOrder)saleOrder);
                    nameProd = rs.getString("Style");
                    m_cProjID = rs.getInt("C_Project_ID");
                    deliveryDate = rs.getTimestamp("dateDelOrder");
                    saleOrder = this.createNewSOHeader(rs);
                }
                MOrderLine saleOLine = new MOrderLine((MOrder)saleOrder);
                saleOLine.setC_BPartner_ID(saleOrder.getC_BPartner_ID());
                saleOLine.setC_BPartner_Location_ID(saleOrder.getC_BPartner_Location_ID());
                saleOLine.setM_Product_ID(rs.getInt("M_Product_ID"));
                this.setAttInstanceSetToOrderLine(rs, saleOLine);
                MProject proj = new MProject(this.getCtx(), rs.getInt("C_Project_ID"), null);
                MProductPrice pp = MProductPrice.get(this.getCtx(), proj.getM_PriceList_Version_ID(), rs.getInt("M_Product_ID"), this.get_TrxName());
                if (pp == null || pp.get_ID() <= 0) {
                    pp = new MProductPrice(this.getCtx(), proj.getM_PriceList_Version_ID(), rs.getInt("M_Product_ID"), this.get_TrxName());
                    pp.setPriceList(rs.getBigDecimal("SalePrice"));
                    pp.setPriceLimit(rs.getBigDecimal("SalePrice"));
                    pp.setPriceStd(rs.getBigDecimal("SalePrice"));
                    pp.saveEx();
                }
                BigDecimal qty = this.getQtyPosition(saleOLine, rs.getInt("C_Project_ID"), rs.getInt("M_Product_ID"), rs.getTimestamp("dateDelOrder"), rs.getString("size"));
                saleOLine.setQtyEntered(qty);
                saleOLine.setQtyOrdered(qty);
                saleOLine.setTax();
                saleOLine.setPriceEntered(rs.getBigDecimal("SalePrice"));
                saleOLine.setPriceActual(rs.getBigDecimal("SalePrice"));
                saleOLine.setPriceCost(rs.getBigDecimal("PriceCost"));
                saleOLine.set_ValueOfColumn("FabricSupplier", (Object)rs.getInt("Ref_BPartner_ID"));
                saleOLine.saveEx();
                DB.executeUpdateEx(" UPDATE " + TABLE_AUX + " SET C_Order_ID = " + saleOrder.get_ID() + " WHERE I_ProductAuxiliar_ID =" + rs.getInt("I_ProductAuxiliar_ID"), this.get_TrxName());
            }
            this.completeSO((MOrder)saleOrder);
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private void completeSO(MOrder saleOrder) throws SQLException {
        if (null != saleOrder && saleOrder.processIt("PR")) {
            saleOrder.setDocAction("CO");
            saleOrder.saveEx();
            if (saleOrder.processIt("CO")) {
                ++this.salesOrderCompleteOk;
            }
            saleOrder.setDocStatus("CO");
            saleOrder.saveEx();
            ++this.salesOrderOk;
            this.updateSOID();
            this.commitEx();
        }
    }

    private void updateSOID() {
        String sql = "SELECT DISTINCT(I_ProductAuxiliar_ID),C_Order_ID FROM " + TABLE_AUX + " WHERE C_Order_ID IS NOT NULL AND dataok ='Y' ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DB.executeUpdateEx(" UPDATE " + IMPORT_TABLE + " SET CreatePO = 'Y',CreateSO = 'N', C_Order_ID = " + rs.getInt(2) + " WHERE I_ProductAuxiliar_ID =" + rs.getInt(1), this.get_TrxName());
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private MOrder createNewSOHeader(ResultSet rs) {
        MOrder saleO = null;
        try {
            MProject proj = new MProject(this.getCtx(), rs.getInt("C_Project_ID"), this.get_TrxName());
            saleO = new MOrder(proj, true, "SO");
            saleO.setDropShip_BPartner_ID(saleO.getC_BPartner_ID());
            saleO.setDropShip_Location_ID(saleO.getC_BPartner_Location_ID());
            saleO.setDateOrdered(Env.getContextAsDate(this.getCtx(), "Date"));
            saleO.setDatePromised(rs.getTimestamp("DeliveryTime_Promised"));
            saleO.setC_Currency_ID(proj.getC_Currency_ID());
            int freightCat_ID = rs.getInt("M_FreightCategory_ID");
            if (freightCat_ID > 0) {
                saleO.setM_FreightCategory_ID(freightCat_ID);
            }
            saleO.saveEx();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        return saleO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigDecimal getQtyPosition(MOrderLine salesOL, int mProjectID, int mProductID, Timestamp dateDeliv, String mSize) {
        BigDecimal bigDecimal;
        ResultSet rsPos;
        CPreparedStatement pstmtPos;
        block7: {
            BigDecimal bigDecimal2;
            StringBuilder sqlPos = new StringBuilder("");
            pstmtPos = null;
            rsPos = null;
            try {
                sqlPos.append("SELECT position,size, C_Project_ID,C_BPartner_ID,DeliveryTime_Promised,M_Product_ID,version, * FROM " + TABLE_AUX + " WHERE C_Project_ID = " + mProjectID + " AND DeliveryTime_Promised = '" + dateDeliv + "'  AND M_Product_ID = " + mProductID + " ORDER BY position ");
                pstmtPos = DB.prepareStatement(sqlPos.toString(), this.get_TrxName());
                rsPos = pstmtPos.executeQuery();
                int pos = 1;
                while (rsPos.next()) {
                    if (mSize.trim().equalsIgnoreCase(rsPos.getString(2))) {
                        bigDecimal = rsPos.getBigDecimal(COLNAME_POSITION + pos);
                        break block7;
                    }
                    ++pos;
                }
                bigDecimal2 = Env.ZERO;
            }
            catch (Exception e) {
                try {
                    throw new AdempiereException(e.getMessage());
                }
                catch (Throwable throwable) {
                    DB.close(rsPos, pstmtPos);
                    throw throwable;
                }
            }
            DB.close(rsPos, pstmtPos);
            return bigDecimal2;
        }
        DB.close(rsPos, pstmtPos);
        return bigDecimal;
    }

    private void setAttInstanceSetToOrderLine(ResultSet rs, MOrderLine saleOrderLine) {
        try {
            MProduct producto = new MProduct(this.getCtx(), rs.getInt("M_Product_ID"), null);
            System.out.println(producto.getName());
            MAttributeSet conjDeInstancia = producto.getAttributeSet();
            MAttribute[] atributosDelConjDeInctacia = conjDeInstancia.getMAttributes(true);
            MAttributeValue[] sizes = atributosDelConjDeInctacia[0].getMAttributeValues();
            MAttributeValue sizeAttValue = null;
            PO attSetInstance = null;
            MAttributeInstance attInstance = null;
            for (MAttributeValue av : sizes) {
                if (!av.getValue().trim().toUpperCase().equals(rs.getString("size").trim().toUpperCase())) continue;
                sizeAttValue = av;
                int instanciaID = DB.getSQLValue(this.get_TrxName(), "SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance  WHERE value ='" + rs.getString("size").trim().toUpperCase() + "'  AND M_Attribute_ID = " + atributosDelConjDeInctacia[0].get_ID() + " AND M_AttributeValue_ID =" + av.get_ID());
                if (instanciaID > 0) {
                    attSetInstance = new MAttributeSetInstance(this.getCtx(), instanciaID, null);
                    continue;
                }
                attSetInstance = new MAttributeSetInstance(this.getCtx(), 0, producto.getM_AttributeSet_ID(), null);
                attSetInstance.setAD_Org_ID(producto.getAD_Org_ID());
                ((X_M_AttributeSetInstance)attSetInstance).setDescription(sizeAttValue.getValue());
                attSetInstance.saveEx();
                attInstance = new MAttributeInstance(this.getCtx(), atributosDelConjDeInctacia[0].get_ID(), attSetInstance.get_ID(), av.get_ID(), av.getValue().trim().toUpperCase(), this.get_TrxName());
                attInstance.setAD_Org_ID(producto.getAD_Org_ID());
                attInstance.saveEx();
            }
            if (attSetInstance != null && attSetInstance.get_ID() > 0) {
                saleOrderLine.setM_AttributeSetInstance_ID(attSetInstance.get_ID());
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    private void dropTableAuxiliay(String tableAuxIn) {
        DB.executeUpdateEx("DROP TABLE IF EXISTS " + TABLE_AUX, this.get_TrxName());
    }

    private String getQueryForIProductAuxiliar(int inPos, String tableName, int idImport) {
        StringBuilder ret = new StringBuilder("SELECT count(*) FROM " + tableName + " WHERE I_ProductAuxiliar_ID = " + idImport + " AND ( ");
        int position = 1;
        if (inPos >= 1) {
            ret.append("  (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 2) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 3) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 4) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 5) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 6) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 7) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 8) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 9) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 10) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 11) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 12) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 13) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 14) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 15) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        if (inPos >= 16) {
            ret.append(" OR (size" + position + " is null or size" + position + " = 0) ");
        }
        ++position;
        ret.append(" ) ");
        return ret.toString();
    }
}

