/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MMatchInv;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelValidatorInvoice390
implements ModelValidator {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;
    private int m_AD_Org_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        } else {
            this.log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("M_InOut", this);
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        this.m_AD_User_ID = AD_User_ID;
        return null;
    }

    @Override
    public String modelChange(PO po, int timing) throws Exception {
        MInvoice doc;
        if (!(po instanceof MInvoice) || (doc = (MInvoice)po).isSOTrx() || !(po instanceof MInvoice) || timing == 10) {
            // empty if block
        }
        return null;
    }

    private int updateDocumentNo(MInvoice doc) {
        int qty = 0;
        String docNo = doc.getDocumentNo() + "_" + doc.get_ID();
        qty = DB.executeUpdateEx("update c_invoice set documentno = '" + docNo + "' where c_invoice_id = " + doc.get_ID(), doc.get_TrxName());
        return qty;
    }

    @Override
    public String docValidate(PO po, int timing) {
        if (po instanceof MInvoice && timing == 2) {
            MInvoice doc = (MInvoice)po;
            MDocType docType = new MDocType(doc.getCtx(), doc.getC_DocTypeTarget_ID(), doc.get_TrxName());
            this.deleteMatchInv(doc.getCtx(), doc.get_TrxName(), doc.get_ID(), true);
            if (!doc.isSOTrx() && doc.getDocStatus().equals("CO") && this.updateDocumentNo(doc) > 0) {
                return "";
            }
        } else if (po instanceof MInvoice && timing == 7) {
            MInvoice doc = (MInvoice)po;
            this.verifyInvLines(doc);
        } else if (po instanceof MInvoice && timing == 9) {
            int count;
            MInvoice doc = (MInvoice)po;
            MDocType docType = new MDocType(doc.getCtx(), doc.getC_DocTypeTarget_ID(), doc.get_TrxName());
            if ((docType.getDocBaseType().equalsIgnoreCase("ARC") || docType.getDocBaseType().equalsIgnoreCase("APC")) && (count = DB.getSQLValueEx(doc.get_TrxName(), "select count(*) from uy_allocinvoice where c_invoice_id = " + doc.get_ID(), new Object[0])) == 1) {
                this.generateAllocation(doc);
            }
        } else if (po instanceof MInOut && timing == 2) {
            MInOut doc = (MInOut)po;
            this.deleteMatchInv(doc.getCtx(), doc.get_TrxName(), doc.get_ID(), false);
        }
        return null;
    }

    private void deleteMatchInv(Properties ctx, String trxName, int record_id, boolean IsInvoice) {
        String sql = "";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql = IsInvoice ? "select m.m_matchinv_id from m_matchinv m join c_invoiceline il on m.c_invoiceline_id = il.c_invoiceline_id where il.c_invoice_id = " + record_id : "select m.m_matchinv_id from m_matchinv m join m_inoutline il on m.m_inoutline_id = il.m_inoutline_id where il.m_inout_id = " + record_id;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int matchID = DB.getSQLValueEx(trxName, sql, new Object[0]);
                if (matchID <= 0) continue;
                MMatchInv inv = new MMatchInv(ctx, matchID, trxName);
                inv.deleteEx(true);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void generateAllocation(MInvoice nc) {
        boolean IsAllocated = false;
        BigDecimal multiplier = Env.ONE;
        BigDecimal amount = nc.getGrandTotal();
        int refInvID = DB.getSQLValueEx(nc.get_TrxName(), "select C_AllocInvoice_ID from uy_allocinvoice where c_invoice_id = " + nc.get_ID(), new Object[0]);
        if (refInvID > 0) {
            MInvoice inv = new MInvoice(nc.getCtx(), refInvID, nc.get_TrxName());
            if (inv.isPaid()) {
                throw new AdempiereException("La factura nro. " + inv.getDocumentNo() + " est\u00e1 totalmente asignada");
            }
            BigDecimal amtInvAllocate = DB.getSQLValueBDEx(nc.get_TrxName(), "select invoiceopen(" + refInvID + ", null)", new Object[0]);
            MDocType doc = (MDocType)nc.getC_DocTypeTarget();
            MAllocationHdr alloc = new MAllocationHdr(nc.getCtx(), true, nc.getDateInvoiced(), nc.getC_Currency_ID(), Env.getContext(Env.getCtx(), "#AD_User_Name"), nc.get_TrxName());
            alloc.setAD_Org_ID(nc.getAD_Org_ID());
            alloc.setDescription("Generado automaticamente desde " + doc.getPrintName() + " Nro. " + nc.getDocumentNo());
            alloc.saveEx();
            if (amtInvAllocate.compareTo(nc.getGrandTotal()) < 0) {
                amount = amtInvAllocate;
            }
            if (!nc.isSOTrx()) {
                multiplier = multiplier.negate();
            }
            MAllocationLine aLine = new MAllocationLine(alloc, amount.multiply(multiplier), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setDocInfo(inv.getC_BPartner_ID(), inv.getC_Order_ID(), inv.get_ID());
            aLine.setC_BPartner_ID(inv.getC_BPartner_ID());
            aLine.saveEx();
            multiplier = Env.ONE;
            if (nc.isSOTrx()) {
                multiplier = multiplier.negate();
            }
            aLine = new MAllocationLine(alloc, amount.multiply(multiplier), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setDocInfo(nc.getC_BPartner_ID(), nc.getC_Order_ID(), nc.get_ID());
            aLine.setC_BPartner_ID(nc.getC_BPartner_ID());
            aLine.saveEx();
            if (alloc != null && alloc.get_ID() > 0) {
                if (!alloc.processIt("CO")) {
                    throw new AdempiereException(alloc.getProcessMsg());
                }
                alloc.saveEx();
                IsAllocated = true;
            }
            if (IsAllocated) {
                this.testAllocation(nc);
            }
        }
    }

    private void testAllocation(MInvoice nc) {
        String sql = "";
        BigDecimal open = Env.ZERO;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql = "SELECT coalesce(invoiceOpen(C_Invoice_ID, 0), 0) FROM C_Invoice WHERE C_Invoice_ID=?";
        open = DB.getSQLValueBD(nc.get_TrxName(), sql, nc.get_ID());
        if (open != null && open.signum() == 0) {
            sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + nc.get_ID();
            int n = DB.executeUpdate(sql, nc.get_TrxName());
        }
        sql = "select * from uy_allocinvoice where c_invoice_id = " + nc.get_ID();
        try {
            pstmt = DB.prepareStatement(sql, nc.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer invoiceID = rs.getInt("C_AllocInvoice_ID");
                sql = "SELECT coalesce(invoiceOpen(C_Invoice_ID, 0), 0) FROM C_Invoice WHERE C_Invoice_ID=?";
                open = DB.getSQLValueBD(nc.get_TrxName(), sql, invoiceID);
                if (open == null || open.signum() != 0) continue;
                sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + invoiceID;
                int n = DB.executeUpdate(sql, nc.get_TrxName());
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void verifyInvLines(MInvoice doc) {
        String sql = "select c_invoiceline_id from c_invoiceline where c_invoice_id = " + doc.get_ID() + " and m_product_id is null and c_charge_id is null";
        int lineID = DB.getSQLValueEx(doc.get_TrxName(), sql, new Object[0]);
        if (lineID > 0) {
            throw new AdempiereException("Todas las lineas deben tener un producto o cargo");
        }
    }
}

