/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.openup.core.model.X_UY_ViaLoan;

public class MViaLoan
extends X_UY_ViaLoan {
    public MViaLoan(Properties ctx, int UY_ViaLoan_ID, String trxName) {
        super(ctx, UY_ViaLoan_ID, trxName);
    }

    public MViaLoan(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MViaLoan via;
        if ((newRecord || this.is_ValueChanged("PlateNo")) && (via = this.forPlateNo(this.getCtx(), this.getPlateNo(), this.get_TrxName())) != null) {
            throw new AdempiereException("Ya existe una via para la matricula ingresada");
        }
        return true;
    }

    public MViaLoan forPlateNo(Properties ctx, String plate, String trxName) {
        if (Util.isEmpty(plate, true)) {
            return null;
        }
        MViaLoan via = null;
        String whereClause = "trim(lower(plateno))=? AND AD_Client_ID=? AND UY_ViaLoan_ID <> " + this.get_ID();
        via = (MViaLoan)new Query(ctx, "UY_ViaLoan", whereClause, trxName).setParameters(plate.toLowerCase().trim(), this.getAD_Client_ID()).setOnlyActiveRecords(false).first();
        return via;
    }

    public static List<MViaLoan> getViasForPartner(int partnerID, Properties ctx) {
        String whereClause = "C_BPartner_ID = " + partnerID + " AND " + "IsActive" + " = 'Y' AND " + "IsSelected" + " = 'Y' AND " + "IsClosed" + " = 'N'";
        List<MViaLoan> lines = new Query(ctx, "UY_ViaLoan", whereClause, null).list();
        return lines;
    }

    public static BigDecimal getCapital(int viaID) {
        String sql = "";
        BigDecimal amt = Env.ZERO;
        if (viaID <= 0) {
            return amt;
        }
        sql = "select coalesce(grandtotal,0) from vuy_vialoan where uy_vialoan_id = " + viaID;
        amt = DB.getSQLValueBDEx(null, sql, new Object[0]);
        return amt;
    }
}

